//=============================================================================
// RPG_Master.
//=============================================================================
class RPG_Master expands Pack6Pawns;

var vector MoveVec,OldVect,EnemyVec;
var Actor MoveAct;
var Name OldState;
var bool WaitingForBattle,bAllow,bMyTurn,bCanTakeDamage;
var BattleBup BB;
var Pawn THEEnemy;

function PlayRunning()
{
	LoopAnim('SLITHER');
}
Auto state NotFighting
{
	event HearNoise( float Loudness, Actor NoiseMaker)
	{
		if( NoiseMaker.IsA('Pawn') )
			SetEnemy(Pawn(NoiseMaker));
	}
	event SeePlayer( actor Seen )
	{
		if( Seen.IsA('Pawn') )
			SetEnemy(Pawn(Seen));
	}
	function bool SetEnemy(Pawn NewEnemy)
	{
		if( NewEnemy.IsA('RPG_Master') || NewEnemy.Health<=0 ) Return False;
		if( NewEnemy!=Enemy )
			PlaySound(Acquire, SLOT_Talk);
		Enemy = NewEnemy;
		if ( !bFirstHatePlayer && NewEnemy.bIsPlayer && (FirstHatePlayerEvent != '') )
			TriggerFirstHate();
		Enable('Bump');
		Return true;
	}
	function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, 
					Vector momentum, name damageType)
	{
		if (Physics == PHYS_None)
			SetMovementPhysics();
		if (Physics == PHYS_Walking)
			momentum.Z = FMax(momentum.Z, 0.4 * VSize(momentum));
		if ( instigatedBy == self )
			momentum *= 0.6;
		momentum = momentum/Mass;
		AddVelocity( momentum );
		if( Health<=0 )
			Died(instigatedBy, damageType, HitLocation);
		SetEnemy(instigatedBy);
	}
	Event BeginState()
	{
		Enemy=None;
		SetMovementPhysics();
		OldState = 'NotFighting';
		Disable('Bump');
		bMovable=true;
		SetTimer(1,true);
		if( BB!=None ) BB.Destroy();
	}
	function Timer()
	{
		bAllow=true;
		if( Enemy==None || !LineOfSightTo(Enemy) )
			CheckVisibleEnemys();
		bMovable=true;
		if( Enemy!=None && VSize(Enemy.Location - Location)<80 )
		{
			THEEnemy = Enemy;
			Enemy.ClientMessage("Acquired with"@MenuName);
			Enemy.bMovable = False;
			GoToState('Stay');
		}
	}
	function Bump(actor Other)
	{
		if( Other.IsA('Pawn') && Pawn(Other).Health>0 && Pawn(Other).Class!=None )
		{
			if( Enemy==Pawn(Other) && bAllow )
			{
				THEEnemy = Enemy;
				Pawn(Other).ClientMessage("Acquired with"@MenuName);
				Pawn(Other).bMovable = False;
				GoToState('Stay');
			}
		}
	}
Begin:
	PlayRunning();
	if( Enemy!=None && (Enemy.Health<0 || Enemy.Class==None) ) Enemy=None;
	if( Enemy!=None ) GoTo('MoveToEnemy');
	MoveVec = Location;
	MoveVec.X += Rand(1000)-500;
	MoveVec.Y += Rand(1000)-500;
	MoveVec.Z += Rand(1000)-500;
	if( OldVect==MoveVec ) Sleep(1);
	else OldVect=MoveVec;
	PlaySound(Acquire, SLOT_Talk);
	MoveTo(MoveVec,GroundSpeed/4);
	GoTo('Begin');
MoveToEnemy:
	if( !actorReachable(Enemy) )
	{
		MoveAct = FindPathToward(Enemy);
		if( MoveAct!=None )
		{
			if( OldVect==MoveAct.Location ) Sleep(1);
			else OldVect=MoveAct.Location;
			MoveToward(MoveAct,GroundSpeed);
			if( Enemy!=None && (Enemy.Health<0 || Enemy.Class==None) ) Enemy=None;
			if( Enemy!=None ) GoTo('MoveToEnemy');
			else GoTo('Begin');
		}
	}
	MoveVec=Enemy.Location;
	if( OldVect==MoveVec ) Sleep(0.1);
	else OldVect=MoveVec;
	MoveTo(MoveVec,GroundSpeed);
	GoTo('Begin');
}
state Stay
{
Ignores TakeDamage,SetEnemy,Bump,Touch;
	event HearNoise( float Loudness, Actor NoiseMaker);
	event SeePlayer( actor Seen );
	Event BeginState()
	{
		if( Enemy==None ) GoToState('NotFighting');
		OldState = 'Stay';
	}
Begin:
	EnemyVec = Enemy.Location;
	LoopAnim('Breath');
	SetPhysics(PHYS_None);
	if( !WaitingForBattle )
	{
		WaitingForBattle = True;
		PlaySound(Sound'scaryN4');
		BB = Spawn(class'BattleBup');
		BB.BattlePawns[0] = Self;
		BB.BattlePawns[1] = Enemy;
	}
	else GoToState('FIGHT');
	Sleep(2);
	GoToState('FIGHT');
}
state FIGHT
{
Ignores SetEnemy;
	event HearNoise( float Loudness, Actor NoiseMaker);
	event SeePlayer( actor Seen );
	Event BeginState()
	{
		if( Enemy==None ) GoToState('NotFighting');
		WaitingForBattle = false;
		OldState = 'FIGHT';
		bMovable=False;
	}
	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		local int actualDamage;
		local bool bAlreadyDead;
		local Actor A;
	
		if( !bCanTakeDamage ) Return;
		//log(self@"take damage in state"@GetStateName());	
		bAlreadyDead = (Health <= 0);
	
		if (Physics == PHYS_None)
			SetMovementPhysics();
		if (Physics == PHYS_Walking)
			momentum.Z = FMax(momentum.Z, 0.4 * VSize(momentum));
		if ( instigatedBy == self )
			momentum *= 0.6;
		momentum = momentum/Mass;
		AddVelocity( momentum ); 
	
		actualDamage = Level.Game.ReduceDamage(Damage, DamageType, self, instigatedBy);

		if (ReducedDamageType == 'All') //God mode
			actualDamage = 0;
		else if (Inventory != None) //then check if carrying armor
			actualDamage = Inventory.ReduceDamage(actualDamage, DamageType, HitLocation);
		else
			actualDamage = Damage;
		
		Health -= actualDamage;
		if (CarriedDecoration != None)
			DropDecoration();
		if ( HitLocation == vect(0,0,0) )
			HitLocation = Location;
		if (Health > 0)
		{
			if (instigatedBy != None)
				damageAttitudeTo(instigatedBy);
			PlayHit(actualDamage, hitLocation, damageType, Momentum.Z);
		}
		else
		{
			//log(self$" died");
			NextState = '';
			PlayDeathHit(actualDamage, hitLocation, damageType);
			if ( actualDamage > mass )
				Health = -1 * actualDamage;
			Enemy.bMovable = true;
			bMovable = true;
			Enemy.ClientMessage(Enemy.GetHumanName()@"won the battle, recived"@Rand(20)+5@"exp. points :P");
			if( BB!=None ) BB.Destroy();
			SpawnGibbedCarcass();
			if( Event != '' )
				foreach AllActors( class 'Actor', A, Event )
					A.Trigger( Self, instigatedBy );
			Destroy();
		}
		MakeNoise(1.0);
		if( Health>0 )
		{
			Enemy.ClientMessage(actualDamage@"damage to"@MenuName);
			GoToState('FIGHT','EnemyTurn');
		}
	}
	function Damage( int Damage )
	{
		local int i;
		
		Damage+=Rand(20)-10;
		if( FRand()<0.2 )
		{
			i = 1;
			Damage*=2;
		}
		else if( FRand()<0.2 )
		{
			i = 2;
			Damage*=0;
		}
		if( i==0 )
			Enemy.ClientMessage(Damage@"damage to"@Enemy.GetHumanName());
		else if( i==1 ) Enemy.ClientMessage(Damage@"immortal damage up on"@Enemy.GetHumanName());
		else Enemy.ClientMessage(MenuName@"missed the target");
		Enemy.TakeDamage(Damage,Self,Location,vect(0,0,0),'Hacked');
	}
	function Tick(float DeltaTime)
	{
		Velocity=vect(0,0,0);
		if( Enemy!=None )
			Enemy.Velocity=vect(0,0,0);
		Enemy = THEEnemy;
	}
Begin:
	if( Enemy==None || Enemy.Class==None || Enemy.bDeleteMe )
	{
		Enemy = None;
		GoToState('NotFighting');
	}
	if( Enemy.IsA('ScriptedPawn') )
		ScriptedPawn(Enemy).SetEnemy(Self);
	Enemy.bMovable=true;
	Enemy.SetLocation(EnemyVec);
	Enemy.ClientMessage("Your turn");
	bCanTakeDamage=True;
	Sleep(10);
	Enemy.ClientMessage("You didnt attack in 10 sec");
	GoTo('EnemyTurn');
EnemyTurn:
	if( Enemy.IsA('ScriptedPawn') )
	{
		ScriptedPawn(Enemy).Enemy=None;
		ScriptedPawn(Enemy).GoToState('Waiting');
	}
	Enemy.SetLocation(EnemyVec);
	bCanTakeDamage=False;
	Enemy.ClientMessage(MenuName@"attacks...");
	FinishAnim();
	ViewRotation=rotator(Enemy.Location - Location);
	Sleep(0.5);
	if( FRand()<0.4 )
	{
		Enemy.ClientMessage(MenuName@"attacks with slimed claws");
		PlayAnim('CLAW2');
		FinishAnim();
		Damage(50);
	}
	else if( FRand()<0.3 )
	{
		Enemy.ClientMessage(MenuName@"attacks with REALLY slimed claws");
		PlayAnim('SLASH');
		FinishAnim();
		Damage(60);
	}
	else if( FRand()<0.3 )
	{
		Enemy.ClientMessage(MenuName@"throws a slimeball");
		PlayAnim('Shoot1');
		FinishAnim();
		Sleep(0.5);
		Damage(70);
	}
	else
	{
		Enemy.ClientMessage(MenuName@"makes Crash-BOOM attack");
		PlayAnim('DIVE');
		FinishAnim();
		Damage(100);
	}
	if( Enemy.Health<0 || Enemy.Class==None )
	{
		Enemy.ClientMessage(Enemy.GetHumanName()@"got hurt and collapse");
		bAllow=False;
		Enemy = None;
		bMovable=true;
		GoToState('NotFighting');
	}
	LoopAnim('Breath');
	GoToState('FIGHT','Begin');
}
function Tick(float DeltaTime)
{
	if( !IsInState('NotFighting') && !IsInState('Stay') && !IsInState('FIGHT') )
		GoToState(OldState);
}
function Destroyed()
{
	if( BB!=None ) BB.Destroy();
	Super.Destroyed();
}

defaultproperties
{
     Aggressiveness=0.700000
     RefireRate=0.400000
     bHasRangedAttack=True
     RangedProjectile=Class'UnrealShare.SlithProjectile'
     Acquire=Sound'UnrealShare.Slith.yell1sl'
     MeleeRange=50.000000
     Health=500
     CombatStyle=0.850000
     DrawType=DT_Mesh
     Style=STY_Masked
     Mesh=LodMesh'UnrealShare.Slith1'
     CollisionRadius=48.000000
     CollisionHeight=44.000000
}
