//=============================================================================
// SayLogger.
//=============================================================================
class SayLogger expands Pawn;

var ChatLog LogList; // Chat log chain DOH!

event PostBeginPlay()
{
	bIsPlayer = True;
	SetTimer(1,true);
}
function InitPlayerReplicationInfo()
{
	if (PlayerReplicationInfo != None)
		PlayerReplicationInfo.Destroy();
}
event TeamMessage( PlayerReplicationInfo PRI, coerce string S, name Type )
{
	local DaPRI PR;
	
	if( LogList!=None )
		LogList.ReciveNewMsg(PRI.PlayerName$":"@S);
	ForEach AllActors(class'DaPRI',PR)
	{
		if( PR.Owner==PRI.Owner )
		{
			PR.Says[9] = PR.Says[8];
			PR.Says[8] = PR.Says[7];
			PR.Says[7] = PR.Says[6];
			PR.Says[6] = PR.Says[5];
			PR.Says[5] = PR.Says[4];
			PR.Says[4] = PR.Says[3];
			PR.Says[3] = PR.Says[2];
			PR.Says[2] = PR.Says[1];
			PR.Says[1] = PR.Says[0];
			PR.Says[0] = S;
			Return;
		}
	}
}
function Killed(pawn Killer, pawn Other, name damageType)
{
	local AdminMag AM;
	local Inventory I;
	
	if( LogList!=None )
		LogList.ReciveNewMsg(Other.GetHumanName()@"was"@string(damageType)@"by"@Killer.GetHumanName());
	ForEach AllActors(class'AdminMag',AM)
	{
		AM.NewDeathMessage = Other.GetHumanName()@"was"@string(damageType)@"by"@Killer.GetHumanName();
		AM.bNewDeath=true;
	}
	if( Other!=None && Killer!=None && Other!=Killer && Other.Inventory!=None && Killer.Health>0 )
	{
		For( I=Other.Inventory; I!=None; I=I.Inventory )
		{
			if( MightyRevenge(I)!=None )
			{
				MightyRevenge(I).ArghEnemy(Killer);
				Return;
			}
		}
	}
}
function Destroyed()
{
	bIsPlayer = False;
	Super.Destroyed();
}
function Timer()
{
	local Pawn P;
	
	For( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if( P.bIsPlayer && SayLogger(P)==None && P.Spree==P.Default.Spree )
		{
			P.Spree++;
			if( LogList!=None )
				LogList.ReciveNewMsg(P.GetHumanName()@"entered the game.");
		}
	}
}

defaultproperties
{
     bHidden=True
     bCanTeleport=False
     bMovable=False
     bDirectional=False
     bCollideActors=False
     bBlockActors=False
     bBlockPlayers=False
     bProjTarget=False
}
