//=============================================================================
// ScrewEffect.
//=============================================================================
class ScrewEffect expands SBEffect;

var bool bChecked;

simulated function Tick(float DeltaTime)
{
	local Pawn P;
	
	SetLocation(Owner.Location);
	DrawScale = Owner.CollisionHeight/40+40*FRand();
	if( !bChecked && Owner.Physics==PHYS_Falling )
	{
		bChecked = True;
		bHidden = False;
		AmbientSound = Sound'AmbModern.bigelec7';
		Owner.Velocity*=3;
	}
	else if( bChecked && Owner.Physics!=PHYS_Falling )
	{
		bChecked = False;
		bHidden = True;
		AmbientSound = None;
	}
	if( bChecked && Level.NetMode!=NM_Client )
		For( P=Level.PawnList; P!=None; P=P.NextPawn )
			if( P!=Owner && VSize(P.Location-Owner.Location)<Owner.CollisionHeight+P.CollisionHeight+50 )
				P.TakeDamage(50,Pawn(Owner),(Owner.Location-P.Location)/2+P.Location,Owner.Location-P.Location,'zapped');
}

defaultproperties
{
     Physics=PHYS_None
     Mesh=LodMesh'UnrealShare.flameballM'
     bOwnerNoSee=False
     SoundVolume=255
}
