//=============================================================================
// ShadowTrooper.
//=============================================================================
class ShadowTrooper expands HumanPawn;

var Weapon Weps[3];
var pickup Amp;
var int LevelSkill;

auto state Startup
{
	function BeginState()
	{
		Super.BeginState();
		bIsPlayer = true;
		Weps[0] = Spawn(Class'GreatDisp');
		if ( Weps[0] != None )
		{
			Weps[0].ReSpawnTime = 0.0;
			Weps[0].Touch(self);
		}
		Weps[1] = Spawn(Class'ScreemMag');
		if ( Weps[1] != None )
		{
			Weps[1].ReSpawnTime = 0.0;
			Weps[1].Touch(self);
		}
		Weps[2] = Spawn(Class'ASMD');
		if ( Weps[2] != None )
		{
			Weps[2].ReSpawnTime = 0.0;
			Weps[2].Touch(self);
		}
		Amp = Spawn(Class'Amplifier');
		if ( Amp != None )
		{
			Amp.ReSpawnTime = 0.0;
			Amp.Touch(self);
		}
		Weapon = Weps[0];
		bIsPlayer = false;
	}
}
function ChangedWeapon()
{
	Super(ScriptedPawn).ChangedWeapon();
	//bIsPlayer = false;
	bMovingRangedAttack = true;
	bHasRangedAttack = true;
	Weapon.AimError += 20;
	Weapon.FireOffset = Weapon.FireOffset * 1.5 * DrawScale;
	Weapon.PlayerViewOffset = Weapon.PlayerViewOffset * 1.5 * DrawScale; 
	Weapon.SetHand(0);
}
function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	local WeaponPowerUp WEP;
	
	Super.TakeDamage(Damage,instigatedBy,hitlocation,momentum,damageType);
	
	if( Health<1000 && LevelSkill==0 )
	{
		LevelSkill++;
		Weapon = Weps[1];
	}
	else if( Health<800 && LevelSkill==1 )
	{
		LevelSkill++;
		Weapon = Weps[0];
		bIsPlayer = true;
		WEP = Spawn(Class'WeaponPowerUp');
		if ( WEP != None )
		{
			WEP.ReSpawnTime = 0.0;
			WEP.Touch(self);
		}
		bIsPlayer = false;
	}
	else if( Health<600 && LevelSkill==2 )
	{
		LevelSkill++;
		Weapon = Weps[0];
		bIsPlayer = true;
		WEP = Spawn(Class'WeaponPowerUp');
		if ( WEP != None )
		{
			WEP.ReSpawnTime = 0.0;
			WEP.Touch(self);
		}
		bIsPlayer = false;
	}
	else if( Health<400 && LevelSkill==3 )
	{
		LevelSkill++;
		Weapon = Weps[0];
		bIsPlayer = true;
		WEP = Spawn(Class'WeaponPowerUp');
		if ( WEP != None )
		{
			WEP.ReSpawnTime = 0.0;
			WEP.Touch(self);
		}
		bIsPlayer = false;
	}
	else if( Health<200 && LevelSkill==4 )
	{
		LevelSkill++;
		Weapon = Weps[2];
		Amp.Activate();
		Amp.Charge = 9999999;
	}
}

defaultproperties
{
     CarcassType=Class'UnrealI.MaleOneCarcass'
     MeleeRange=0.000000
     Health=1200
     Skin=None
     Mesh=LodMesh'UnrealI.Male1'
     ScaleGlow=0.050000
}
