//=============================================================================
// SkaarjHunter.
//=============================================================================
class SkaarjHunter expands SkaarjTrooper;

var float C;
var() texture RandTexture[4];

function PostBeginPlay()
{
	local weapon W;
	W = Spawn(WeaponType);
	if( W!=None )
	{
		W.RespawnTime=0;
		bIsPlayer=true;
		W.Touch(Self);
		bIsPlayer=false;
		Weapon = W;
	}
}
function bool SetEnemy( Pawn NewEnemy )
{
	Return SetRealEnemy(NewEnemy,Self,'Wandering','Attacking');
}
function bool SetRealEnemy( Pawn NewEnemy, Pawn Hater, name ReadyStates, name AttackState )
{
	local EAttitude Temp;
	
	if( NewEnemy==None || NewEnemy.bDeleteMe || NewEnemy.Health<=0 || NewEnemy==Self ) Return false;
	if( FlockPawn(NewEnemy)!=None || FlockMasterPawn(NewEnemy)!=None ) Return false;
	
	if( !NewEnemy.bIsPlayer )
	{
		if( ScriptedPawn(Hater)!=None )
			Temp = ScriptedPawn(Hater).AttitudeToCreature(NewEnemy);
		else if( NewEnemy.Class==Hater.Class )
			Temp = ATTITUDE_Friendly;
		else Temp = ATTITUDE_Hate;
	}
	else Temp = Hater.AttitudeToPlayer;
	
	if( Temp~=ATTITUDE_Friendly || Temp~=ATTITUDE_Follow || (Temp~=ATTITUDE_Ignore && FRand()<0.6) )
		Return False;
	if( ScriptedPawn(Hater)!=None && ScriptedPawn(Hater).OldEnemy!=NewEnemy )
		ScriptedPawn(Hater).OldEnemy=NewEnemy;
	Hater.Enemy = NewEnemy;
	if( !IsInState('Attacking') && !IsInState('RangedAttack') && !IsInState('MeleeAttack') 
	 && !IsInState('TakeHit') && !IsInState('FallingState') && !IsInState('Hunting')
	 && !IsInState('TacticalMove') )
		Hater.GoToState(AttackState);
	if( NewEnemy.bIsPlayer && ScriptedPawn(Hater)!=None && !ScriptedPawn(Hater).bFirstHatePlayer
	 && (ScriptedPawn(Hater).FirstHatePlayerEvent != '') )
		ScriptedPawn(Hater).TriggerFirstHate();
	Return True;
}
function Tick(float DeltaTime)
{
	local Pawn P;
	
	C+=DeltaTime;
	if( C>=4 )
	{
		C=0;
		CheckVisibleEnemys();
	}
}
function bool CheckVisibleEnemys()
{
	local Pawn P;
	local vector HitL,HitN;
	local Actor TraceActor;
	
	For( P=Level.PawnList; P!=None; P=P.NextPawn )
	{
		if( VSize(P.Location-Location)<3000 && FlockPawn(P)==None &&
		 FlockMasterPawn(P)==None && P.Health>0 && !P.bHidden )
		{
			TraceActor = Trace(HitL,HitN,P.Location,Location);
			if( (TraceActor==P || TraceActor==None) && SetEnemy(P) )
				Return True;
		}
	}
	Return false;
}
auto state Startup
{
	function BeginState()
	{
		Super(Skaarj).BeginState();
		SetPhysics(PHYS_Falling);
	}
}
function ChangedWeapon()
{
	Super.ChangedWeapon();
	bIsPlayer = false;
	bMovingRangedAttack = true;
	bHasRangedAttack = true;
	Weapon.AimError += 20;
	Weapon.FireOffset = Weapon.FireOffset * 1.5 * DrawScale;
	Weapon.PlayerViewOffset = Weapon.PlayerViewOffset * 1.5 * DrawScale; 
	Weapon.SetHand(1);
}
state TacticalMove
{
ignores SeePlayer, HearNoise;

	function PickDestination(bool bNoCharge)
	{
		if ( FRand() < 0.26 )
			GotoState('DoSpecialAttack');
		else if ( FRand() < 0.46 )
			GotoState('DoSpecialAttackSec');
		else
			Super.PickDestination(bNoCharge);
	}
}
State DoSpecialAttack
{
ignores TakeDamage, SeePlayer, EnemyNotVisible, HearNoise, KilledBy, Bump, HitWall, HeadZoneChange, FootZoneChange, ZoneChange, Falling, WarnTarget, Died;

	function Tick(float DeltaTime)
	{
		MultiSkins[1] = RandTexture[Rand(4)];
	}
	function BeginState()
	{
		Acceleration = Vect(0,0,0);
	}
	function EndState()
	{
		bUnlit = false;
		Style = STY_Normal;
		ScaleGlow = 1.0;
		fatness = Default.fatness;
		MultiSkins[1] = None;
	}
Begin:
	PlayAnim('lunge');
	FinishAnim();
	PlayAnim('ShldUp');
	FinishAnim();
	LoopAnim('ShldLand');
	ViewRotation=rotator(Enemy.Location - Location);
	SetRotation(rotator(Enemy.Location - Location));
	Sleep(0.1);
	Spawn(class'EBubbelProj',,,,rotator(Enemy.Location - Location));
	Sleep(1);
	PlayAnim('ShldDown');
	FinishAnim();
	GoToState('Attacking');
}
State DoSpecialAttackSec
{
ignores TakeDamage, SeePlayer, EnemyNotVisible, HearNoise, KilledBy, HitWall, HeadZoneChange, FootZoneChange, ZoneChange, Falling, WarnTarget, Died;

	function Tick(float DeltaTime)
	{
		SetPhysics(PHYS_Flying);
		SetRotation(rotator(Enemy.Location - Location));
		ViewRotation=rotator(Enemy.Location - Location);
		Velocity = vector(ViewRotation)*6000;
		Acceleration = vector(ViewRotation)*1000;
	}
	function Bump (Actor Other)
	{
		if( Other==None || Other.IsA('SkaarjHunter') ) Return;
		Other.TakeDamage(LungeDamage/3,Self,Enemy.Location-Location,200 * Velocity,'hacked' );
		PlaySound(Slice, SLOT_Interact);
	}
	function BeginState()
	{
		Acceleration = Vect(0,0,0);
		Enable('Bump');
	}

	function EndState()
	{
		bUnlit = false;
		Style = STY_Normal;
		ScaleGlow = 1.0;
		fatness = Default.fatness;
	}
Begin:
	PlayAnim('lunge',0.3);
	Enable('Bump');
	FinishAnim();
	SetPhysics(PHYS_Falling);
	GoToState('Attacking');
}
function eAttitude AttitudeToCreature(Pawn Other)
{
	if ( !Other.IsA('SkaarjHunter') )
		return ATTITUDE_Hate;
	else
		return ATTITUDE_Friendly;
}
function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	if ( !bIsPlayer && Inventory!=None )
		Super.TakeDamage(Inventory.ReduceDamage(Damage, DamageType, HitLocation),
		instigatedBy,hitlocation,momentum,damageType);
	else Super.TakeDamage(Damage,instigatedBy,hitlocation,momentum,damageType);
}

defaultproperties
{
     RandTexture(0)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.BlueShield'
     RandTexture(1)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.Greenshield'
     RandTexture(2)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.N_Shield'
     RandTexture(3)=FireTexture'UnrealShare.Belt_fx.ShieldBelt.RedShield'
     WeaponType=Class'Pack6.GravityKiller'
     LungeDamage=156
     SpinDamage=117
     ClawDamage=112
     Orders=wandering
     Health=700
     Texture=Texture'UnrealShare.Belt_fx.ShieldBelt.newgreen'
     Skin=Texture'UnrealShare.Belt_fx.ShieldBelt.newgreen'
}
