//=============================================================================
// SkaarjRain.
//=============================================================================
class SkaarjRain expands Pickup;

var SkaarjRainEffect TheEffects[2];
auto state Pickup
{	
	function BeginState()
	{
		Super.BeginState();
		
		LoopAnim('Breath2');
		if( TheEffects[0]==None )
		{
			TheEffects[0] = Spawn(class'SkaarjRainEffect',Self,,Location+VRand()*40);
			if( TheEffects[0]!=None )
				TheEffects[0].Velocity = VRand()*100;
		}
		if( TheEffects[1]==None )
		{
			TheEffects[1] = Spawn(class'SkaarjRainEffect',Self,,Location+VRand()*40);
			if( TheEffects[1]!=None )
				TheEffects[1].Velocity = VRand()*100;
		}
	}
	function EndState()
	{
		if( TheEffects[0]!=None )
		{
			TheEffects[0].Destroy();
			TheEffects[0] = None;
		}
		if( TheEffects[1]!=None )
		{
			TheEffects[1].Destroy();
			TheEffects[1] = None;
		}
		LifeSpan = 0;
		Super.EndState();
	}
}
function Destroyed()
{
	if( TheEffects[0]!=None )
	{
		TheEffects[0].Destroy();
		TheEffects[0] = None;
	}
	if( TheEffects[1]!=None )
	{
		TheEffects[1].Destroy();
		TheEffects[1] = None;
	}
	Super.Destroyed();
}
state Activated  // Delete from inventory
{
	function BeginState()
	{
		Pawn(Owner).ClientMessage("Oh! Seams like its getting rain");
		Spawn(class'RainSkaarjsRAIN',Owner,,Owner.Location);
		Destroy();
	}
}
function PickupFunction(Pawn Other)
{
	if( PlayerPawn(Owner)==None )
		SetTimer(6+10*FRand(),false);
}

function Timer()
{
	if( PlayerPawn(Owner)==None )
		Activate();
}

defaultproperties
{
     bActivatable=True
     bDisplayableInv=True
     PickupMessage="You discovered the rainy time of skaarjs"
     ItemName="Skaarj Rain"
     PickupViewMesh=LodMesh'UnrealShare.Skaarjw'
     PickupViewScale=0.250000
     Charge=1
     PickupSound=Sound'Ambancient.OneShot.scaryN2'
     Icon=Texture'Engine.S_Corpse'
     Style=STY_Masked
     Texture=FireTexture'XFX.elextropink'
     Skin=FireTexture'XFX.elextropink'
     Mesh=LodMesh'UnrealShare.Skaarjw'
     DrawScale=0.250000
     bMeshEnviroMap=True
}
