//=============================================================================
// SkaarjRainEffect.
//=============================================================================
class SkaarjRainEffect expands Decoration;

function PostBeginPlay()
{
	Super.PostBeginPlay();
	
	if( Owner==None )
		Destroy();
}

simulated function Tick( float DeltaTime )
{
	if( Level.NetMode==NM_DedicatedServer )
		Return;
	
	if( Physics!=PHYS_Projectile )
		SetPhysics(PHYS_Projectile);
	if( AnimSequence!='Walk' )
		LoopAnim('Walk');
	Velocity += Sim(Owner.Location-Location)*800*DeltaTime;
	SetRotation(rotator(Owner.Location-Location));
}

simulated function vector Sim( vector Ve )
{
	local float Maxest,Cur;
	
	if( Ve.X>=0 )
		Maxest = Ve.X;
	else Maxest = Ve.X*-1;
	if( Ve.Y>=0 )
		Cur = Ve.Y;
	else Cur = Ve.Y*-1;
	if( Cur>Maxest )
		Maxest = Cur;
	if( Ve.Z>=0 )
		Cur = Ve.Z;
	else Cur = Ve.Z*-1;
	if( Cur>Maxest )
		Maxest = Cur;
	Return (Ve/Maxest);
}
function Destroyed()
{
	local actor dropped, A;

	if( (Pawn(Base) != None) && (Pawn(Base).CarriedDecoration == self) )
		Pawn(Base).DropDecoration();
	if( Event != '' )
		foreach AllActors( class 'Actor', A, Event )
			A.Trigger( Self, None );
			
	Super(Actor).Destroyed();
}

defaultproperties
{
     bStatic=False
     Physics=PHYS_Projectile
     RemoteRole=ROLE_SimulatedProxy
     DrawType=DT_Mesh
     Style=STY_Translucent
     Texture=FireTexture'UnrealShare.Belt_fx.Testing.Effect_2'
     Skin=FireTexture'UnrealShare.Belt_fx.Testing.Effect_2'
     Mesh=LodMesh'UnrealShare.Skaarjw'
     DrawScale=0.200000
     bMeshEnviroMap=True
     bCollideWorld=True
     bBounce=True
     Buoyancy=1.000000
}
