//=============================================================================
// SmokeGrenade.
//=============================================================================
class SmokeGrenade expands HeGrenade;

state Activated  // Delete from inventory and toss in front of player.
{
	function Timer()
	{
		local BigBlackSmoke b;
		local Pawn Victims;
		local int i;
		
		if( bFirstTick )
		{
			bFirstTick=False;
			PlaySound(ActivateSound);
			SetTimer(0,False);
			Enable('Touch');
			Return;
		}
		For( i=0; i<5; i++ )
		{
			b = Spawn(class'BigBlackSmoke',,,Location+VRand()*50);
			if( b!=None )
				b.DrawScale = 2+FRand()*3;
		}
		foreach VisibleCollidingActors( class 'Pawn', Victims, 200, Location )
			if( PlayerPawn(Victims)==None && Victims!=Instigator )
				AddFireFor(Victims);
		Charge--;
		if (Charge<=0) TakeDamage(10,None, Vect(0,0,0), Vect(0,0,0), 'Detonated');
	}
	function HitWall( vector HitNormal, actor Wall )
	{
		Velocity = 0.6*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
		PlaySound(Sound'UnrealShare.Eightball.GrenadeFloor', SLOT_Misc);
		bRotatetoDesired=True;
		bFixedRotationDir=False;
		DesiredRotation.Pitch=0;	
		DesiredRotation.Yaw=FRand()*65536;
		DesiredRotation.Roll=0;		
		RotationRate.Yaw = RotationRate.Yaw*0.75;
		RotationRate.Roll = RotationRate.Roll*0.75;
		RotationRate.Pitch = RotationRate.Pitch*0.75;	
		If (VSize(Velocity) <60)
		{
			bBounce = False;
			SetPhysics(PHYS_None);
			SetTimer(0.5,True);
		}
	}
}
function AddFireFor( Actor Other )
{
	local ParalyseThing bt;
	
	if ( !Other.bIsPawn ) Return;
	if( Other.bIsPawn && Pawn(Other).FindInventoryType(class'ParalSuit')!=None )
		Return;
	ForEach AllActors(class'ParalyseThing',bt)
	{
		if( bt.Burner==Pawn(Other) )
		{
			bt.Heat=2;
			bt.SetOwner(Instigator);
			Return;
		}
	}
	
	bt = Spawn(class'ParalyseThing',Instigator);
	bt.Heat = 2;
	bt.Burner = Pawn(Other);
}

defaultproperties
{
     DamageRadius=50.000000
     DamageAmount=60
     PickupMessage="You got a Smoke Grenade"
     ItemName="Smoke Grenade"
     Charge=30
     Texture=Texture'UnrealI.Skins.AToxSuit1'
     Skin=Texture'UnrealI.Skins.AToxSuit1'
     MultiSkins(1)=Texture'UnrealI.Skins.AToxSuit1'
}
