//=============================================================================
// Sphere.
//=============================================================================
class Sphree expands Pack6Pawns;

//-----------------------------------------------------------------------------
// Sphere variables.

// Attack damage.
var() byte
	PunchDamage,	// Basic damage done by each punch.
	PoundDamage,	// Basic damage done by pound.
	HitDamage;

var(Sounds)	sound Punch,ElectricSound;
var(Sounds) sound Pound;
var(Sounds) sound PunchHit;

//-----------------------------------------------------------------------------
// Sphere functions.

function PreBeginPlay()
{
	Super.PreBeginPlay();
	Mesh = LodMesh'UnrealI.GasBagM';
}
function PreSetMovement()
{
	bCanJump = true;
	bCanWalk = true;
	bCanSwim = true;
	bCanFly = true;
	bCanDuck = true;
	MinHitWall = -0.6;
	bCanDoSpecial = true;
}
function TryToDuck(vector duckDir, bool bReversed)
{
	local vector HitLocation, HitNormal, Extent;
	local actor HitActor;

	//log("duck");			
	duckDir.Z = 0;
	if ( (Skill == 0) && (FRand() < 0.5) )
		DuckDir *= -1;	

	Extent.X = CollisionRadius;
	Extent.Y = CollisionRadius;
	Extent.Z = CollisionHeight;
	HitActor = Trace(HitLocation, HitNormal, Location + 100 * duckDir, Location, false, Extent);
	if (HitActor != None)
	{
		duckDir *= -1;
		HitActor = Trace(HitLocation, HitNormal, Location + 100 * duckDir, Location, false, Extent);
	}
	if (HitActor != None)
		return;

	//log("good duck");
	Destination = Location + 150 * duckDir;
	Velocity = 400 * duckDir;
	AirSpeed *= 2.5;
	GotoState('TacticalMove', 'DoMove');
}	

function SetMovementPhysics()
{
	SetPhysics(PHYS_Flying); 
}

singular function Falling()
{
	SetPhysics(PHYS_Flying);
}

function PlayWaiting();

function PlayPatrolStop()
{
	PlayWaiting();
}

function PlayWaitingAmbush()
{
	PlayWaiting();
}

function TweenToFighter(float tweentime)
{
	TweenAnim('Fighter', tweentime);
}

function TweenToRunning(float tweentime)
{
	if ( (AnimSequence == 'Belch') && IsAnimating() )
		return;
	if ( (AnimSequence != 'Float') || !bAnimLoop )
		TweenAnim('Float', tweentime);
}

function TweenToWalking(float tweentime)
{
	if ( (AnimSequence != 'Float') || !bAnimLoop )
		TweenAnim('Float', tweentime);
}

function TweenToWaiting(float tweentime)
{
	TweenAnim('Float', tweentime);
}

function TweenToPatrolStop(float tweentime)
{
	TweenAnim('Float', tweentime);
}

function PlayRunning()
{
	if ( AnimSequence == 'Belch' )
		LoopAnim('Float', -1.0/AirSpeed, 0.5, 0.4);
	else
		LoopAnim('Float', -1.0/AirSpeed,, 0.4);
}

function PlayWalking()
{
	LoopAnim('Float', -1.0/AirSpeed,, 0.4);
}


function PlayThreatening()
{
	local float decision;

	decision = FRand();
	
	if ( decision < 0.7 )
		PlayAnim('Float', 0.4, 0.4);
	else if ( decision < 0.8 )
		PlayAnim('ThreatBelch', 0.4, 0.25);
	else
	{
		PlayThreateningSound();
		TweenAnim('Fighter', 0.3);
	}
}

function PlayTurning()
{
	LoopAnim('Float');
}
function PlayDying(name DamageType, vector HitLocation)
{
	PlaySound(Die, SLOT_Talk, 4 * TransientSoundVolume);
	if ( FRand() < 0.5 )
		PlayAnim('Deflate', 0.7, 0.1);
	else
		PlayAnim('Dead2', 0.7, 0.1);
}

function PlayTakeHit(float tweentime, vector HitLoc, int damage)
{
	if ( FRand() < 0.6 )
		TweenAnim('TakeHit', tweentime);
	else
		TweenAnim('Hit2', 1.5 * tweentime);
}

function TweenToFalling()
{
	TweenAnim('Float', 0.2);
}

function PlayInAir()
{
	LoopAnim('Float');
}

function PlayLanded(float impactVel)
{
	PlayAnim('Float');
}


function PlayVictoryDance()
{
	PlayAnim('Pound', 0.6, 0.1);
	PlaySound(PunchHit, SLOT_Interact);		
}
	
function PlayMeleeAttack()
{
	local vector adjust;
	adjust = vect(0,0,0);
	adjust.Z = Target.CollisionHeight;
	Acceleration = AccelRate * Normal(Target.Location - Location + adjust);
	if (FRand() < 0.5)
	{
		PlaySound(Punch, SLOT_Interact);
		PlayAnim('TwoPunch');
	}
	else
	{
		PlaySound(Pound, SLOT_Interact);
		PlayAnim('Pound');
	}
}

function PlayRangedAttack()
{
	local vector adjust;
	adjust = vect(0,0,0);
	adjust.Z = Target.CollisionHeight + 20;
	Acceleration = AccelRate * Normal(Target.Location - Location + adjust);
	PlayAnim('Belch');
}

function SpawnBelch()
{
	local Actor a;
	local vector HitLocation,HitNormal;
	
	if( FRand()<0.5 )
	{
		a = Trace(HitLocation,HitNormal,Target.Location,(Location+vect(0.9, -0.5, 0)),true);
		PlaySound(ElectricSound);
		DrawEffect(HitLocation,HitNormal,Location);
		if( a!=None ) a.TakeDamage(HitDamage,Self,HitLocation,HitNormal,'zapped');
	}
	else Spawn(class'ParalyseEffect',Self);
}

function PunchDamageTarget()
{
	if (MeleeDamageTarget(PunchDamage, (PunchDamage * 1300 * Normal(Target.Location - Location))))
		PlaySound(PunchHit, SLOT_Interact);
}

function PoundDamageTarget()
{
	if (MeleeDamageTarget(PoundDamage, (PoundDamage * 800 * Normal(Target.Location - Location))))
		PlaySound(PunchHit, SLOT_Interact);
}

function PlayMovingAttack()
{
	if ( AnimSequence == 'Float' )
		PlayAnim('Belch', 1.0, 0.2);
	else
		PlayAnim('Belch');
}

State TacticalMove
{
ignores SeePlayer, HearNoise;

	function EndState()
	{
		AirSpeed = Default.AirSpeed;
		Super.EndState();
	}
}

defaultproperties
{
     PunchDamage=204
     PoundDamage=204
     hitdamage=102
     Punch=Sound'UnrealShare.General.Lightning'
     Pound=Sound'UnrealShare.General.Lightning'
     PunchHit=Sound'UnrealShare.General.SpecialExpl'
     TraceEffect=Class'UnrealShare.RingExplosion4'
     TraceHitEffect=Class'UnrealShare.RingExplosion2'
     CarcassType=Class'Pack6.SmileCarcass'
     bHasRangedAttack=True
     bMovingRangedAttack=True
     RangedProjectile=Class'UnrealI.CannonBolt'
     ProjectileSpeed=2000.000000
     Acquire=Sound'UnrealShare.General.DispEX1'
     MeleeRange=40.000000
     Health=700
     HitSound1=Sound'UnrealShare.General.WoodHit1'
     HitSound2=Sound'UnrealShare.General.WoodHit1'
     CombatStyle=2.000000
     MenuName="Smiling Sphere"
     Style=STY_Masked
     Texture=Texture'Pack6.Smile'
     Mesh=LodMesh'UnrealShare.flameballM'
     DrawScale=1.700000
     CollisionRadius=44.000000
     CollisionHeight=44.000000
}
