//=============================================================================
// StarSpinner.
//=============================================================================
class StarSpinner expands RazorBlade;

var FollowFlare DaEffect;
function PreBeginPlay()
{
	DaEffect = spawn(class'FollowFlare',Self);
	DaEffect.SetOwner(Self);
	DaEffect.RemoteRole = ROLE_None;
	Super.PreBeginPlay();
}
function Destroyed()
{
	if(DaEffect!=None)
		DaEffect.Destroy();
	Super.Destroyed();
}
auto state Flying
{
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if ( bCanHitInstigator || (Other != Instigator) ) 
		{
			if ( Role == ROLE_Authority )
			{
				if ( Other.IsA('Pawn') && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight)
					&& (instigator.IsA('PlayerPawn') || (instigator.skill > 1))
					&& (!Other.IsA('ScriptedPawn') || !ScriptedPawn(Other).bIsBoss) )
					Other.TakeDamage(3.5 * damage, instigator,HitLocation,
						(MomentumTransfer * Normal(Velocity)), 'decapitated' );
				else			 
					Other.TakeDamage(damage, instigator,HitLocation,
						(MomentumTransfer * Normal(Velocity)), 'shredded' );
			}
			if ( Other.IsA('Pawn') )
				PlaySound(MiscSound, SLOT_Misc, 2.0);
			else
				PlaySound(ImpactSound, SLOT_Misc, 2.0);
			Explode(Location,HitLocation);
		}
	}
	simulated function HitWall (vector HitNormal, actor Wall)
	{
		
		bCanHitInstigator = true;
		PlaySound(ImpactSound, SLOT_Misc, 2.0);
		LoopAnim('Spin',1.0);
		if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
		{
			if ( Role == ROLE_Authority )
				Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), '');
			Destroy();
			return;
		}
		NumWallHits++;
		SetTimer(0, False);
		MakeNoise(0.3);
		if ( NumWallHits > 5 )
			Destroy();
		Velocity -= 2 * ( Velocity dot HitNormal) * HitNormal;  
		SetRoll(Velocity);
		Explode(Location + ExploWallOut * HitNormal, HitNormal);
	}
	function Explode(vector HitLocation,vector HitNormal)
	{
		local HugeSExp r;
		local rotator DaRot;
	
		DaRot=rotator(HitNormal);
		DaRot.Pitch-=16016;
		PlaySound(ImpactSound, SLOT_Misc, 0.5,,, 0.5+FRand());
		HurtRadius(Damage, 70, 'jolted', MomentumTransfer, Location );
		Spawn(class'HugeSExp',,, HitLocation+HitNormal*8,DaRot);
	}
	function SetUp()
	{
		local vector X;

		X = vector(Rotation);	
		Velocity = Speed * X;     // Impart ONLY forward vel
		if (Instigator!=None && Instigator.HeadRegion.Zone.bWaterZone)
			bHitWater = True;	
		PlaySound(SpawnSound, SLOT_None,4.2);
	}
}

defaultproperties
{
     Texture=FireTexture'UnrealShare.Effect1.FireEffect1pb'
     bMeshEnviroMap=True
}
