//=============================================================================
// SuitOfDoom.
//=============================================================================
class SuitOfDoom expands Suits;

function PickupFunction(Pawn Other)
{
	Super.PickupFunction(Other);
	Other.Texture = Texture;
	Other.bMeshEnviroMap = True;
	if( Other.Weapon!=None )
	{
		Other.Weapon.Texture = Texture;
		Other.Weapon.bMeshEnviroMap = True;
	}
	SetTimer(1,true);
}
function Timer()
{
	if( Owner!=None && Owner.IsA('Pawn') )
	{
		Pawn(Owner).Texture = Texture;
		Pawn(Owner).bMeshEnviroMap = True;
		if( Pawn(Owner).Weapon!=None )
		{
			Pawn(Owner).Weapon.Texture = Texture;
			Pawn(Owner).Weapon.bMeshEnviroMap = True;
		}
	}
}
function Destroyed()
{
	if( Owner!=None && Owner.IsA('Pawn') )
	{
		Pawn(Owner).Texture = Pawn(Owner).Default.Texture;
		Pawn(Owner).bMeshEnviroMap = Pawn(Owner).Default.bMeshEnviroMap;
		if( Pawn(Owner).Weapon!=None )
		{
			Pawn(Owner).Weapon.Texture = Pawn(Owner).Weapon.Default.Texture;
			Pawn(Owner).Weapon.bMeshEnviroMap = Pawn(Owner).Weapon.Default.bMeshEnviroMap;
		}
	}
	Super.Destroyed();
}

defaultproperties
{
     bAmbientGlow=False
     PickupMessage="You got the Suit of Doom!"
     PickupViewMesh=LodMesh'UnrealShare.KevSuit'
     Charge=500
     ArmorAbsorption=150
     bIsAnArmor=True
     AbsorptionPriority=6
     PickupSound=Sound'Ambancient.OneShot.gong2'
     Icon=Texture'UnrealShare.Icons.I_kevlar'
     DrawType=DT_Mesh
     Style=STY_Modulated
     Texture=Texture'UnrealI.Skins.JBlob1'
     Mesh=LodMesh'UnrealShare.KevSuit'
     bMeshEnviroMap=True
}
