//=============================================================================
// TelepSpawner.
//=============================================================================
class TelepSpawner expands ActorSpawner;

var bool bEnabled;
var() texture HiddenTexture;

replication
{
	// Things the server should send to the client.
	reliable if( Role<ROLE_Authority )
		MakeTelep;
}
function Activate()
{
	if( bActivatable )
	{
		Pawn(Owner).ClientMessage("TYPE: MakeTelep <name-TelepID>");
		Pawn(Owner).ClientMessage("TYPE: KillCloseS to kill close teleporters");
	}
}
exec function MakeSpawner( int Nr1, int Nr2, int Nr3, string Classs );
state Playing
{
	function Timer()
	{
		bMeshEnviroMap = Default.bMeshEnviroMap;
		Texture = Default.Texture;
		bEnabled = True;
	}
	Event Touch( Actor Other )
	{
		local TelepSpawner SP;
		local int i,ii;
		
		if( !Other.IsA('Pawn') || !bEnabled ) Return;
		ForEach AllActors(class'TelepSpawner',SP,Tag)
			if( SP!=Self && SP.IsInState('Playing') && SP.bEnabled )
				i++;
		if( i==0 ) Return;
		i = Rand(i);
		ForEach AllActors(class'TelepSpawner',SP,Tag)
		{
			if( SP!=Self && SP.IsInState('Playing') && SP.bEnabled )
			{
				if( i==ii ) Break;
				else ii++;
			}
		}
		if( SP==None ) Return;
		Other.spawn(class'ParticleBurst');
		SP.bEnabled = False;
		if( Other.SetLocation(SP.Location) )
		{
			PlaySound(sound'Teleport1', SLOT_Interface);
			bMeshEnviroMap = True;
			Texture = HiddenTexture;
			SP.spawn(class'ParticleBurst');
			bEnabled = False;
			SetTimer(3,false);
			SP.bMeshEnviroMap = True;
			SP.Texture = HiddenTexture;
			SP.bEnabled = False;
			SP.SetTimer(3,false);
			SP.PlaySound(sound'Teleport1', SLOT_Interface);
		}
		else SP.bEnabled = True;
	}
	function BeginState()
	{
		local ParticleBurst PB;
		local int i;
		
		bStasis = false;
		AmbientSound=None;
		DrawScale = 1;
		bEnabled = True;
		if( !bSpawning )
		{
			for (i=0 ; i<3 ; i++)
			{
				PB = spawn(class'ParticleBurst',,,Location+VRand()*5,RotRand(True));
				PB.DrawScale=FRand()*2+0.5;
			}
		}
	}
}
exec function MakeTelep( Name TelepID )
{
	local TelepSpawner AS;
	
	AS = Spawn(class'TelepSpawner',Owner,TelepID);
	AS.GoToState('Activated');
}

defaultproperties
{
     HiddenTexture=Texture'UnrealShare.Effects.Arc1'
     ClassToSpawn=None
     PickupMessage="You found the TeleporterSpawner."
     ItemName="TeleporterSpawner"
     Icon=Texture'UnrealShare.Icons.GreenSkull'
     Texture=Texture'UnrealShare.Icons.GreenSkull'
}
