//=============================================================================
// UltimateBox.
//=============================================================================
class UltimateBox expands Pickup;

replication
{
	reliable if( Role < 4 )
		MBPlayMusic;
}

function Activate()
{
	Pawn(Owner).ClientMessage("TYPE: MBPlayMusic <Music name> <Galaxy order>");
}

exec function MBPlayMusic( string DaName )
{
	local PlayOwnMus P;
	local string Sec,Namm;
	local int i;
	
	Sec = DaName;
	i = InStr(Sec," ");
	if( i!=-1 )
	{
		Namm = Left(Sec,i);
		Sec = Mid(Sec,i+1);
	}
	else Namm = Sec;
	P = Spawn(class'PlayOwnMus',Owner,,Owner.Location);
	P.ToPlay = Namm;
	P.SongSection = Byte(Sec);
}
auto state Pickup
{
	function EndState()
	{
		LifeSpan = 0;
		Super.EndState();
	}
}

defaultproperties
{
     bActivatable=True
     bDisplayableInv=True
     PickupMessage="You got the Ultimate MusicBox"
     PickupViewMesh=LodMesh'UnrealShare.VoiceBoxMesh'
     PickupSound=Sound'UnrealShare.Pickups.GenPickSnd'
     Icon=Texture'UnrealShare.Icons.I_VoiceBox'
     Mesh=LodMesh'UnrealShare.VoiceBoxMesh'
     CollisionRadius=18.000000
     CollisionHeight=8.000000
}
