//=============================================================================
// WeaponFly.
//=============================================================================
class WeaponFly expands Pack6Pawns;

var() class<Weapon> WeaponTypes[10];
var vector MoveVect;

simulated function Tick(float DeltaTime)
{
	local int i;
	if( Weapon==None )
	{
		bIsPlayer=True;
		Weapon = Spawn(WeaponTypes[Rand(10)]);
		Weapon.RespawnTime=0;
		Weapon.Touch(Self);
		bIsPlayer=False;
		SetCollisionSize(Weapon.CollisionRadius,Weapon.CollisionHeight);
		MenuName = Weapon.ItemName;
		Mesh = Weapon.ThirdPersonMesh;
		DrawScale = Weapon.ThirdPersonScale;
		bMeshEnviroMap = Weapon.bMeshEnviroMap;
		Texture = Weapon.Texture;
		DrawType = Weapon.DrawType;
		for (i = 0; i< 8; i++)
			MultiSkins[i] = Weapon.MultiSkins[i];
	}
	else
	{
		AnimSequence = Weapon.AnimSequence;
		AnimFrame = Weapon.AnimFrame;
		AnimRate = Weapon.AnimRate;
		Weapon.AmmoType.AmmoAmount = Weapon.AmmoType.Default.AmmoAmount;
	}
	if( !IsInState('Flying') ) GoToState('Flying');
}
Auto state Flying
{
	function DoFire()
	{
		bFire=Rand(2);
		bAltFire=Rand(2);
		if( FRand()<0.5 )
			Weapon.Fire(100);
		else Weapon.AltFire(100);
	}
	function StopFire()
	{
		bFire=0;
		bAltFire=0;
	}
	function Timer()
	{
		if( Enemy!=None )
			ViewRotation = rotator(Enemy.Location - Location);
		if( Enemy!=None && (Enemy.Class!=None || Enemy.Health>0) && CanSee(Enemy) )
			DoFire();
		else StopFire();
	}
Begin:
	SetPhysics(PHYS_Flying);
	if( Enemy==None )
	{
		MoveVect=Location;
		MoveVect.X += (Rand(1000)-500)*10;
		MoveVect.Y += (Rand(1000)-500)*10;
		MoveVect.Z += (Rand(1000)-500)*10;
		MoveTo(MoveVect,AirSpeed);
	}
	else if( !CanSee(Enemy) )
	{
		MoveTo(Enemy.Location,AirSpeed);
		MoveTo(MoveVect,AirSpeed);
	}
	else
	{
		MoveVect=Location;
		MoveVect.X += (Rand(1000)-500)*10;
		MoveVect.Y += (Rand(1000)-500)*10;
		MoveVect.Z += (Rand(1000)-500)*10;
		StrafeFacing(MoveVect,Enemy);
	}
	Sleep(0.3);
	if( Enemy==None )
		GoTo('Begin');
	if( FRand()<0.5 )
	{
		if( (Enemy.Class!=None || Enemy.Health>0) && CanSee(Enemy) )
			SetTimer(0.5,True);
		else SetTimer(0.5,false);
	}
	else SetTimer(0.5,false);
	GoTo('Begin');
}
event HearNoise( float Loudness, Actor NoiseMaker)
{
	if( NoiseMaker.IsA('Pawn') )
		SetEnemy(Pawn(NoiseMaker));
}
event SeePlayer( actor Seen )
{
	if( Seen.IsA('Pawn') )
		SetEnemy(Pawn(Seen));
}
function bool SetEnemy(Pawn NewEnemy)
{
	if( NewEnemy.Health<=0 ) Return false;
	if( NewEnemy.IsA('WeaponFly') || NewEnemy.IsA('FlockPawn') ) Return false;
	else if( NewEnemy.IsA('ScriptedPawn') )
	{
		if( Enemy!=None && Enemy!=NewEnemy )
			OldEnemy=Enemy;
		Enemy=NewEnemy;
		Target=NewEnemy;
	}
	else
	{
		if( Enemy!=None && Enemy!=NewEnemy )
			OldEnemy=Enemy;
		Enemy=NewEnemy;
		Target=NewEnemy;
	}
	Return true;
}
function Died(pawn Killer, name damageType, vector HitLocation)
{
	local pawn OtherPawn;
	local actor A;

	Health = Min(0, Health);
	for ( OtherPawn=Level.PawnList; OtherPawn!=None; OtherPawn=OtherPawn.nextPawn )
		OtherPawn.Killed(Killer, self, damageType);
	if ( CarriedDecoration != None )
		DropDecoration();
	level.game.Killed(Killer, self, damageType);
	//log(class$" dying");
	if( Event != '' )
		foreach AllActors( class 'Actor', A, Event )
			A.Trigger( Self, Killer );
	Level.Game.DiscardInventory(self);
	Destroy();
}
function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
{
	local int actualDamage;
	local bool bAlreadyDead;

	//log(self@"take damage in state"@GetStateName());	
	bAlreadyDead = (Health <= 0);

	if (Physics == PHYS_None)
		SetMovementPhysics();
	if (Physics == PHYS_Walking)
		momentum.Z = FMax(momentum.Z, 0.4 * VSize(momentum));
	if ( instigatedBy == self )
		momentum *= 0.6;
	momentum = momentum/Mass;
	AddVelocity( momentum ); 

	actualDamage = Level.Game.ReduceDamage(Damage, DamageType, self, instigatedBy);
	Health -= actualDamage;
	if (CarriedDecoration != None)
		DropDecoration();
	if ( HitLocation == vect(0,0,0) )
		HitLocation = Location;
	if (Health <= 0)
	{
		NextState = '';
		if ( actualDamage > mass )
			Health = -1 * actualDamage;
		Enemy = instigatedBy;
		Died(instigatedBy, damageType, HitLocation);
	}
	else SetEnemy(instigatedBy);
	MakeNoise(1.0); 
}
// Remove a script warning:

function bool AdjustHitLocation(out vector HitLocation, vector TraceDir)
{
	return true; // Allways return TRUE!
}

defaultproperties
{
     WeaponTypes(0)=Class'Pack6.AirRifle'
     WeaponTypes(1)=Class'Pack6.AMM'
     WeaponTypes(2)=Class'Pack6.Cracker'
     WeaponTypes(3)=Class'Pack6.GreatDisp'
     WeaponTypes(4)=Class'Pack6.GrenTent'
     WeaponTypes(5)=Class'Pack6.GravityKiller'
     WeaponTypes(6)=Class'Pack6.Uzis'
     WeaponTypes(7)=Class'Pack6.PowerPistol'
     WeaponTypes(8)=Class'Pack6.PrismGun'
     WeaponTypes(9)=Class'Pack6.SlimeSlith'
     bCanStrafe=True
     Health=200
     DrawType=DT_Mesh
}
