//=============================================================================
// _Sucker.
//=============================================================================
class _Sucker expands SeekerNali;

var float ReCheck;
var pawn ToBit;
var vector BiLoc;
var int TimeGo;

function PlayMeleeAttack()
{
	local float dist, decision;

	decision = FRand();
	dist = VSize(Target.Location - Location);
	if (dist > CollisionRadius + Target.CollisionRadius + 45)
		decision = 0.0;

	if (Physics == PHYS_Falling)
		decision = 1.0;
	if (Target == None)
		decision = 1.0;

	if (decision < 0.15)
	{
		PlaySound(strike2, SLOT_Interact);
		Enable('Bump');
		PlayAnim('Bow2');
		Velocity = 450 * Normal(Target.Location + Target.CollisionHeight * vect(0,0,0.75) - Location);
		if (dist > CollisionRadius + Target.CollisionRadius + 35)
			Velocity.Z += 0.7 * dist;
		SetPhysics(PHYS_Falling);
	}
  	else
  	{
  		PlayAnim('Follow'); 
		if (MeleeDamageTarget(HitDamage, HitDamage * 500 * Normal(Target.Location - Location)))
		{
			PlaySound(HitSound,SLOT_Interact);
			if( Target.IsA('Pawn') )
			{
				if( Pawn(Target).Health>20 )
					StuckIntoPawn(Pawn(Target));
				else Target.TakeDamage(20,Self,Location,vect(0,0,0), 'hacked' );
				Health+=20;
			}
		}
	}
}
state MeleeAttack
{
ignores SeePlayer, HearNoise;

	singular function Bump(actor Other)
	{
		Disable('Bump');
		if ( (Other == Target) && (AnimSequence == 'Bow2') )
		{
			if (MeleeDamageTarget(2, vect(0,0,0)))
			{
				PlaySound(HitSound,SLOT_Interact);
				if( Target.IsA('Pawn') )
				{
					if( Pawn(Target).Health>20 )
						StuckIntoPawn(Pawn(Target));
					else Target.TakeDamage(20,Self,Location,vect(0,0,0), 'hacked' );
					Health+=20;
				}
			}
		}
	}
}
function StuckIntoPawn( Pawn Other )
{
	BiLoc = Location-Other.Location;
	GoToState('Eating');
	SetPhysics(PHYS_None);
	ToBit = Other;
	SetCollision(false,false,false);
}
event bool EncroachingOn( actor Other )
{
	if ( (Other.Brush != None) || (Brush(Other) != None) )
		return true;
		
	return false;
}
State Eating
{
ignores SeePlayer, EnemyNotVisible, HearNoise, Bump, HitWall, HeadZoneChange, FootZoneChange, ZoneChange, Falling, WarnTarget, AddVelocity;

	function BeginState()
	{
		TimeGo = 0;
	}
	function Tick( float DeltaTime )
	{
		if( ToBit==None || ToBit.Class==None || ToBit.bDeleteMe || ToBit.Health<=0 )
		{
			Enemy=None;
			ToBit=None;
			Velocity = BiLoc*300;
			Velocity.Z = 200;
			SetPhysics(PHYS_Falling);
			SetCollision(true,true,true);
			GoToState('Wandering');
		}
		SetLocation(BiLoc+ToBit.Location);
	}
	function EndState()
	{
		if( Region.Zone.bWaterZone )
			SetPhysics(PHYS_Swimming);
		else SetPhysics(PHYS_Falling);
		SetCollision(true,true,true);
	}
	function SpawnDeEffect()
	{
		local bool bBloA,bBloP,bColA;
		
		bBloA = ToBit.bBlockActors;
		bBloP = ToBit.bBlockPlayers;
		bColA = ToBit.bCollideActors;
		ToBit.SetCollision(false,false,false);
		Spawn(class'ParticleBurst',,,ToBit.Location);
		Spawn(class'_Sucker',,,ToBit.Location);
		ToBit.SetCollision(bColA,bBloA,bBloP);
	}
Begin:
	if( Region.Zone.bWaterZone )
	{
		PlaySound(Sound'UnrealShare.Nali.injur2n',SLOT_Interact);
		TimeGo+=2;
		if( Health<=20 )
			TakeDamage(20,ToBit,Location,vect(0,0,0),'drowned');
		else Health-=20;
		PlayAnim('Drowning',2);
		if( TimeGo>20 )
		{
			Velocity = BiLoc*300;
			Velocity.Z = 400;
			GoToState('Attacking');
		}
	}
	else
	{
		PlayAnim('Follow',2);
		if( ToBit.Health>0 )
		{
			ToBit.TakeDamage(20,Self,Location,vect(0,0,0), 'hacked' );
			if( ToBit.Health<=0 )
			{
				SpawnDeEffect();
				Velocity = BiLoc*300;
				Velocity.Z = 400;
				GoToState('Wandering');
			}
		}
		else TimeGo=21;
		if( Health<Default.Health*3 )
			Health+=20;
		PlaySound(Sound'UnrealShare.Nali.syl4n',SLOT_Interact);
		TimeGo++;
		if( TimeGo>20 )
		{
			Velocity = BiLoc*300;
			Velocity.Z = 400;
			GoToState('Attacking');
		}
	}
	FinishAnim();
	GoTo 'Begin';
}

defaultproperties
{
     Aggressiveness=10.000000
     bHasRangedAttack=False
     bMovingRangedAttack=False
     RangedProjectile=None
     MeleeRange=500.000000
     SightRadius=3000.000000
     PeripheralVision=-0.400000
     Health=200
     Intelligence=BRAINS_NONE
     CombatStyle=1.000000
     MenuName="Hungry HP SuckerNali"
     Skin=Texture'UnrealShare.Skins.JNali2'
}
