//=============================================================================
// Claw.
//=============================================================================
class Claw expands RazorBlade;

auto state Flying
{
	simulated function HitWall (vector HitNormal, actor Wall)
	{
		
		bCanHitInstigator = true;
		PlaySound(ImpactSound, SLOT_Misc, 2.0);
		if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
		{
			if ( Role == ROLE_Authority )
				Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), '');
			Destroy();
			return;
		}
		NumWallHits++;
		SetTimer(0, False);
		MakeNoise(0.3);
		if ( NumWallHits > 5 )
			Destroy();
		Velocity -= 2 * ( Velocity dot HitNormal) * HitNormal;  
		SetRoll(Velocity);
	}
	simulated function BeginState()
	{

		SetTimer(0.2, false);
		SetUp();
		if ( Level.NetMode != NM_DedicatedServer )
			if ( Level.NetMode == NM_Standalone )
				SoundPitch = 200 + 50 * FRand();		
	}
	simulated function ProcessTouch (Actor Other, Vector HitLocation)
	{
		if ( !Other.IsA('Skaarj') ) 
		{
			if ( Role == ROLE_Authority )
			{
				if ( Other.IsA('Pawn') && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight)
					&& (instigator.IsA('PlayerPawn') || (instigator.skill > 1))
					&& (!Other.IsA('ScriptedPawn') || !ScriptedPawn(Other).bIsBoss) )
					Other.TakeDamage(3.5 * damage, instigator,HitLocation,
						(MomentumTransfer * Normal(Velocity)), 'decapitated' );
				else			 
					Other.TakeDamage(damage, instigator,HitLocation,
						(MomentumTransfer * Normal(Velocity)), 'shredded' );
			}
			if ( Other.IsA('Pawn') )
				PlaySound(MiscSound, SLOT_Misc, 2.0);
			else
				PlaySound(ImpactSound, SLOT_Misc, 2.0);
			destroy();
		}
	}
}

defaultproperties
{
     Damage=40.000000
     SpawnSound=None
     Texture=Texture'XFX.inoxBlu1'
     Mesh=LodMesh'UnrealShare.SkaarjHand'
     bMeshEnviroMap=True
}
