//=============================================================================
// myRevenge.
//=============================================================================
class myRevenge expands HumanPawn;

var Actor Node,OldNode;
var vector MoveVect,OldVect;
var float HuntingTime;

function PreBeginPlay()
{
	local float TR;
	Super.PreBeginPlay();
	
	TR = FRand();
	if( TR<0.2 )
		Mesh = Mesh'Male1';
	else if( TR<0.4 )
		Mesh = Mesh'Male3';
	else if( TR<0.6 )
		Mesh = Mesh'FeMale1';
	else if( TR<0.8 )
		Mesh = Mesh'FeMale2';
}
function WhatToDoNext(name LikelyState, name LikelyLabel)
{
	bQuiet = false;
	GotoState('IdleMoving');
}
function PreSetMovement()
{
	bCanJump = true;
	bCanWalk = true;
	bCanSwim = true;
	bCanFly = false;
	MinHitWall = -0.6;
	bCanOpenDoors = true;
	bCanDoSpecial = true;
}
State IdleMoving
{
Ignores Tick;
	Event BeginState()
	{
		PreSetMovement();
		SetTimer(60,false);
		if( Enemy==None || Enemy.Class==None || Enemy.Health<=0 || Enemy.bDeleteMe )
			Died(None,'NoEnemy',Location);
	}
	function Timer()
	{
		Died(None,'NoEnemy',Location);
	}
Begin:
	if( Enemy==None || Enemy.Class==None || Enemy.Health<=0 || Enemy.bDeleteMe )
		Died(None,'NoEnemy',Location);
	if( !LineOfSightTo(Enemy) )
		GoTo 'GetPath';
	MoveVect = VRand()*200;
	Target = Enemy;
	PlayRangedAttack();
	StrafeFacing(MoveVect,Enemy);
	Acceleration = vect(0,0,0);
	FinishAnim();
	PlayWaiting();
	Sleep(0.2);
	GoTo 'Begin';
GetPath:
	OldNode = Node;
	Node = FindPathToward(Enemy);
	if( Node==None )
	{
		Acceleration = vect(0,0,0);
		PlayWaiting();
		Sleep(2);
		PlayRunning();
		MoveToward(Enemy);
		MoveToward(Enemy);
		if( LineOfSightTo(Enemy) )
			GoTo 'Begin';
		Acceleration = vect(0,0,0);
		PlayWaiting();
		Sleep(2);
		if( !LineOfSightTo(Enemy) )
			Died(None,'NoEnemy',Location);
		else GoTo 'Begin';
	}
	if( OldNode!=None && OldNode.IsA('LiftExit') && Node.IsA('LiftCenter') &&
	 LiftExit(OldNode).LiftTag==LiftCenter(Node).LiftTag)
	{
ReCheck:
		if( Location.Z>(Node.Location.Z-LiftCenter(Node).MaxZDiffAdd-40) &&
		 Location.Z<(Node.Location.Z+LiftCenter(Node).MaxZDiffAdd+40) )
			GoTo 'Skip';
		else
		{
			Acceleration = vect(0,0,0);
			PlayWaiting();
			Sleep(1);
			GoTo 'ReCheck';
		}
	}
Skip:
	PlayRunning();
	MoveToward(Node,GroundSpeed);
	GoTo 'Begin';
}
function bool SetEnemy( Pawn NewEnemy )
{
	Return false;
}
event HearNoise( float Loudness, Actor NoiseMaker);
event SeePlayer( actor Seen );
function Tick(float DeltaTime)
{
	GoToState('IdleMoving');
}
function Killed(pawn Killer, pawn Other, name damageType)
{
	if( Enemy==None || Other==Enemy )
		SetTimer(0.5,false);
}
function Died(pawn Killer, name damageType, vector HitLocation)
{
	local pawn OtherPawn;
	local actor A;

	if ( bDeleteMe )
		return; //already destroyed
	Health = Min(0, Health);
	for ( OtherPawn=Level.PawnList; OtherPawn!=None; OtherPawn=OtherPawn.nextPawn )
		OtherPawn.Killed(Killer, self, damageType);
	if ( CarriedDecoration != None )
		DropDecoration();
	if( damageType!='NoEnemy' )
		level.game.Killed(Killer, self, damageType);
	//log(class$" dying");
	if( Event != '' )
		foreach AllActors( class 'Actor', A, Event )
			A.Trigger( Self, Killer );
	Level.Game.DiscardInventory(self);
	Spawn(class'ParticleBurst');
	Destroy();
}

defaultproperties
{
     RangedProjectile=Class'Pack6.GhostSlime'
     Health=800
     NameArticle=" the "
     Style=STY_Translucent
     Texture=None
     Skin=None
     bBlockActors=False
     bBlockPlayers=False
     LightType=LT_Steady
     LightBrightness=68
     LightRadius=9
     VolumeBrightness=51
     VolumeRadius=8
     VolumeFog=51
}
