/*
 * Supposed to be done by a community
 */

class Particle extends Effects;
 
var ParticleSystem particleSys;

var vector friction;

var vector fixedForce;
var vector bounceDir;
var Actor lastHitActor; //Used for bounces.
var vector ParticleHitNormal;
var Actor ParticleHitWall;
var int bounceCounter;
var bool bHitEffect;

auto state Init {
	event BeginState() {
		bCollideWorld = true;
		particleSys = ParticleSystem(owner);
		if (particleSys == None)
			destroy();
		
		if (particleSys.localPlayer == None)
			particleSys.FindLocalPlayer();
		if (particleSys.localPlayer == None)
			destroy();
			
		GotoState('Resetting');
	}
}

event FellOutOfWorld() {
	GotoState('Resetting');
}

event Timer() {
	GotoState('Resetting');
}

state Resetting
{
	event BeginState() {
		bHidden = true;
		Setup();
	}

	function Setup() {
		local vector relativeLoc;
		local int i;

		for (i = 0; i < particleSys.MaxSetLocationAttempts; ++i) {
			relativeLoc = particleSys.Location + particleSys.RandRangeVec(particleSys.minSpawnLoc, particleSys.maxSpawnLoc);

			if (SetLocation(relativeLoc))
				if (particleSys.allowNewLoc(self))
					if (!particleSys.bEmitInZone || (particleSys.bEmitInZone && (Region.Zone == particleSys.Region.Zone)))
						if ((particleSys.maxDistFromPlayer == 0) || (VSize(Location - particleSys.localPlayer.Location) <= particleSys.maxDistFromPlayer))
							if (!particleSys.bSpawnInViewport || (particleSys.bSpawnInViewport && (PlayerCanSeeMe())))
								break;
		}
		bHidden = i == particleSys.MaxSetLocationAttempts;
		
		if (bHidden) {
			GotoState('Resetting'); 
		} else {
			//Actual reset.
			fixedForce = particleSys.RandRangeVec(particleSys.minFixedForce, particleSys.maxFixedForce);
			SetCollision(particleSys.bBlockByActors, false, false);
			bounceCounter = 0;
			Velocity *= 0;
			Mass = particleSys.particlesMass;
			Texture = particleSys.particlesTexture;
			setTimer(particleSys.forcedResetInterval, false);
			
			GotoState('StartPhysics');
		}
	}
}

function ApplyForce(vector force) {
	Acceleration += (force / Mass);
}

//Actually not rly all, the bounce forces are applied later.
function ApplyAllForces() {
	local ForceInfo forceInfo;
	local float distFromForce;
	local vector actualForce;
	
	ApplyForce(friction);
	ApplyForce(Region.Zone.ZoneGravity * Mass);
	ApplyForce(Region.Zone.ZoneVelocity);
	ApplyForce(fixedForce);
	foreach AllActors(class'ForceInfo', forceInfo) {
		actualForce = forceInfo.force;
		if (VSize(forceInfo.actionDist) != 0) {
			distFromForce = VSize(Location - forceInfo.Location);
			if (distFromForce < 0)
				distFromForce *= -1;
			if (distFromForce > (FMax(FMax(forceInfo.actionDist.X, forceInfo.actionDist.Y), forceInfo.actionDist.Z)))
				continue;
				
			actualForce.X = map(distFromForce, 0, forceInfo.actionDist.X, forceInfo.force.X, 0);
			actualForce.Y = map(distFromForce, 0, forceInfo.actionDist.Y, forceInfo.force.Y, 0);
			actualForce.Z = map(distFromForce, 0, forceInfo.actionDist.Z, forceInfo.force.Z, 0);
		}
		
		ApplyForce(actualForce - forceInfo.Location);
	}
}

static function limitVelocity(Actor runner, vector limit) {
	//Limit positive velocity.
	if (runner.Velocity.X > limit.X)
		runner.Velocity.X = limit.X;
	if (runner.Velocity.Y > limit.Y)
		runner.Velocity.Y = limit.Y;
	if (runner.Velocity.Z > limit.Z)
		runner.Velocity.Z = limit.Z;
	//Limit negative velocity.
	if (runner.Velocity.X < (limit.X * -1))
		runner.Velocity.X = limit.X * -1;
	if (runner.Velocity.Y < (limit.Y * -1))
		runner.Velocity.Y = limit.Y * -1;
	if (runner.Velocity.Z < (limit.Z * -1))
		runner.Velocity.Z = limit.Z * -1;
}

static function vector calcHitNormalApprox(Actor act) {
	local float max;
	local vector positiveVel, hitNormal;
	
	if (act.Velocity.X < 0)
		positiveVel.X = (act.Velocity.X * -1);
	if (act.Velocity.Y < 0)
		positiveVel.Y = (act.Velocity.Y * -1);
	if (act.Velocity.Z < 0)
		positiveVel.Z = (act.Velocity.Z * -1);
		
	max = FMax(FMax(positiveVel.X, positiveVel.Y), positiveVel.Z);
	if (positiveVel.X == max)
		hitNormal.X = 1;
	else if (positiveVel.Y == max)
		hitNormal.Y = 1;
	else if (positiveVel.Z == max)
		hitNormal.Z = 1;
		
	return hitNormal;
}

function float map(float x, float inMin, float inMax, float outMin, float outMax) {
	return (x - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
}

function Hit(actor HitStuff, vector HitNormal) {
	local HitEffect hitFX;
	
	if ((HitStuff != None) && (VSize(HitNormal) == 0))
		HitNormal = calcHitNormalApprox(self);
	
	if ((particleSys.maxBounces <= 0) || ((particleSys.maxBounces > 0) && (bounceCounter >= particleSys.maxBounces))) {
		ParticleHitNormal = HitNormal;
		ParticleHitWall = HitStuff;
		if (bHitEffect) {
			hitFX = spawn(particleSys.hitEffectClass,,,Location);
			if (hitFX != None)
				hitFX.init(ParticleHitNormal, ParticleHitWall);
		}
		
		if (!particleSys.bResetOnLastHit)
			GotoState('Idle');
		else
			GotoState('Resetting');
	} else {
		//FIXME - Only check for the last hti actor, shouldn't it be applied for any actor who's currently touching(maybe implementing it inside ApplyAllForces)?
		bounceDir = HitNormal;
		lastHitActor = HitStuff;
		bounceCounter++;
	}
}

event HitWall(vector HitNormal, actor HitWall) {
	Hit(HitWall, HitNormal);
}

static function vector normalNoRound(vector vec) {
	local float normCohefficent;
	local vector normVec;
	
	normCohefficent = (vec.x * vec.x) + (vec.y * vec.y) + (vec.z * vec.z);
	normVec = vec / normCohefficent;
}

state Idle {
Ignores HitWall;
}

state StartPhysics {
	event BeginState() {
		SetPhysics(PHYS_Projectile);
	}

	event EndState() {
		//The particle will move back to the initial position, it needs to be non-collidable.
		SetCollision(false);
		SetPhysics(PHYS_None);
	}

	event Touch(Actor Other) {
		if (Other.bCollideActors && Other.bBlockActors)
			Hit(Other, vect(0,0,0));
	}

	event ZoneChange(ZoneInfo NewZone) {
		particleSys.particleZoneChange(self, NewZone);
	}

	event Tick(float DeltaTime) {
		friction = (Velocity * -1);
		friction = normalNoRound(friction);
		friction *= particleSys.frictionCohefficent;
		
		ApplyAllForces();
		
		//Calculate bounce velocity.
		if (VSize(bounceDir) != 0) {
			if (bounceDir.X != 0)
				Velocity.X *= -1;
			else if (bounceDir.Y != 0)
				Velocity.Y *= -1;
			else if (bounceDir.Z != 0)
				Velocity.Z *= -1;
				
			bounceDir *= 0;
		}
		
		if ((lastHitActor != None) && !lastHitActor.IsA('LevelInfo'))
			ApplyForce(lastHitActor.Velocity);
		
		lastHitActor = None;
		
		Velocity += Acceleration * DeltaTime;
		
		Log(Level.TimeSeconds@"|"@Velocity);
		
		//Limiting the Velocity to the Zone Terminal Velocity.
		limitVelocity(self, vect(1,1,1) * Region.Zone.ZoneTerminalVelocity);
		
		// Reset acceleration
		Acceleration *= 0;
	}
}

event Destroyed() {
	if (particleSys != None) {
		particleSys.particlesCounter--;
		particleSys.enable('timer');
	}
}

defaultproperties
{
   RemoteRole=ROLE_None
   DrawType=DT_Sprite
   Style=STY_Translucent
   DrawScale=0.2
   Mass=1
   bBounce=True
   CollisionRadius=1
   CollisionHeight=1
}