/*
 * Supposed to be done by a community
 */

class Particle extends Projectile;
 
var ParticleSystem particleSys;

var vector friction;

var vector fixedForce;
var vector bounceDir;
var Actor lastHitActor; //Used for bounces.
var vector ParticleHitNormal;
var Actor ParticleHitWall;
var int bounceCounter;
var bool bHitEffect;

auto state Init {
	event BeginState() {
		bCollideWorld = true;
		particleSys = ParticleSystem(owner);
		if (particleSys == None)
			destroy();
		
		if (particleSys.localPlayer == None)
			particleSys.FindLocalPlayer();
		if (particleSys.localPlayer == None)
			destroy();
			
		GotoState('Resetting');
	}
}

event FellOutOfWorld() {
	GotoState('Resetting');
}

event Timer() {
	GotoState('Resetting');
}

state Resetting
{
	event BeginState() {
		bHidden = true;
		Setup();
	}

	function Setup() {
		local vector relativeLoc;
		local int i;

		for (i = 0; i < particleSys.MaxSetLocationAttempts; ++i) {
			relativeLoc = particleSys.Location + particleSys.RandRangeVec(particleSys.minSpawnLoc, particleSys.maxSpawnLoc);

			if (SetLocation(relativeLoc))
				if (particleSys.allowNewLoc(self))
					if (!particleSys.bEmitInZone || (particleSys.bEmitInZone && (Region.Zone == particleSys.Region.Zone)))
						if ((particleSys.maxDistFromPlayer == 0) || (VSize(Location - particleSys.localPlayer.Location) <= particleSys.maxDistFromPlayer))
							if (!particleSys.bSpawnInViewport || (particleSys.bSpawnInViewport && (PlayerCanSeeMe())))
								break;
		}
		bHidden = i == particleSys.MaxSetLocationAttempts;
		
		if (bHidden) {
			GotoState('Resetting'); 
		} else {
			//Actual reset.
			fixedForce = particleSys.RandRangeVec(particleSys.minFixedForce, particleSys.maxFixedForce);
			SetCollision(particleSys.bBlockByActors, false, false);
			bounceCounter = 0;
			Velocity *= 0;
			Mass = particleSys.particlesMass;
			Texture = particleSys.particlesTexture;
			setTimer(particleSys.forcedResetInterval, false);
			
			GotoState('StartPhysics');
		}
	}
}

function ApplyForce(vector force) {
	Acceleration += (force / Mass);
}

function ApplyAllForces() {
	local ForceInfo forceInfo;
	local float distFromForce;
	local vector actualForce;
	
	ApplyForce(friction);
	ApplyForce(Region.Zone.ZoneGravity * Mass);
	ApplyForce(Region.Zone.ZoneVelocity);
	ApplyForce(fixedForce);
	foreach AllActors(class'ForceInfo', forceInfo) {
		actualForce = forceInfo.force;
		if (VSize(forceInfo.actionDist) != 0) {
			distFromForce = VSize(Location - forceInfo.Location);
			if (distFromForce < 0)
				distFromForce *= -1;
			if (distFromForce > (FMax(FMax(forceInfo.actionDist.X, forceInfo.actionDist.Y), forceInfo.actionDist.Z)))
				continue;
				
			actualForce.X = map(distFromForce, 0, forceInfo.actionDist.X, forceInfo.force.X, 0);
			actualForce.Y = map(distFromForce, 0, forceInfo.actionDist.Y, forceInfo.force.Y, 0);
			actualForce.Z = map(distFromForce, 0, forceInfo.actionDist.Z, forceInfo.force.Z, 0);
		}
		
		ApplyForce(actualForce - forceInfo.Location);
	}
	if ((lastHitActor != None) && !lastHitActor.IsA('LevelInfo'))
		ApplyForce(lastHitActor.Velocity);
		
	lastHitActor = None;
}

static function limitVelocity(Actor runner, vector limit) {
	//Limit positive velocity.
	if (runner.Velocity.X > limit.X)
		runner.Velocity.X = limit.X;
	if (runner.Velocity.Y > limit.Y)
		runner.Velocity.Y = limit.Y;
	if (runner.Velocity.Z > limit.Z)
		runner.Velocity.Z = limit.Z;
	//Limit negative velocity.
	if (runner.Velocity.X < (limit.X * -1))
		runner.Velocity.X = limit.X * -1;
	if (runner.Velocity.Y < (limit.Y * -1))
		runner.Velocity.Y = limit.Y * -1;
	if (runner.Velocity.Z < (limit.Z * -1))
		runner.Velocity.Z = limit.Z * -1;
}

//Calculate an approximated normal basing on the Velocity min/max axis value.
static function vector calcHitNormalApprox(Actor act) {
	local float max;
	local vector positiveVel, hitNormal;
	
	//Normal is always positive, convert negative axis values to positive ones.
	if (act.Velocity.X < 0)
		positiveVel.X = (act.Velocity.X * -1);
	if (act.Velocity.Y < 0)
		positiveVel.Y = (act.Velocity.Y * -1);
	if (act.Velocity.Z < 0)
		positiveVel.Z = (act.Velocity.Z * -1);
		
	max = FMax(FMax(positiveVel.X, positiveVel.Y), positiveVel.Z);
	if (positiveVel.X == max)
		hitNormal.X = 1;
	else if (positiveVel.Y == max)
		hitNormal.Y = 1;
	else if (positiveVel.Z == max)
		hitNormal.Z = 1;
		
	return hitNormal;
}

//Rapport one number from a range to another range.
function float map(float x, float inMin, float inMax, float outMin, float outMax) {
	return (x - inMin) * (outMax - outMin) / (inMax - inMin) + outMin;
}

function Hit(actor HitStuff, vector HitNormal) {
	local HitEffect hitFX;
	
	if ((HitStuff != None) && (VSize(HitNormal) == 0))
		//Didn't bounce onto Level Geometry.
		HitNormal = calcHitNormalApprox(self);
	
	if ((particleSys.maxBounces <= 0) || ((particleSys.maxBounces > 0) && (bounceCounter >= particleSys.maxBounces))) {
		//Spawn hit effect.
		ParticleHitNormal = HitNormal;
		ParticleHitWall = HitStuff;
		if (bHitEffect) {
			hitFX = spawn(particleSys.hitEffectClass,,,Location);
			if (hitFX != None)
				hitFX.init(ParticleHitNormal, ParticleHitWall);
		}
		
		if (!particleSys.bResetOnLastHit)
			GotoState('Idle');
		else
			GotoState('Resetting');
	} else {
		//FIXME - Only check for the last hti actor, shouldn't it be applied for any actor who's currently touching(maybe implementing it inside ApplyAllForces)?
		bounceDir = HitNormal;
		lastHitActor = HitStuff;
		bounceCounter++;
	}
}

event HitWall(vector HitNormal, actor HitWall) {
	Hit(HitWall, HitNormal);
}

//Normalize the vector without rounding the result.
static function vector normalNoRound(vector vec) {
	local float normCohefficent;
	local vector normVec;
	
	normCohefficent = (vec.x * vec.x) + (vec.y * vec.y) + (vec.z * vec.z);
	normVec = vec / normCohefficent;
}

state Idle {
Ignores HitWall;
}

static function float getMagnitude(vector vec) {
	return sqrt(vec.X^2 + vec.Y^2 + vec.Z^2);
}

state StartPhysics {
	event BeginState() {
		SetPhysics(PHYS_Projectile);
	}

	event EndState() {
		//The particle will move back to the initial position, it needs to be non-collidable.
		SetCollision(false);
		SetPhysics(PHYS_None);
	}

	function ProcessTouch(Actor Other, Vector HitLocation) {
		Hit(Other, vect(0,0,0));
	}

	event ZoneChange(ZoneInfo NewZone) {
		particleSys.particleZoneChange(self, NewZone);
	}

	event Tick(float DeltaTime) {
		//Calculate friction.
		friction = (Velocity * -1);
		friction = normalNoRound(friction);
		if (!Region.Zone.bWaterZone)
			friction *= Region.Zone.ZoneGroundFriction;
		else
			friction *= Region.Zone.ZoneFluidFriction;
		friction *= DeltaTime;
		
		//Change direction basing on bounce normal.
		if (VSize(bounceDir) != 0) {
			Velocity = MirrorVectorByNormal(Velocity, bounceDir);
				
			bounceDir *= 0;
		}
		
		ApplyAllForces();
		
		Velocity += Acceleration * DeltaTime;
		limitVelocity(self, vect(1,1,1) * Region.Zone.ZoneTerminalVelocity);
		
		Acceleration *= 0;
	}
}

event Destroyed() {
	if (particleSys != None) {
		particleSys.particlesCounter--;
		particleSys.enable('timer');
	}
}

defaultproperties
{
   RemoteRole=ROLE_None
   DrawType=DT_Sprite
   Style=STY_Translucent
   DrawScale=0.2
   Mass=1
   bBounce=True
   CollisionRadius=1
   CollisionHeight=1
   bNetTemporary=False
   bReplicateInstigator=False
   LifeSpan=0
   bDirectional=False
}