/*
 * Supposed to be done by a community
 */

class Particle extends Effects;

const MinDesiredFPS = 55;
 
var ParticleSystem particleSys;

var vector friction;
const frMagnitude = 0.01; //friction cohefficent (0.01) * friction normal (1).

var vector fixedForce;
var bool bHitWall;
var vector ParticleHitNormal;
var Actor ParticleHitWall;
var bool bHitEffect;

auto state Init {
	event BeginState() {
		bCollideWorld = true;
		particleSys = ParticleSystem(owner);
		if (particleSys == None)
			destroy();
		
		if (particleSys.localPlayer == None)
			particleSys.FindLocalPlayer();
		if (particleSys.localPlayer == None)
			destroy();
			
		GotoState('Resetting');
	}
}

event FellOutOfWorld() {
	GotoState('SleepReset');
}

state Resetting
{
	event BeginState() {
		bHidden = true;
		Setup();
	}

	function Setup() {
		local vector relativeLoc;
		local int i;

		for (i = 0; i < particleSys.MaxSetLocationAttempts; ++i) {
		relativeLoc = particleSys.Location + particleSys.RandRangeVec(particleSys.minSpawnLoc, particleSys.maxSpawnLoc);

		if (SetLocation(relativeLoc))
			if (particleSys.allowNewLoc(self))
				if (!particleSys.bEmitInZone || (particleSys.bEmitInZone && (Region.Zone == particleSys.Region.Zone)))
					if ((particleSys.maxDistFromPlayer == 0) || (VSize(Location - particleSys.localPlayer.Location) <= particleSys.maxDistFromPlayer))
						if (!particleSys.bSpawnInViewport || (particleSys.bSpawnInViewport && (PlayerCanSeeMe())))
							break;
		}
		bHidden = i == particleSys.MaxSetLocationAttempts;
		
		if (bHidden) {
			GotoState('Resetting'); 
		} else {
			fixedForce = particleSys.RandRangeVec(particleSys.minFixedForce, particleSys.maxFixedForce);

			SetCollision(particleSys.bBlockByActors, false, false);

			GotoState('StartPhysics');
		}
		  
		Mass = particleSys.particlesMass;
		Texture = particleSys.particlesTexture;
	}
}

function ApplyForce(vector force) {
	Acceleration += (force / Mass);
}

function ApplyAllForces() {
	local ForceInfo forceInfo;

	ApplyForce(friction);
	ApplyForce(Region.Zone.ZoneGravity * Mass);
	ApplyForce(Region.Zone.ZoneVelocity);
	ApplyForce(fixedForce);
	foreach AllActors(class'ForceInfo', forceInfo)
		ApplyForce(forceInfo.force - forceInfo.Location);
}

event HitWall(vector HitNormal, actor HitWall) {
	local HitEffect hitFX;
	
	bHitWall = true;
	
	ParticleHitNormal = HitNormal;
	ParticleHitWall = HitWall;
	if (bHitEffect) {
		hitFX = spawn(particleSys.hitEffectClass,,,Location);
		if (hitFX != None)
			hitFX.init(ParticleHitNormal, ParticleHitWall);
	}
	
	GotoState('SleepReset');
}

state StartPhysics {
	event BeginState() {
		SetPhysics(PHYS_Projectile);
	}

	event EndState() {
		Velocity = vect(0, 0, 0);

		//The particle will move back to the initial position, it needs to be non-collidable.
		SetCollision(false);
		SetPhysics(PHYS_None);
	}

	event Touch(Actor A) {
		if (A.bCollideActors && A.bBlockActors)
			GotoState('Resetting');
	}

	event ZoneChange(ZoneInfo NewZone) {
		particleSys.particleZoneChange(self, NewZone);
	}

	event Tick(float DeltaTime) {
		Velocity += Acceleration;
		//Limiting the Velocity to the Zone Terminal Velocity.
		if (Velocity.X > Region.Zone.ZoneTerminalVelocity)
		Velocity.X = Region.Zone.ZoneTerminalVelocity;
		if (Velocity.Y > Region.Zone.ZoneTerminalVelocity)
		Velocity.Y = Region.Zone.ZoneTerminalVelocity;
		if (Velocity.Z > Region.Zone.ZoneTerminalVelocity)
		Velocity.Z = Region.Zone.ZoneTerminalVelocity;


		// Reset acceleration
		Acceleration = vect(0,0,0);

		friction = (Velocity * -1);
		friction = Normal(friction);
		friction = (friction * frMagnitude);

		if (bHitWall)
		 bHitWall = false;
		else
		 ApplyAllForces();
		if (DeltaTime > Level.TimeDilation / MinDesiredFPS && FRand() < 0.1) {
		 bHidden = true;
		 
		 //Set the collision to false to be able to move back in the initial position.
		 SetCollision(false);
		}
	}
}

state SleepReset {
Ignores HitWall;

Begin:
	Sleep(particleSys.resetInterval);
	
	//Reset the Velocity
	Velocity = vect(0,0,0);
	
	sleep(0);
	GotoState('Resetting');
}

event Destroyed() {
	if (particleSys != None) {
		particleSys.particlesCounter--;
		particleSys.enable('timer');
	}
}

defaultproperties
{
   RemoteRole=ROLE_None
   DrawType=DT_Sprite
   Style=STY_Translucent
   DrawScale=0.2
   Mass=1
   bBounce=True
   CollisionRadius=1
   CollisionHeight=1
}