/*
 * Supposed to be done by a community
 */

class ParticleSystem extends Effects;

var() bool bDynamicSettings; //Set it to true if you would like to change some settings at run-time. (To see what settings would keep replicating, read it in the replication block under 'DYNAMIC')

var() vector minSpawnLoc; //minimum spawn location(usually negative) in range relative to this ParticleSystem actor.
var() vector maxSpawnLoc; //maximum spawn location(usually positive) in range relative to this ParticleSystem actor.
var() int	MaxSetLocationAttempts;
var() int	MaxParticles;
var() int	particlesPerBatch;
var() bool	bBlockByActors;
var() bool	bEmitInZone;
var() float	maxDistFromPlayer; // Max spawn distance from player. 0 = No Limit.
var() bool	bSpawnInViewport;
var() float	spawnInterval;
var() float	resetInterval;

var(Particles) class<Particle>	particlesClass;
var(Particles) class<HitEffect>	hitEffectClass;
var(Particles) float			particlesMass;
var(Particles) float			particlesBuoyancy; //FIXME - Unimplemented.
var(Particles) int				maxBounces;
var(Particles) vector			minFixedForce;
var(Particles) vector			maxFixedForce;
var(Particles) Texture			particlesTexture;
 
var int			ParticlesCounter;
var PlayerPawn	localPlayer;
 
replication
{
	reliable if (bNetInitial && (Role == ROLE_Authority))
		MaxSetLocationAttempts, MaxParticles;
	
	reliable if (Role == ROLE_Authority)
		bDynamicSettings, bBlockByActors;
	
	//DYNAMIC
	reliable if ((bDynamicSettings || bNetInitial) && (Role == ROLE_Authority))
		minSpawnLoc, maxSpawnLoc, particlesPerBatch, bEmitInZone, maxDistFromPlayer, bSpawnInViewport, spawnInterval, resetInterval, particlesClass, hitEffectClass, particlesMass, particlesBuoyancy, maxBounces, minFixedForce, maxFixedForce, particlesTexture;
}

simulated event PostBeginPlay() {
	// Asserts
	if (MaxParticles <= 0)
		MaxParticles = 1;
	if (maxDistFromPlayer < 0)
		maxDistFromPlayer = 0;
	if (particlesMass <= 0)
		particlesMass = 1;
	if (spawnInterval <= 0)
		spawnInterval = 1;
   
	setTimer(spawnInterval, true);
	
	if (Level.NetMode == NM_DedicatedServer)
		disable('Timer');
}

simulated function FindLocalPlayer() {
	foreach AllActors(class'PlayerPawn', localPlayer)
		if (Viewport(localPlayer.player) != None)
			break;
}

simulated function timer() {
	local int i;
	local Particle particle;

	super.timer();

	for (i = 0; i < particlesPerBatch; i++) {
		particle = spawn(particlesClass, self);
		if (particle != none)
			particlesCounter++;
			
		if (particlesCounter >= maxParticles) {
			disable('timer');
			break;
		}
	}
}

simulated function particleZoneChange(Particle particle, ZoneInfo newZone) {}

simulated event destroyed() {
	local Particle particle;
	
	foreach AllActors(class'Particle', particle)
		if (particle.owner == self)
			particle.destroy();
}

function bool allowNewLoc(Particle particle) {
	return true;
}

function vector RandRangeVec(vector min, vector max) {
	local vector result;

	result.X = RandRange(min.X, max.X);
	result.Y = RandRange(min.Y, max.Y);
	result.Z = RandRange(min.Z, max.Z);
	
	return result;
}

defaultproperties
{
   particlesPerBatch=150
   MaxParticles=500
   particlesMass=1
   bBlockByActors=True
   spawnInterval=0.3
   resetInterval=0.001
   MaxSetLocationAttempts=16
   bAlwaysRelevant=True
   RemoteRole=ROLE_SimulatedProxy
   DrawType=DT_Sprite
   Style=STY_Masked
   bNetTemporary=False
   bHidden=True
}

