//=============================================================================
// GunlocScout.
//=============================================================================
class GunlocScout expands Scout;

var() float Radiuses[5];
var() float Heights[5];

event PreBeginPlay()
{
	bHidden = true;
	bCanJump = true;
	bCanWalk = true;
	bCanSwim = true;
	bCanFly = false;
	bCanOpenDoors = true;
	bCanDoSpecial = true;
	JumpZ = 350;
	Mass = 70;
	LifeSpan = 0.05;
}

event PostBeginPlay()
{
}

event Destroyed()
{
}

function bool CheckReachability( Actor Start, Actor End)
{
	local int ShrinkIdx;

	Shrink(ShrinkIdx);
	bCollideWorld = true;
	bCollideWhenPlacing = true;
	while ( !SetLocation(Start.Location) )
		if ( !Shrink(ShrinkIdx) )
			return false;
//	bStopAtLedges = False;
//	bAvoidLedges = False;
	Move( vect(0,0,-1) * CollisionHeight);

	if ( Region.Zone.bWaterZone )	SetPhysics( PHYS_Swimming);
	else							SetPhysics( PHYS_Walking);

	while ( !PointReachable(End.Location) )
		if ( !Shrink(ShrinkIdx) )
			return false;
	return true;
}

event FellOutOfWorld()
{
}

function bool Shrink( out int ShrinkInto)
{
	if ( ShrinkInto >= ArrayCount(Radiuses) )
		return false;
	SetCollisionSize( Radiuses[ShrinkInto], Heights[ShrinkInto]);
	ShrinkInto++;
	return true;
}

defaultproperties
{
	Radiuses(0)=50.000000
	Radiuses(1)=42.000000
	Radiuses(2)=30.000000
	Radiuses(3)=18.000000
	Radiuses(4)=8.000000
	Heights(0)=70.000000
	Heights(1)=65.000000
	Heights(2)=52.000000
	Heights(3)=48.000000
	Heights(4)=39.000000
	WaterSpeed=280.000000
	bGameRelevant=True
	CollisionRadius=17.000000
	CollisionHeight=39.000000
}
