//=============================================================================
// MapGarbage.
//=============================================================================
class PathsLinker expands BrushBuilder;

var() bool bLogNewNav, bLogTweakPoint, bGenerateDecoUC, bLogActors, bComputeDistance,
bCheckDuplicates, bFixDuplicates, bLogBrushBuildLag, bTestReach,
bCountReachSpecs;
var() int NumBrush;
//var() XC_Linker XL;
var() bool bDisconnectN1toN2;
var() bool bConnectPathsFor;
var() NavigationPoint N1, N2;
var() int RFlags;
var() float CRadius;
var() float CHeight;
var() bool bTwoWay;
var() bool bGet1stN1, bGet2ndN2;
var() bool bModifyReachSpec;
var() int NSpec;
var() bool bDeleteReachSpec;
var string AText;

var LevelInfo MyMap;

/*
const R_WALK       = 0x00000001; //walking required
const R_FLY        = 0x00000002; //flying required 
const R_SWIM       = 0x00000004; //swimming required
const R_JUMP       = 0x00000008; //jumping required
const R_DOOR       = 0x00000010;
const R_SPECIAL    = 0x00000020;
const R_PLAYERONLY = 0x00000040;

struct ReachSpec
{
	var() int Distance; 
	var() Actor Start;
	var() Actor End;
	var() int CollisionRadius; 
    var() int CollisionHeight; 
	var() int ReachFlags;
	var() byte bPruned;
};
var() ReachSpec DummyReachSpec;
*/

final function FindLevel()
{
	SetPropertyText("MyMap","MyLevel.LevelInfo0");
	if( MyMap==None )
		SetPropertyText("MyMap","MyLevel.LevelInfo1");
	if( MyMap==None )
		SetPropertyText("MyMap","MyLevel.LevelInfo2");
	if( MyMap==None )
		Warn("Couldn't find levelinfo!");
}

event bool Build()
{
	AText="";
	FindLevel();
	if( MyMap == None )
		GoTo NoMap;
	if (bLogNewNav)
		LogSpawnSelected();
	if (bLogTweakPoint)
		LogVectorialEtc();
	if (bGenerateDecoUC)
		GenerateNonStaticDeco();
	if (bLogActors)
		LogWrappedNames();
	if (bComputeDistance)
		ComputeTheseTwo();
	if (bCheckDuplicates)
		FindCrappedActors();
	if (bFixDuplicates)
		DestroyDupes();
	if (bLogBrushBuildLag)
	{
		if ( NumBrush == 0 )
			return BadParameters("NumBrush parameter should not be 0.");
		FindLaggerBuild();
	}
	if (bTestReach)
		TestTheseTwo();

	if ( bDisconnectN1toN2 )
	{
		RemovePath();
		bDisconnectN1toN2 = False;
	}

	if ( bCountReachSpecs )
		CountReachSpecs();

	if ( bConnectPathsFor )
		GeneratePath(N1,N2);

	if ( bGet1stN1 )
	{
		GetNodeN1();
		bGet1stN1 = False;
		bGet2ndN2 = False;
	}

	if ( bGet2ndN2 )
	{
		GetNodeN2();
		bGet2ndN2 = False;
	}

	if ( bModifyReachSpec )
		ModifySpec();

	if ( bDeleteReachSpec )
		RemoveAReachSpec();

	GoTo Ending;
NoMap:
	log ("No Map Environment for Operating...",'PathsLinker');
		return BadParameters("Did not find a clean Level...");
Ending:
	if (AText == "")
		AText="PathsLinker Operated.";
	return BadParameters(AText);
}

final function RemoveAReachSpec()
{
	local TempNode T;
	local string output, CRLF;
	local Actor Start, End;
	local int distance, reachFlags, i, j;

	CRLF = Chr(13)$Chr(10);

	if ( NSpec < 0 )
	{
		log ("You must specify reachSpec Index which will be deleted.",'NoIndexSpecified');
		if ( AText == "" )
			AText = "NSpec must be completed with"$CRLF$
			"    reachSpec Index for deletion."$CRLF;
		return;
	}

	T = MyMap.Spawn(class'TempNode');
	if ( T != None )
	{
		log ("Processing reachSpec... Attempting to find its references inside Navigation Network...",'ReachSpecSeeking');
		T.Paths[0] = NSpec;
		T.DescribeSpec(T.Paths[0], Start, End, reachFlags, distance);
		if ( Navigationpoint(Start) != None )
		{
			log ( "Found Start"@Start.Name,'ReachSpecHead');
			log ("Scanning paths list...",'Paths1To15');
			for (i = 0; i < 16; i++ )
			{
				if ( Navigationpoint(Start).Paths[i] == NSpec )
				{
					log ("Found it as Paths["$i$"]",'PendingRemoval');
					Navigationpoint(Start).Paths[i] = -1;
					log ("Compacting Paths...",'PathsDefrag');
					DefragPaths(NavigationPoint(Start));
					break;
				}
			}
		}
		if ( NavigationPoint(End) != None )
		{
			log ( "Found End"@End.Name,'ReachSpecTail');
			log ("Scanning upstreamPaths list...",'upstreamPaths1To15');
			for (j = 0; j < 16; j++ )
			{
				if ( Navigationpoint(End).upStreamPaths[j] == NSpec )
				{
					log ("Found it as upstreamPaths["$j$"]",'PendingRemoval');
					Navigationpoint(End).upStreamPaths[j] = -1;
					log ("Compacting upstreamPaths...",'upstreamPathsDefrag');
					DefragUpstreamPaths(NavigationPoint(End));
					break;
				}
			}
		}
		Start = None;
		End = None;
		T.Paths[0] = -1;
		T.RemoveReachSpec(NSpec);
		T.Destroy();
		T = None;
		RebuildNavigationSpecs();
	}
	else
	{
		log ("Working Node could not spawn. ReachSpec"@NSpec@"is not removed.",'NastyStuff');
		AText = "WARNING, Working Node did NOT spawn,"$CRLF$
		"reachSpec "$NSpec$" is not removed.";
		return;
	}
	output = CRLF$"	ReachSpec "$NSpec$" has been Removed from Navigation "$CRLF$"references and deleted."$CRLF$CRLF$
	"	Remaining reachSpecs have been renumbered "$CRLF$"and rewrapped in current Navigation Network."$CRLF$
	"	This means that ReachSpec "$NSpec+1$" has been changed "$CRLF$" into ReachSpec "$NSpec$" and so on."$CRLF$
	"	Last reachSpec might be seen multiple times until"$CRLF$"Editor will be closed and Garbage Objects removed."$CRLF;
	AText = output;
	log("Old ReachSpec"@NSpec@"has been deleted and next one took this number.",'DeletedAndRearanged');
	bDeleteReachSpec = False;
}

final function RebuildNavigationSpecs()
{
	local NavigationPoint N;
	local int i;

	foreach MyMap.AllActors(class'NavigationPoint',N)
	{
		for (i = 0; i < 16; i++)
		{
			if ( N.Paths[i] > NSpec )
				N.Paths[i] = N.Paths[i]-1;
			if ( N.upStreamPaths[i] > NSpec )
				N.UpstreamPaths[i] = N.UpstreamPaths[i]-1;
		}
	}
}

final function DefragPaths(NavigationPoint N)
{
	local bool bInvalid;
	local int i, np, cnt;
	local int wrap[16];

	bInvalid = ( N == None || N.bDeleteMe );

	if ( !bInvalid )
	{
		for ( i = 0; i < 16; i++ )
		{
			wrap[i] = N.Paths[i];
			N.Paths[i] = -1;
		}
		cnt = 0;
		for ( np = 0; np < 16; np++ )
		{
			if ( wrap[np] != -1 )
			{
				N.Paths[cnt] = wrap[np];
				cnt++;
			}
		}
	}
	else
		log("Borked - DefragPaths Entry ( NavigationPoint == None )",'PathsListDefragmenter');
}

final function DefragUpstreamPaths(NavigationPoint N)
{
	local bool bInvalid;
	local int i, np, cnt;
	local int wrap[16];

	bInvalid = ( N == None || N.bDeleteMe );

	if ( !bInvalid )
	{
		for ( i = 0; i < 16; i++ )
		{
			wrap[i] = N.UpstreamPaths[i];
			N.UpstreamPaths[i] = -1;
		}
		cnt = 0;
		for ( np = 0; np < 16; np++ )
		{
			if ( wrap[np] != -1 )
			{
				N.UpstreamPaths[cnt] = wrap[np];
				cnt++;
			}
		}
	}
	else
		log("Borked - DefragUpstreamPaths Entry ( NavigationPoint == None )",'UpStreamPathsListDefragmenter');
}

final function ModifySpec()
{
	local TempNode T;
	local string Output, CRLF;

	CRLF = Chr(13)$Chr(10);
	if ( NSpec < 0 )
	{
		log ("Please specify reachSpec index number.");
		Output = "Please specify other index number.";
		AText = Output$CRLF;
		return;
	}
	T = MyMap.Spawn(class'TempNode');
	if ( T != None )
	{
		log("Reachspec"@NSpec@"will have:",'PathModifier');
		log("    CollisionRadius ="@CRadius,'PathModifier');
		log("    CollisionHeight ="@CHeight,'PathModifier');
		log("        Reach Flags ="@RFlags,'PathModifier');
		Output="ReachSpec "$NSpec$" will have:"$CRLF$"    - CollisionRadius = "$CRadius$";"$CRLF$"    - CollisionHeight = "$CHeight$";"$CRLF$"    - ReachFlags = "$RFlags;
		T.EditReach(NSpec,,,,CRadius,CHeight,RFlags,False);
		T.Destroy();
		T = None;
		AText = Output;
	}
	else
		AText = "Could not spawn working node..."$CRLF;
}

final function GetNodeN1()
{
	local NavigationPoint N;

	N1 = None;
	foreach MyMap.AllActors(class'NavigationPoint', N)
	{
		if ( N.bSelected )
		{
			N1 = N;
			break;
		}
	}
	if ( N1 != None )
	{
		log ("Completing N1 as"@N1.Name,'Node1Taken');
		AText="Got "$N1.name$" as N1.";
	}
	else
	{
		log("Please select node which has to be the start of path - N1",'NoNodeN1');
		AText="Did not find a selected Node for N1.";
	}
}

final function GetNodeN2()
{
	local NavigationPoint N;

	N2 = None;
	foreach MyMap.AllActors(class'NavigationPoint', N)
	{
		if ( N.bSelected )
		{
			N2 = N;
			break;
		}
	}
	if ( N2 != None )
	{
		log ("Completing N2 as"@N2.Name,'Node2Taken');
		AText="Got "$N2.name$" as N2.";
	}
	else
	{
		log("Please select node which has to be the end of path - N2",'NoNodeN2');
		AText="Did not find a selected Node for N2.";
	}
}

final function GeneratePath(NavigationPoint N1, NavigationPoint N2)
{
	local int i, j, k;
	local int RIdx;
	local bool bBidir;
	local NavigationPoint Atmp;
	local string Output, CRLF;
	local Actor Start, End;
	local int distance, reachFlags;

	CRLF = Chr(13)$Chr(10);
	bBidir = bTwoWay;
	bConnectPathsFor = False;
	if ( N1 == None || N2 == None || RFlags == 0 || CRadius == 0 || CHeight == 0 )
	{
		log ("Cannot create a null reachSpec, please specify all path parameters.",'SpecGenerator');
		AText="Won't generate an invalid reachSpec"$CRLF$"N1 and N2 must be completed"$CRLF$"and also reach flags and collision data.";
		return;
	}
	if ( N1 == N2 )
	{
		log ("Won't link the same node as Start and End, do check what you want",'NoSpecGeneration');
		AText = "Node N1 won't get a link with itself."$CRLF$"Please specify for N1 and N2 different names"$CRLF$"which needs to get connected.";
		return;
	}
	for ( k = 0; k < 16; k++ )
	{
		if ( N1.Paths[k] > -1 )
		{
			N1.DescribeSpec(N1.Paths[k],Start,End,reachFlags,distance);
			if ( Start == N1 && End == N2 )
			{
				log (N1.name@"and"@N2.name@"are already connected. Watch out!",'ReachSpecExists');
				Output = "	-ALREADY CONNECTED-"$CRLF$"ReachSpec "$N1.Paths[k]$" has:"$CRLF$
				"Start		= "$Start.Name$CRLF$
				"End		= "$End.Name$CRLF$
				"Reach Flags	= "$reachFlags$CRLF$
				"Distance		= "$distance$CRLF$CRLF$"You can modify reachSpec "$N1.Paths[k]$" instead.";
				bBidir = False;
				GoTo Done;
			}
		}
	}
TwoWay:
	for ( i = 0; i < 16; i++ )
	{
		if ( N1.Paths[i] > -1 )
			continue;
		else
		{
			N1.Paths[i] = N1.GenReachSpec(N1,N2,int(VSize(N1.Location-N2.Location)),CRadius,CHeight,RFlags,False);
			RIdx = N1.Paths[i];
			log ("Created a reachSpec"@RIdx@"with distance ="@int(VSize(N1.Location-N2.Location)),'ReachSpecCreated');
			log ("               Start ="@N1.Name,'ReachSpecCreated');
			log ("                 End ="@N2.Name,'ReachSpecCreated');
			log ("     CollisionRadius ="@CRadius,'ReachSpecCreated');
			log ("     CollisionHeight ="@CHeight,'ReachSpecCreated');
			log ("Reach Flags required ="@RFlags,'ReachSpecCreated');
			log ("Next upstreamPaths[x] available in"@N2.Name@"will also have this reachSpec added.",'ReachSpecCreated' );
			Output = Output$"Created a reachSpec"@RIdx@"with distance ="@int(VSize(N1.Location-N2.Location))$CRLF$"               Start ="@N1.Name$CRLF$
			"                 End ="@N2.Name$CRLF$"     CollisionRadius ="@CRadius$CRLF$
			"     CollisionHeight ="@CHeight$CRLF$"Reach Flags required ="@RFlags$CRLF;
			break;
		}
	}
	for ( j = 0; j < 16; j++ )
	{
		if ( N2.upstreamPaths[j] > -1 )
			continue;
		else
		{
			N2.upstreamPaths[j] = RIdx;
			break;
		}
	}
	if ( bBidir )
	{
		Atmp = N1;
		N1 = N2;
		N2 = Atmp;
		bBidir = False;
		Goto TwoWay;
	}
//	AText = "ReachSpecs added and logged."$CRLF;
Done:
	AText = Output;
}

final function CountReachSpecs()
{
	local int I, J;
//	local Actor Start, End;
	local NavigationPoint N;

	foreach MyMap.AllActors(class 'NavigationPoint', N)
	{
		if ( N.Paths[0] > -1 )
			I++;
		if ( N.Paths[1] > -1 )
			I++;
		if ( N.Paths[2] > -1 )
			I++;
		if ( N.Paths[3] > -1 )
			I++;
		if ( N.Paths[4] > -1 )
			I++;
		if ( N.Paths[5] > -1 )
			I++;
		if ( N.Paths[6] > -1 )
			I++;
		if ( N.Paths[7] > -1 )
			I++;
		if ( N.Paths[8] > -1 )
			I++;
		if ( N.Paths[9] > -1 )
			I++;
		if ( N.Paths[10] > -1 )
			I++;
		if ( N.Paths[11] > -1 )
			I++;
		if ( N.Paths[12] > -1 )
			I++;
		if ( N.Paths[13] > -1 )
			I++;
		if ( N.Paths[14] > -1 )
			I++;
		if ( N.Paths[15] > -1 )
			I++;
		if ( N.PrunedPaths[0] > -1 )
			J++;
		if ( N.PrunedPaths[1] > -1 )
			J++;
		if ( N.PrunedPaths[2] > -1 )
			J++;
		if ( N.PrunedPaths[3] > -1 )
			J++;
		if ( N.PrunedPaths[4] > -1 )
			J++;
		if ( N.PrunedPaths[5] > -1 )
			J++;
		if ( N.PrunedPaths[6] > -1 )
			J++;
		if ( N.PrunedPaths[7] > -1 )
			J++;
		if ( N.PrunedPaths[8] > -1 )
			J++;
		if ( N.PrunedPaths[9] > -1 )
			J++;
		if ( N.PrunedPaths[10] > -1 )
			J++;
		if ( N.PrunedPaths[11] > -1 )
			J++;
		if ( N.PrunedPaths[12] > -1 )
			J++;
		if ( N.PrunedPaths[13] > -1 )
			J++;
		if ( N.PrunedPaths[14] > -1 )
			J++;
		if ( N.PrunedPaths[15] > -1 )
			J++;
	}
	log ("This map has"@I@"ReachSpecs shown as direct paths in Navigation Network.",'NumReachSpecs');
	log ("This map has"@J@"ReachSpecs as shortcuts aka PrunedPaths in Navigation Network.",'NumReachSpecs');
	log ("After calculation we have"@I+J@"ReachSpecs.",'NumReachSpecs');
	if ( (I + J) <= 0 )
	{
		log ("Map doesn't include paths?",'NumReachSpecs');
		Goto DoneReach;
	}
	if ( (I + J) > 3000 )
		log ("Technically this map is overloaded and this is not that healthy for A.I.",'NumReachSpecs');
	else
		log ("It looks like map has a normal reachspecs charge for UE1. Greetings !",'NumReachSpecs');
DoneReach:
	AText="Referenced"$I+J$"reachSpecs.";
}

final function RemovePath()
{
	local Actor Start, End;
//	local NavigationPoint N;
	local int distance, reachFlags, i, j, RIdx, RIdx2;
	local bool bFoundPath, bFoundUpStream;

/*
	Finally I got into what was NEEDED for years but no one has bothered with doing it
	This is just removing shit failures by un-referencing evil path as TranslocDest does in games
out of translocator - simple as a pie and very useful.
*/
	RIdx = -1;
	RIdx2 = RIdx;
	if ( N1 == None || N2 == None )
	{
		log ("You need to specify both N1 and N2 Navigation Points having evil path that has to be removed...",'Disconnector');
		log ("You can get them one by one by selecting node1, puting bool bGet1stN1 to True",'LazyHint');
		log ("And then the same with node2 not both in the same time - then using this command",'LazyHint');
		log ("If GUI interface of builder doesn't show anything it needs some clicks on values, for triggering a refresh.",'LazyHint');
		log ("bGet1stN1 will complete selected Node as N1 when is True and button BUILD pushed,",'LazyHint');
		log ("bGet2ndN2 will complete selected Node as N2 when is True and button BUILD pushed.",'LazyHint');
		log ("After completion of Names N1 and N2, value bDisconnectN1toN2 must be True and push BUILD button.",'LazyHint');
		log ("If everything is selected correctly Editor.log will have printed the action performed.",'LazyHint');
		return;
	}
	for ( i=0; i<16; i++ )
	{
		if ( N1.Paths[i] != -1 )
			N1.DescribeSpec( N1.Paths[i], Start, End, reachFlags, distance );
		if ( Start == N1 && End == N2 )
		{
			log ("Found Connection "$N1.Paths[i]$" from"@N1.Name@"to"@N2.Name@"with reachFlags ="@reachFlags$", removing ReachSpec reference...",'Disconnector');
			RIdx = N1.Paths[i];
			N1.Paths[i] = -1;
			bFoundPath = True;
			log ("Compacting paths list in"@N1.Name@"if possible...",'Disconnector');
			Start = None;
			End = None;
		}
	}
	if ( bFoundPath )
		DefragPaths(N1);
	if ( !bFoundPath )
		log ("There is no Path from"@N1.Name@"to"@N2.Name@"described in"@N1.Name$".",'Disconnector');
	log ("Searching UpstreamPaths reachSpec reference into"@N2.Name$"...",'Disconnector');
	for ( j=0; j<16; j++ )
	{
		if ( N2.UpstreamPaths[j] != -1 )
			N2.DescribeSpec( N2.UpstreamPaths[j], Start, End, reachFlags, distance );
		if ( Start == N1 && End == N2 )
		{
			log ("Found Connection "$N2.UpstreamPaths[j]$" from"@N1.Name@"to"@N2.Name@"with reachFlags ="@reachFlags$", removing ReachSpec reference...",'Disconnector');
			RIdx2 = N2.UpstreamPaths[j];
			if ( RIdx != RIdx2 )
				log ("Borked... N1 and N2 have duplicated reachSpec - Start End",'SERIOUSERROR');
			N2.UpstreamPaths[j] = -1;
			bFoundUpStream = True;
			log ("Compacting UpstreamPaths list in"@N2.Name@"if possible...",'Disconnector');
			Start = None;
			End = None;
		}

	}
	if ( bFoundUpStream )
		DefragUpstreamPaths(N2);
	if ( !bFoundUpStream )
		log ("There is no Upstream from"@N1.Name@"to"@N2.Name@"described in"@N2.Name$".",'Disconnector');
	if ( RIdx > -1 && ( bFoundPath || bFoundUpStream ) )
	{
		NSpec = RIdx;
		log("Eliminating reachSpec "$NSpec,'Disconnector');
		RemoveAReachSpec();
		NSpec = -1;
	}
	else
		log ("No reachSpec has been removed.",'Disconnector');
	if ( bFoundPath )
		log("Disconnected path going from"@N1.Name@"to"@N2.Name,'Disconnector');
	if ( bFoundUpStream )
		log("Disconnected upStreamPath going from"@N1.Name@"to"@N2.Name,'Disconnector');
	log("______________________________________________________________________________________________",'Disconnector');
	N1 = None;
	N2 = None;
	if ( AText == "" )
		AText = "Disconnecting operated.";
}

final function TestTheseTwo()
{
	local Actor A, A1, A2;
	local GunlocScout S;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.bSelected && A1 == None )
		{
			A1 = A;
			continue;
		}
		if ( A.bSelected && A2 == None )
		{
			A2 = A;
			break;
		}
	}
	if ( A1 != None && A2 != None )
	{
		S = MyMap.Spawn(class'GunlocScout',,,A1.Location);
		if (S == None) Goto UnabletoOperate;
		else
		{
			if (S.CheckReachability( A1,A2 ))
			{
				Log ("Route is OK from"@A1.Name@"to"@A2.Name@"having distance"@VSize(A1.Location-A2.Location)@"UU.");
				S.SetLocation(A2.Location);
				if (S.CheckReachability( A2,A1 ))
				{
					Log ("Route is OK from"@A2.Name@"to"@A1.Name@"having distance"@VSize(A2.Location-A1.Location)@"UU.");
				}
				else
				{
					Log ("Route from "$A2.Name$" to "$A1.Name$" doesn't seem reachable.");
					S.bCanFly = True;
					if (S.CheckReachability( A2,A1 ))
						Log("Flight is required for navigating from"@A2.Name@"to"@A1.Name);
				}
			}
			else
			{
				Log ("Route from "$A1.Name$" to "$A2.Name$" doesn't seem reachable.");
				S.bCanFly = True;
				if (S.CheckReachability( A1,A2 ))
					Log("Flight is required for navigating from"@A1.Name@"to"@A2.Name);
				S.bCanFly = False;
				S.SetLocation(A2.Location);
				if (S.CheckReachability( A2,A1 ))
				{
					Log ("Route is OK from"@A2.Name@"to"@A1.Name@"having distance"@VSize(A2.Location-A1.Location)@"UU.");
				}
				else
				{
					S.bCanFly = True;
					if (S.CheckReachability( A2,A1 ))
						Log("Flight is required for navigating from"@A2.Name@"to"@A1.Name);
					else
						Log ("Route from "$A2.Name$" to "$A1.Name$" doesn't seem reachable.");
				}
			}
			S.Destroy();
		}
		Goto DoneHere;
	}
UnabletoOperate:
	log ("Bad Selection... I'm sorry about that...");
DoneHere:
}

final function FindLaggerBuild()
{
	local Brush B;
	local INT i;

	foreach MyMap.AllActors(class 'Brush',B)
	{
		i++;
		if (i == NumBrush)
		{
			log ("Suspect Brush pausing build process ="@B.Name);
			break;
		}
	}
}

final function FindCrappedActors()
{
	local Actor A, A1;
	local Int i, j;

	foreach MyMap.AllActors(class'Actor',A)
	{
		foreach MyMap.AllActors(class'Actor',A1,A.Tag)
		{
			if ( string(A.Name) == string(A1.Name) )
			{
				i++;
			}
		}
		if ( i > 1 )
		{
			j++;
			log (A.Name@"was found"@i@"times.");
		}
		i = 0;
	}
	if ( j > 0 )
		log ("Found"@j@"duplicated Actors.");
	else
		log ("This Level doesn't seems to have duplicated actors at this check.");
}

final function DestroyDupes()
{
	local Actor A, A1;
	local int j, i;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.Tag == 'Duplicated' )
		{
			A.Destroy();
			j++;
			Continue;
		}
		else
		{
			foreach MyMap.AllActors(class'Actor',A1,A.Tag)
			{
				if ( string(A.Name) == string(A1.Name) )
				{
					i++;
					if ( i > 1 )
					{
						A1.Tag = 'Duplicated';
						i = 0;
					}
				}
			}
			i = 0;
		}
	}
	A = None;
	foreach MyMap.AllActors(class'Actor',A,'Duplicated')
		A.Tag = A.default.Tag;
	if ( j > 0 )
		log ("Removed"@j@"duplicated Actors. Do the check again...");
	else
		log ("There is nothing duplicated for removal.");
}

final function ComputeTheseTwo()
{
	local Actor A, A1, A2;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if ( A.bSelected && A1 == None )
		{
			A1 = A;
			continue;
		}
		if ( A.bSelected && A2 == None )
		{
			A2 = A;
			break;
		}
	}
	if ( A1 != None && A2 != None )
	{
		log ("Distance between"@A1.Name@"and"@A2.Name@"="@VSize(A1.Location-A2.Location)@"UU.");
		A1 = None; A2 = None;
	}
	else
		log("You must have 2 selected actors...");
}

final function LogWrappedNames()
{
	local int I;
	local Actor A;

	foreach MyMap.AllActors(class'Actor',A)
	{
		I++;
		log (A.Name@"is class"@A.Class@"and number"@I@".",'OrderOfActors');
	}
	log ( "Logged "$I$" actors..." );
}

final function LogSpawnSelected()
{
	local Actor A;
	local bool bRotated;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if (A.bSelected)
		{
			if ( A.Rotation.Pitch != 0 )
			{
				log ("NewRot.Pitch="$A.Rotation.Pitch$";",'UcCopy');
				bRotated = True;
			}
			if ( A.Rotation.Roll != 0 )
			{
				log ("NewRot.Roll="$A.Rotation.Roll$";",'UcCopy');
				bRotated = True;
			}
			if ( A.Rotation.Yaw != 0 )
			{
				log ("NewRot.Yaw="$A.Rotation.Yaw$";",'UcCopy');
				bRotated = True;
			}
			if ( bRotated && NavigationPoint(A) == None )
				log ( "Spawn(class'"$A.Tag$"',,,vect("$int(A.Location.X)$","$int(A.Location.Y)$","$int(A.Location.Z)$"),NewRot);",'UcCopy' );
			else
				log ( "Spawn(class'"$A.Tag$"',,,vect("$int(A.Location.X)$","$int(A.Location.Y)$","$int(A.Location.Z)$"));",'UcCopy' );
			bRotated = False;
		}
	}
}

final function LogVectorialEtc()
{
	local Actor A;
	local string str, sto;
	local int I;

	I=0;
	foreach MyMap.AllActors(class'Actor',A)
	{
		I++;
		if (A.bSelected)
		{
			if (A.IsA('NavigationPoint'))
			{
				log ( "foreach NavigationActors(class'"$GetClassName(A)$"',"$Left(GetClassName(A),2)$",30,vect("$int(A.Location.X)$","$int(A.Location.Y)$","$int(A.Location.Z)$"))",'UcCopy');
				log ("{",'UcCopy');
				log ("	if (string("$Left(GetClassName(A),2)$".Name) ~= "$CHR(34)$A.Name$CHR(34)$")",'UcCopy');
				log ("	{",'UcCopy');
				log ("		",'UcCopy');
				log ("		break;",'UcCopy');
				log ("	}",'UcCopy');
				log ("}",'UcCopy');
			}
			else
			{
				log ("	if (string(A.Name) ~= "$CHR(34)$A.Name$CHR(34)$") // Position "$I,'UcCopy');
				log ("	{",'UcCopy');
				log ("		",'UcCopy');
				log ("		continue;",'UcCopy');
				log ("	}",'UcCopy');
			}
			str = "";
			sto = "";
		}
	}
	I = 0;
}

final function GenerateNonStaticDeco()
{
	local Actor A;
//	local string str, sto;
//	local int I;

	foreach MyMap.AllActors(class'Actor',A)
	{
		if (A.bSelected)
		{
			if ( A.IsA('Decoration') )
			{
				log ("class E_"$GetClassName(A)$" expands "$GetClassName(A)$";",'UcCopy');
				log (" ",'UcCopy');
				log ("defaultproperties",'UcCopy');
				log ("{",'UcCopy');
				log ("	bStatic=False",'UcCopy');
				log ("	bNoDelete=False",'UcCopy');
				log ("	bMovable=True",'UcCopy');
				log ("	bGameRelevant=True",'UcCopy');
				log ("	bCollideWorld=False",'UcCopy');
				log ("	bCollideActors=False",'UcCopy');
				log ("	bCollideWhenPlacing=False",'UcCopy');
				log ("	ScaleGlow=240",'UcCopy');
				log ("	RemoteRole=ROLE_None",'UcCopy');
				log ("}",'UcCopy');
			}
		}
	}
}

function String GetClassName(Actor AnActor)
{

	Local string FullName, ClassName, Temp;
	Local int pos, I, J;

	Temp="None";
	if (AnActor == None) return Temp;
	FullName="";
	pos=-1;
	FullName=string(AnActor.Class);
	ClassName=string(AnActor.Class);
//	log (FullName);
	pos = InStr(FullName, ".");
//	log (pos);
	if ( InStr(FullName, ".") > 0 )
	{
		FullName=Left(FullName, InStr(FullName, "."));
		I = Len(FullName);
		J = Len(string(AnActor.Class));
		FullName = Right(ClassName,J-(I+1));
	}
//	log ("GetClassName::"@FullName@"for"@AnActor.Name);
	return FullName;
/*
	if (anActor == None)
		return string(None);
	return string(anActor.Class.Outer);
*/
//	return string(anActor.Class.Outer);
}

defaultproperties
{
	BitmapFilename="PathsLinker"
	ToolTip="Paths Linker"
	NSpec=-1
}
