
class RainActor expands Effects;
 
#exec TEXTURE IMPORT NAME=RDrop FILE=textures\RDrop.pcx
#EXEC AUDIO IMPORT NAME=Rainfall FILE=Sounds\Rainfall.wav
#exec OBJ LOAD FILE=..\Sounds\AmbOutside.uax PACKAGE=AmbOutside


var() float   Height;
var() float   Radius;
var() int     MaxDrops;
var() float   MinAirResistanceFactor;
var() float   MaxAirResistanceFactor;
var() vector  WindVelocity;
var() bool    bBlockByActors;
 
var int RainCount;
var float InitTime, InitTimeThreshold;
 
replication
{
   reliable if (Role==ROLE_Authority)
      Radius, MaxDrops, MinAirResistanceFactor, MaxAirResistanceFactor, WindVelocity, bBlockByActors;
}

simulated event PostBeginPlay()
{
   local Actor A;
   local vector HitLocation, HitNormal, TraceEnd;
   local float MinSpeed, MaxSpeed;

   if (Level.NetMode == NM_DedicatedServer)
      Disable('Tick');

  	SetTimer(10.0,True);
   MinAirResistanceFactor = FMax(MinAllowedResitanceFactor(), MinAirResistanceFactor);
   MaxAirResistanceFactor = FMax(MinAllowedResitanceFactor(), MaxAirResistanceFactor);
   WindVelocity = AdjustVelocity(WindVelocity, Region.Zone);

   InitTimeThreshold = class'RainDrop'.default.MeltingTime;
   MinSpeed = VSize(InitialVelocity(MaxAirResistanceFactor));
   MaxSpeed = VSize(InitialVelocity(MinAirResistanceFactor));
   if (Height <= 0)
   {
      Height = 32767;
      TraceEnd = Location - vect(0, 0, 1) * Height;
      A = Trace(HitLocation, HitNormal, TraceEnd,, false);
      if (A != none)
         Height = VSize(HitLocation - Location);
   }
   InitTimeThreshold += 2 * Height / (FMax(0, MinSpeed) + MaxSpeed);
}

function Timer ()
{
  	Super.Timer();
  	if (Rand(5) < 2)
  	{
    	if ( FRand() < 0.5 )
      	PlaySound(Sound'AmbOutside.OneShot.thund1',SLOT_Misc,25.0,True);
     	else
      	PlaySound(Sound'AmbOutside.OneShot.thunder',SLOT_Misc,25.0,True);
  	}
}

simulated event Tick(float DeltaTime)
{
   local int i;
   local RainDrop Flake;

   if (RainCount >= MaxDrops)
   {
      Disable('Tick');
      return;
   }

   InitTime += DeltaTime;

   for (i = RainCount; i < MaxDrops && RainCount * InitTimeThreshold < MaxDrops * InitTime; ++i)
   {
      Flake = Spawn(class'RainDrop', self);
      if (Flake != none)
         RainCount++;
   }
}

simulated function float MinAllowedResitanceFactor()
{
   return VSize(Region.Zone.ZoneGravity) / Square(Region.Zone.ZoneTerminalVelocity);
}

static function vector AdjustVelocity(vector V, ZoneInfo Zone)
{
   if (VSize(V) > Zone.ZoneTerminalVelocity)
      return Normal(V) * Zone.ZoneTerminalVelocity;
   return V;
}

simulated function vector InitialVelocity(float AirResistanceFactor)
{
   local vector GravityImpliedVelocity;

   GravityImpliedVelocity = Normal(Region.Zone.ZoneGravity) * Sqrt(VSize(Region.Zone.ZoneGravity) / AirResistanceFactor);
   return AdjustVelocity(GravityImpliedVelocity + WindVelocity, Region.Zone);
}

defaultproperties
{
   Height=0
   Radius=512
   MaxDrops=150
   MinAirResistanceFactor=0.014496
   MaxAirResistanceFactor=0.057983
   WindVelocity=(X=5,Y=5,Z=-300)
   bBlockByActors=False
   bAlwaysRelevant=True
   RemoteRole=ROLE_SimulatedProxy
   DrawType=DT_Sprite
   Style=STY_Masked
   Texture=Texture'RDrop'
   bNetTemporary=False
   bHidden=True
}

