
class RainDrop expands Effects;

const MinDesiredFPS = 55;
 
var float MeltingTime;
 
var RainActor Rainy;
var float AirResistanceFactor;
var vector InitialVelocity, WindVelocity;
var bool bHitWall;
 
event PostBeginPlay()
{
   bCollideWorld = true;
}
 
event FellOutOfWorld();
 
 
auto state Resetting
{
   event BeginState()
   {
      bHidden = true;
   }

   function SetupRain()
   {
      const MaxSetLocationAttempts = 16;
      local vector NewLoc, RandomDir;
      local float RandomAngle;
      local int i;

      Rainy = RainActor(Owner);
      if (Rainy == none || Rainy.bDeleteMe)
      {
         Destroy();
         return;
      }

      for (i = 0; i < MaxSetLocationAttempts; ++i)
      {
         RandomAngle = FRand() * 2 * Pi;
         RandomDir.X = Cos(RandomAngle);
         RandomDir.Y = Sin(RandomAngle);
         RandomDir.Z = 0;
         NewLoc = Rainy.Location + Rainy.Radius * FRand() * RandomDir;
         if (SetLocation(NewLoc) && !Region.Zone.bWaterZone)
            break;
      }
      bHidden = i == MaxSetLocationAttempts;

      if (bHidden)
         GotoState('Resetting'); 
      else
      {
         AirResistanceFactor = Square( Sqrt(Rainy.MinAirResistanceFactor) +
            FRand() * (Sqrt(Rainy.MaxAirResistanceFactor) - Sqrt(Rainy.MinAirResistanceFactor)));
         InitialVelocity = Rainy.InitialVelocity(AirResistanceFactor);
         SetCollision(Rainy.bBlockByActors, false, false);
         GotoState('FallingDown');
      }
   }

Begin:
   Sleep(0);
   SetupRain();
}

state FallingDown
{
   event BeginState()
   {
      SetTimer(0.5, true);
      SetPhysics(PHYS_Projectile);
   }

   event EndState()
   {
      Velocity = vect(0, 0, 0);
      SetCollision(false);
      SetPhysics(PHYS_None);
   }

   event HitWall(vector HitNormal, actor HitWall)
   {
      bHitWall = true;
      if (Abs(Velocity.Z) < 16 ||
         vect(0, 0, 1) * int(Velocity.Z < 0) Dot HitNormal > Sqrt(2) / 2)
      {
         GotoState('Melting');
      }
      else
      {
         Velocity = (0.9 * Velocity + MirrorVectorByNormal(Velocity, HitNormal)) / 2;
         if (Abs(Velocity.Z) < 16)
            GotoState('Melting');
      }
   }

   event Touch(Actor A)
   {
      if (A.bCollideActors && A.bBlockActors)
         GotoState('Resetting');
   }

   event ZoneChange(ZoneInfo NewZone)
   {
      if (NewZone.bWaterZone)
         GotoState('Resetting');
   }

   event Tick(float DeltaTime)
   {
      if (Rainy != none && !Rainy.bDeleteMe)
         WindVelocity = Rainy.WindVelocity;
      if (bHitWall)
         bHitWall = false;
      else
         Velocity = class'RainActor'.static.AdjustVelocity(Velocity + CalcAcceleration() * DeltaTime, Region.Zone);
      if (DeltaTime > Level.TimeDilation / MinDesiredFPS && FRand() < 0.1)
      {
         bHidden = true;
         SetCollision(false);
      }
   }

   function vector CalcAcceleration()
   {
   	local vector RelationalVelocity; // velocity of the Rain particle in relation to the wind
      local vector AirResistance;

      RelationalVelocity = Velocity - WindVelocity;
      AirResistance = -RelationalVelocity * VSize(RelationalVelocity) * AirResistanceFactor;

      return Region.Zone.ZoneGravity + AirResistance;
   }

Begin:
   Velocity = InitialVelocity;
}

state Melting
{
Begin:
	spawn(class'RainPuddle',,,Location);
   Sleep(MeltingTime);
   GotoState('Resetting');
}

defaultproperties
{
   RemoteRole=ROLE_None
   DrawType=DT_Sprite
   Style=STY_Translucent
   Texture=Texture'RDrop'
   DrawScale=0.2
   bBounce=True
   CollisionRadius=1
   CollisionHeight=1
   MeltingTime=.001
}
