
class SnowDrop expands Effects;

const MinDesiredFPS = 55;
 
var float MeltingTime;
 
var SnowActor Snowy;
var float AirResistanceFactor;
var vector InitialVelocity, WindVelocity;
var bool bHitWall;
 
event PostBeginPlay()
{
   bCollideWorld = true;
}
 
event FellOutOfWorld();
 
 
auto state Resetting
{
   event BeginState()
   {
      bHidden = true;
   }

   function SetupSnow()
   {
      const MaxSetLocationAttempts = 16;
      local vector NewLoc, RandomDir;
      local float RandomAngle;
      local int i;

      Snowy = SnowActor(Owner);
      if (Snowy == none || Snowy.bDeleteMe)
      {
         Destroy();
         return;
      }

      for (i = 0; i < MaxSetLocationAttempts; ++i)
      {
         RandomAngle = FRand() * 2 * Pi;
         RandomDir.X = Cos(RandomAngle);
         RandomDir.Y = Sin(RandomAngle);
         RandomDir.Z = 0;
         NewLoc = Snowy.Location + Snowy.Radius * FRand() * RandomDir;
         if (SetLocation(NewLoc) && !Region.Zone.bWaterZone)
            break;
      }
      bHidden = i == MaxSetLocationAttempts;

      if (bHidden)
         GotoState('Resetting');
      else
      {
         AirResistanceFactor = Square( Sqrt(Snowy.MinAirResistanceFactor) +
            FRand() * (Sqrt(Snowy.MaxAirResistanceFactor) - Sqrt(Snowy.MinAirResistanceFactor)));
         InitialVelocity = Snowy.InitialVelocity(AirResistanceFactor);
         SetCollision(Snowy.bBlockByActors, false, false);
         GotoState('FallingDown');
      }
   }

Begin:
   Sleep(0);
   SetupSnow();
}
 
state FallingDown
{
   event BeginState()
   {
      SetTimer(0.5, true);
      SetPhysics(PHYS_Projectile);
   }
 
   event EndState()
	{
      Velocity = vect(0, 0, 0);
      SetCollision(false);
      SetPhysics(PHYS_None);
   }
 
   event HitWall(vector HitNormal, actor HitWall)
   {
      bHitWall = true;
      if (Abs(Velocity.Z) < 16 || vect(0, 0, 1) * int(Velocity.Z < 0) Dot HitNormal > Sqrt(2) / 2)
      {
         GotoState('Melting');
      }
      else
      {
         Velocity = (0.9 * Velocity + MirrorVectorByNormal(Velocity, HitNormal)) / 2;
         if (Abs(Velocity.Z) < 16)
            GotoState('Melting');
      }
   }
 
   event Touch(Actor A)
   {
   	if (A.bCollideActors && A.bBlockActors)
      	GotoState('Resetting');
   }
 
   event ZoneChange(ZoneInfo NewZone)
   {
      if (NewZone.bWaterZone)
         GotoState('Resetting');
   }
 
   event Tick(float DeltaTime)
   {
      if (Snowy != none && !Snowy.bDeleteMe)
         WindVelocity = Snowy.WindVelocity;
      if (bHitWall)
         bHitWall = false;
      else
         Velocity = class'SnowActor'.static.AdjustVelocity(Velocity + CalcAcceleration() * DeltaTime, Region.Zone);
      if (DeltaTime > Level.TimeDilation / MinDesiredFPS && FRand() < 0.1)
      {
         bHidden = true;
         SetCollision(false);
      }
   }
 
   function vector CalcAcceleration()
   {
      local vector RelationalVelocity; // velocity of the snow particle in relation to the wind
      local vector AirResistance;
 
      RelationalVelocity = Velocity - WindVelocity;
      AirResistance = -RelationalVelocity * VSize(RelationalVelocity) * AirResistanceFactor;
 
      return Region.Zone.ZoneGravity + AirResistance;
   }
 
Begin:
   Velocity = InitialVelocity;
}
 
state Melting
{
Begin:
   Sleep(MeltingTime);
   GotoState('Resetting');
}
 
defaultproperties
{
   RemoteRole=ROLE_None
   DrawType=DT_Sprite
   Style=STY_Translucent
   Texture=Texture'Snow1'
   DrawScale=0.2
   bBounce=True
   CollisionRadius=1
   CollisionHeight=1
   MeltingTime=1
}
