class BinarySerializer expands Object
	native;

var const int Version;
var native const int Archive;

var bool bFileOpen;
var bool bWrite;

// Serialization functions all modify the OUT parameters if file is in read mode
// These are used for quick type conversion and reading

native final function bool SerializeString( out string Text);
native final function bool SerializeInt( out int I);
native final function bool SerializeFloat( out float F);
native final function bool SerializeByte( out byte B);
native final function bool SerializeRotator( out rotator R);
native final function bool SerializeVector( out vector V);


// Reads/Writes 4 bytes from an object at a certain unreal variable's address
// This can be used to set multiple booleans packed in the same 4 byte block
// Example:
// - var bool bVar1, bVar2, bVar3,...;
//Doing SerializeFlags( something, 'bVar1', 4); will read and write all of the booleans in the block (up to 32)
//Do not use this for dynamic arrays and strings
native final function bool SerializeTo( Object O, name VariableName, optional int LimitSize);

native final function bool OpenFileRead( string FileName);
native final function bool OpenFileWrite( string FileName);
native final function bool CloseFile();


defaultproperties
{
    Version=1
}
