/*=============================================================================
UBinary
Educational code made by Higor
You're free to use it :)
=============================================================================*/

// Includes.
#include "UBinary.h"

/*-----------------------------------------------------------------------------
	The following must be done once per package (.dll).
-----------------------------------------------------------------------------*/

// This is some necessary C++/UnrealScript glue logic.
// If you forget this, you get a VC++ linker errors like:
// SampleClass.obj : error LNK2001: unresolved external symbol "class FName  SAMPLENATIVEPACKAGE_SampleEvent" (?SAMPLENATIVEPACKAGE_SampleEvent@@3VFName@@A)
#define NAMES_ONLY
#define AUTOGENERATE_NAME(name) UBINARY_API FName UBINARY_##name;
#define AUTOGENERATE_FUNCTION(cls,idx,name) IMPLEMENT_FUNCTION(cls,idx,name)
#include "UBinaryClasses.h"
#undef AUTOGENERATE_FUNCTION
#undef AUTOGENERATE_NAME
#undef NAMES_ONLY
void RegisterNames()
{
	static INT Registered=0;
	if(!Registered++)
	{
		#define NAMES_ONLY
		#define AUTOGENERATE_NAME(name) extern UBINARY_API FName UBINARY_##name; UBINARY_##name=FName(TEXT(#name),FNAME_Intrinsic);
		#define AUTOGENERATE_FUNCTION(cls,idx,name)
		#include "UBinaryClasses.h"
		#undef DECLARE_NAME
		#undef NAMES_ONLY
	}
}

// Package implementation.
IMPLEMENT_PACKAGE(UBinary);

/*-----------------------------------------------------------------------------
	UBinary functions
-----------------------------------------------------------------------------*/

UBOOL UBinarySerializer::CloseFile()
{
	guard(UBinarySerializer::CloseFile);
	if ( Archive )
	{
		Archive->Close();
		bWrite = 0;
		bFileOpen = 0;
		Position = 0;
		TotalSize = 0;
		Archive = NULL;
		return true;
	}
	debugf( NAME_Warning, TEXT("Failed CloseFile, no file to close"));
	return false;
	unguard;
}

void UBinarySerializer::execCloseFile(FFrame &Stack, RESULT_DECL)
{
	P_FINISH;
	*(UBOOL*)Result = CloseFile();
}

void UBinarySerializer::execcloseFile(FFrame &Stack, RESULT_DECL)
{
	P_FINISH;
	*(UBOOL*)Result = CloseFile();
}

void UBinarySerializer::execOpenFileWrite(FFrame &Stack, RESULT_DECL)
{
	guard(UBinarySerializer::execOpenFileWrite);
	P_GET_STR(SrcFile);
	P_FINISH;
	if ( Archive )
	{
		*(UBOOL*)Result = false;
		debugf( NAME_Warning, TEXT("Failed OpenFileWrite, there's already an open file, close it first"));
		return;
	}
	Archive = GFileManager->CreateFileWriter( *SrcFile, FILEWRITE_EvenIfReadOnly );
	if ( Archive )
	{
		*(UBOOL*)Result = true;
		bWrite = 1;
		return;
	}
	*(UBOOL*)Result = false;
	unguard;
}

void UBinarySerializer::execOpenFileRead(FFrame &Stack, RESULT_DECL)
{
	guard(UBinarySerializer::execOpenFileRead);
	P_GET_STR(SrcFile);
	P_FINISH;
	*(UBOOL*)Result = false;
	if ( Archive )
	{
		debugf( NAME_Warning, TEXT("Failed OpenFileRead, there's already an open file, close it first"));
		return;
	}
	Archive = GFileManager->CreateFileReader( *SrcFile );
	if ( Archive )
	{
		*(UBOOL*)Result = true;
		TotalSize = Archive->TotalSize();
		return;
	}
	unguard;
}

void UBinarySerializer::execSerializeInt(FFrame &Stack, RESULT_DECL)
{
	guard(UBinarySerializer::execSerializeInt);
	P_GET_INT_REF( I);
	P_FINISH;
	if ( !Archive )
	{
		*(UBOOL*)Result = false;
		debugf( NAME_Warning, TEXT("Failed SerializeInt, no file"));
		return;
	}
	*Archive << *I;
	Position += 4;
	*(UBOOL*)Result = true;
	unguard;
}

void UBinarySerializer::execSerializeFloat(FFrame &Stack, RESULT_DECL)
{
	guard(UBinarySerializer::execSerializeFloat);
	P_GET_FLOAT_REF( F);
	P_FINISH;
	if ( !Archive )
	{
		*(UBOOL*)Result = false;
		debugf( NAME_Warning, TEXT("Failed SerializeFloat, no file"));
		return;
	}
	*Archive << *F;
	Position += 4;
	*(UBOOL*)Result = true;
	unguard;
}

void UBinarySerializer::execSerializeByte(FFrame &Stack, RESULT_DECL)
{
	guard(UBinarySerializer::execSerializeByte);
	P_GET_BYTE_REF( B);
	P_FINISH;
	if ( !Archive )
	{
		*(UBOOL*)Result = false;
		debugf( NAME_Warning, TEXT("Failed SerializeByte, no file"));
		return;
	}
	*Archive << *B;
	Position++;
	*(UBOOL*)Result = true;
	unguard;
}

void UBinarySerializer::execSerializeString(FFrame &Stack, RESULT_DECL)
{
	guard(UBinarySerializer::execSerializeString);
	P_GET_STR_REF( S);
	P_FINISH;
	if ( !Archive )
	{
		*(UBOOL*)Result = false;
		debugf( NAME_Warning, TEXT("Failed SerializeString, no file"));
		return;
	}
	*Archive << *S;
	Position = Archive->Tell();
	*(UBOOL*)Result = true;
	unguard;
}

void UBinarySerializer::execSerializeVector(FFrame &Stack, RESULT_DECL)
{
	guard(UBinarySerializer::execSerializeVector);
	P_GET_VECTOR_REF( V);
	P_FINISH;
	if ( !Archive )
	{
		*(UBOOL*)Result = false;
		debugf( NAME_Warning, TEXT("Failed SerializeVector, no file"));
		return;
	}
	*Archive << *V;
	Position += 12;
	*(UBOOL*)Result = true;
	unguard;
}

void UBinarySerializer::execSerializeRotator(FFrame &Stack, RESULT_DECL)
{
	guard(UBinarySerializer::execSerializeRotator);
	P_GET_ROTATOR_REF( R);
	P_FINISH;
	if ( !Archive )
	{
		*(UBOOL*)Result = false;
		debugf( NAME_Warning, TEXT("Failed SerializeRotator, no file"));
		return;
	}
	*Archive << *R;
	Position += 12;
	*(UBOOL*)Result = true;
	unguard;
}

void UBinarySerializer::execSerializeTo(FFrame &Stack, RESULT_DECL)
{
	guard(UBinarySerializer::execSerializeTo);
	P_GET_OBJECT( UObject, O);
	P_GET_NAME( VariableName);
	P_GET_INT( LimitSize);
	P_FINISH;
	if ( !Archive )
	{
		*(UBOOL*)Result = false;
		debugf( NAME_Warning, TEXT("Failed SerializeTo, no file"));
		return;
	}
	if ( !O )
	{
		*(UBOOL*)Result = false;
		debugf( NAME_Warning, TEXT("Failed SerializeTo, no Object specified"));
		return;
	}
	
	for( TFieldIterator<UProperty> It( O->GetClass() ); It; ++It )
		if ( appStricmp( It->GetName(), *VariableName )== 0 )
		{
			INT aSize = It->ElementSize * It->ArrayDim;
			if ( LimitSize <= 0 || LimitSize > aSize )
				LimitSize = aSize;
			BYTE* Data = (BYTE*)O + It->Offset;
			Archive->Serialize( Data, LimitSize);
			*(UBOOL*)Result = true;
			Position += Archive->Tell();
			return;
		}

	debugf( NAME_Warning, TEXT("Failed SerializeTo, Variable %s not found"), VariableName);
	*(UBOOL*)Result = false;
	unguard;
}

void UBinarySerializer::Serialize( FArchive& Ar )
{
	if ( Archive )
		Archive->Close();
}


IMPLEMENT_CLASS(UBinarySerializer);


/*-----------------------------------------------------------------------------
	The End.
-----------------------------------------------------------------------------*/
