//-----------------------------------------------------------------------//
//!   @file       ase2t3d_file.cpp
//!   @author     Dire Stockdale, 
//!   @author     <a href=http://www.solosnake.com>www.solosnake.com</a>
//!   @date       08 02 2001
//!   @version    1.00  
//!   My basic file io additions. Mostly for use in extracting or searching a file
//!   for strings.  
//! 
//-----------------------------------------------------------------------//
#include "ase2t3d_file.h"


/**
*   MYBUFFER is the size of the buffer reserved for reading in strings used in my_filio.h.
*   Attempting to read strings longer then this may lead to undefined errors.
*/
#ifndef MYBUFFER
    #define MYBUFFER 120
#endif


/**
*   Extracts the file from a string by looking to the last backslash char
*   and copying the remaining string into the szString. This function was written for 
*   stripping the file path from the filename in my file convertors. Ensures the string
*   is null terminated. This function assumes that the string has been read in from 
*   the 3ds ASE file and is surrounded by " chars.
*/
void ExtractFile(char* szString)
    {
    char ch = '\\';
    char *pLast = ::strrchr(szString, ch);    // Last '\' in string
    // Don't want last "
    if (pLast++) 
        {
        ::strcpy(szString, pLast);
        ch = '"';
        pLast = ::strrchr(szString, ch);
        if(pLast)*pLast='\0';
        }
    }


/**
*   Returns true if string szMatch is found in file after the current position.
*   If it is not found the file position pointer is not moved. If it is found 
*   then the pointer pointes to the next byte after szMatch.
*/
bool FindinFile(std::ifstream& pFile, const char* const szMatch)
    {
    using namespace std;
    char    szBuffer[MYBUFFER];      // Hold line to parse for info
    memset(szBuffer, 'x', sizeof(char)*MYBUFFER);
    const streampos filePosition = pFile.tellg();

    pFile.clear();
    while ( pFile.eof() == 0 )
        {
        pFile >> szBuffer; // NB: Note Leading Wht space
        if (! strcmp(szBuffer, szMatch)) 
            {
            return true;
            }
        }

    pFile.clear();    
    pFile.seekg(filePosition);
    return false;
    }


/**
*   Similar in function to FindinFile, finds szMatch in file but returns false if it 
*   finds szStop first. Resets the file position pointer to the initial position if szStop is
*   found or if neither is found. If szMAtch is found the position is the next byte after szMatch.
*/
bool FindinFileBefore(std::ifstream& pFile, const char* const szMatch, const char* const szStop)
    {
    using namespace std;
    char    szBuffer[MYBUFFER];      // Hold line to parse for info
    memset(szBuffer, 'x', sizeof(char)*MYBUFFER);
    const streampos filePosition = pFile.tellg();

    pFile.clear();
    while ( pFile.eof() == 0 )
        {
        pFile >> szBuffer;

        if (! strcmp(szBuffer, szStop) ) 
            {
            pFile.seekg(filePosition);
            return false;
            }

        if (! strcmp(szBuffer, szMatch) ) 
            {
            return true;
            }
        }

    pFile.clear();
    pFile.seekg(filePosition);

    const streampos filePosition2 = pFile.tellg();

    return false;
    }


/**
*   Returns true if file exists. This is perfomed by attempting to open the file as an
*   ifstream.
*/
int FileExists(const char* const szFile)
    {
    using namespace std;
    ifstream pFile(szFile);
    int b = pFile.is_open();
    pFile.close();
    return b;
    }

#undef MYBUFFER
//-----------------------------------------------------------------------//