// TextureSize.cpp : implementation file
//

#include <afxwin.h>         // MFC core and standard components
#include <afxext.h>         // MFC extensions
#include <afxdtctl.h>
#include <afxcmn.h>	
#include "ase2t3d_winapp.h"
#include "ase2t3d_texturesize.h"
#include "ase2t3d_pcx.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTextureSize dialog


CTextureSize::CTextureSize(CWnd* pParent /*=NULL*/)
	: CDialog(CTextureSize::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTextureSize)
	m_dwHeight = 256;
	m_dwWidth = 256;
	//}}AFX_DATA_INIT
}


void CTextureSize::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTextureSize)
	DDX_Control(pDX, IDC_BROWSEPCX, m_PCXButton);
	DDX_Text(pDX, IDC_HEIGHT, m_dwHeight);
	DDV_MinMaxDWord(pDX, m_dwHeight, 32, 2048);
	DDX_Text(pDX, IDC_WIDTH, m_dwWidth);
	DDV_MinMaxDWord(pDX, m_dwWidth, 32, 2048);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTextureSize, CDialog)
	//{{AFX_MSG_MAP(CTextureSize)
	ON_BN_CLICKED(IDC_BROWSEPCX, OnBrowsepcx)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTextureSize message handlers

int CTextureSize::DoModal() 
{
	return CDialog::DoModal();
}

void CTextureSize::CalcWindowRect(LPRECT lpClientRect, UINT nAdjustType) 
{
	
	CDialog::CalcWindowRect(lpClientRect, nAdjustType);
}


BOOL CTextureSize::OnInitDialog() 
{
	CDialog::OnInitDialog();

    this->SetWindowText( m_szTitle.c_str() );
	
	CSpinButtonCtrl * cspin = (CSpinButtonCtrl *)GetDlgItem( IDC_WIDTHSPIN );
    cspin->SetRange( 32, 2048 );
    cspin->SetPos( m_dwWidth );

    cspin = (CSpinButtonCtrl *)GetDlgItem( IDC_HEIGHTSPIN );
    cspin->SetRange( 32, 2048 );
    cspin->SetPos( m_dwHeight );
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}



DWORD CTextureSize::GetTextureWidth()
{
return m_dwWidth;
}



DWORD CTextureSize::GetTextureHeight()
{
return m_dwHeight;
}


/**
*   Prompts user to browse for PCX file to find texture sizes.
*/
void CTextureSize::OnBrowsepcx() 
    {
    const char BASED_CODE szFilter[] = "Unreal PCX Files (*.pcx)|*.pcx|All Files (*.*)|*.*||"; 
    //
    // Prompt user to choose a file to open.
    //
	CFileDialog findfile( true,  // Want an 'open' type
                          "pcx", // Default extension.
                          NULL,  // Initial file name
                          OFN_FILEMUSTEXIST|OFN_PATHMUSTEXIST,
                          szFilter,
                          NULL );

    //
    // If the user has chosen PCX file to check for texture size
    //
    if( IDOK == findfile.DoModal() )
        {
        PCXHeader pcx;

        ZeroMemory(&pcx, sizeof(pcx));

        std::string szFile = findfile.GetFileName();

        this->SetWindowText( findfile.GetFileName() );

        std::ifstream ifile( szFile.c_str() );
        if( false == ifile.is_open() )
            {
            MessageBox( _TEXT("Unable to open file for reading."), _TEXT("PCX Error") );
            return;
            }

        ifile.read( reinterpret_cast<char*>(&pcx), sizeof(pcx) );

        //
        // Check that it *is* as PCX file
        //
        if( 0x0A != pcx.Identifier )
            {
            MessageBox( _TEXT("The file does not appear to be a vaild PCX file format."), _TEXT("PCX Error") );
            return;
            }

        //
        // Set position correctly
        //
        m_dwWidth  = 1 + pcx.XEnd - pcx.XStart;
        m_dwHeight = 1 + pcx.YEnd - pcx.YStart;

        CSpinButtonCtrl * cspin = (CSpinButtonCtrl *)GetDlgItem( IDC_WIDTHSPIN );
        cspin->SetPos( m_dwWidth );

        cspin = (CSpinButtonCtrl *)GetDlgItem( IDC_HEIGHTSPIN );
        cspin->SetPos( m_dwHeight );

        CWnd* cw = (CWnd*)GetDlgItem( IDOK );
        cw->SetFocus();

        ifile.close();
        }
    }
