// AdvancedOptions.cpp : implementation file
//

#include <afxwin.h>         // MFC core and standard components
#include <afxext.h>         // MFC extensions
#include <afxdtctl.h>
#include <afxcmn.h>	
#include "ase2t3d_winapp.h"
#include "ase2t3d_advanced_options.h"
#include <atlbase.h>

#pragma warning( disable : 4996 ) // ATL::CRegKey::QueryValue' was declared deprecated

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define POLYGONDEFAULTFLAGS (0x00000000)
#define SOLO_REGISTRY_KEY   "Software\\solosnake\\ASEtoT3D"
#define SOLO_REG_BASE_KEY   "Software\\solosnake"
#define SOLO_ASET3D_KEY     "ASEtoT3D"
#define POLYFLAGSREGVALUE   "PolyFlags"
#define CUSTOMFLAGS         "Custom"
#define TEXTUREFLAGS        "TxOpt"
#define TEXTUREWIDTH        "TxWidth"
#define TEXTUREHEIGHT       "TxHeight"

//
// custom holds the flag settings for which way to get tehpolyflags and also
// whether or not to reset after each conversion.
#define CUSTOMDERIVE        (0x00000001)
#define CUSTOMUSER          (0x00000002)
#define CUSTOMKEEP          (0x00000004)
#define CUSTOMRESET         (0x00000008)
#define CUSTOMDEFAULTVALUE  CUSTOMDERIVE|CUSTOMKEEP


//
// Which texture size option to use. These are not bitflags
// and are used in switch-case paths.
#define USE256              (0x00000001)
#define PROMPT              (0x00000002)
#define USECUSTOM           (0x00000003)

/////////////////////////////////////////////////////////////////////////////
// CAdvancedOptions dialog


CAdvancedOptions::CAdvancedOptions(CWnd* pParent /*=NULL*/)
	: CDialog(CAdvancedOptions::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAdvancedOptions)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

    //
    // Enable tool tips
    //
    this->EnableToolTips(true);

}


void CAdvancedOptions::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAdvancedOptions)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


/////////////////////////////////////////////////////////////////////////////
BOOL CAdvancedOptions::OnToolTip( UINT id, NMHDR * pTTTStruct, LRESULT * pResult )
    {
    TOOLTIPTEXT *pTTT = (TOOLTIPTEXT *)pTTTStruct;
    UINT nID =pTTTStruct->idFrom;
    
    //
    // Get ID of control wanting Tip
    //
    nID = ::GetDlgCtrlID((HWND)nID);

    switch( nID )
        {
        case IDC_USE256X256:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_USE256);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_TEXTUREPROMPT:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PROMPT);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_TEXTURECUSTOM:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_CUSTOMSIZE);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_HEIGHT:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_HEIGHT);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_WIDTH:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_WIDTH);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PF_INVISIBLE:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFINVISIBLE);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PF_MASKED:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFMASKED);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PF_TRANSLUCENT:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFTRANSLUCENT);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PF_NOTSOLID:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFNOTSOLID);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PF_ENVIRONMENT:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFENVIRONMENT);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PF_FORCEVIEWZONE:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFFORCEVIEWZONE);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PF_SEMISOLID:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFSEMISOLID);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFMODULATED:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFMODULATED);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFFAKEBACKDROP:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFFAKEBACKDROP);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFTWOSIDED:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFTWOSIDED);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFAUTOUPAN:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFAUTOUPAN);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFAUTOVPAN:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFAUTOVPAN);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFNOSMOOTH:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFNOSMOOTH);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFBIGWAVY:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFBIGWAVY);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFSPECIALPOLYGON:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFSPECIALPOLYGON);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFSMALLWAVY:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFSMALLWAVY);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFFLAT:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFFLAT);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFLOWSHADOWDETAIL:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFLOWSHADOWDETAIL);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFNOMERGE:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFNOMERGE);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFCLOUDWAVY:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFCLOUDWAVY);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFDIRTYSHADOWS:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFDIRTYSHADOWS);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFBRIGHTCORNERS:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFBRIGHTCORNERS);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFSPECIALLIT:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFSPECIALLIT);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFGOURAUD:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFGOURAUD);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PF_NOBOUNDREJECTION:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFNOBOUNDREJECTION);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFUNLIT:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFUNLIT);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFHIGHSHADOWDETAIL:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFHIGHSHADOWDETAIL);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFPORTAL:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFPORTAL);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFMIRRORED:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFMIRRORED);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFNOOCCLUDE:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFNOOCCLUDE);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PFNOSHADOWS:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_PFNOSHADOWS);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_ASEFLAGS:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_USEASEFLAGS);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_CUSTOMFLAGS:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_USECUSTOMFLAGS);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        }
    

    return TRUE;
    }


BEGIN_MESSAGE_MAP(CAdvancedOptions, CDialog)
	//{{AFX_MSG_MAP(CAdvancedOptions)
    ON_NOTIFY_EX( TTN_NEEDTEXT, 0, OnToolTip )
	ON_BN_CLICKED(IDC_PFNOSHADOWS, OnPfnoshadows)
	ON_BN_CLICKED(IDC_PFNOOCCLUDE, OnPfnoocclude)
	ON_BN_CLICKED(IDC_PF_MASKED, OnPfMasked)
	ON_BN_CLICKED(IDC_PF_TRANSLUCENT, OnPfTranslucent)
	ON_BN_CLICKED(IDC_PF_INVISIBLE, OnPfInvisible)
	ON_BN_CLICKED(IDC_PFMODULATED, OnPfmodulated)
	ON_BN_CLICKED(IDC_PFUNLIT, OnPfunlit)
	ON_BN_CLICKED(IDC_PF_ENVIRONMENT, OnPfEnvironment)
	ON_BN_CLICKED(IDC_PFFAKEBACKDROP, OnPffakebackdrop)
	ON_BN_CLICKED(IDC_ASEFLAGS, OnAseflags)
	ON_BN_CLICKED(IDC_CUSTOMFLAGS, OnCustomflags)
	ON_BN_CLICKED(IDC_USE256X256, OnUse256x256)
	ON_BN_CLICKED(IDC_TEXTUREPROMPT, OnTextureprompt)
	ON_WM_SHOWWINDOW()
	ON_BN_CLICKED(IDC_TEXTURECUSTOM, OnTexturecustom)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAdvancedOptions message handlers


/**
*   Set the converter flags.
*/
void CAdvancedOptions::OnOK() 
    {
    //
    // Get texture optioon and set height and width correctly
    //
    CString str;
    CWnd * pw = NULL;


    //
    // Only when USECUSTOM is chosen is the texture sizes reset.
    //
    if( m_dwTextureOption == USECUSTOM )
        {
        pw = (CWnd*)GetDlgItem( IDC_HEIGHT );
        pw->GetWindowText( str );
        m_dwTextureHeight = ::atol( str );
        
        pw = (CWnd*)GetDlgItem( IDC_WIDTH );
         pw->GetWindowText( str );
        m_dwTextureWidth = ::atol( str );
        }

	//
    // Go through all flags and set the correct values
    //
    m_dwFlags = 0;

    CButton *pb = (CButton*)GetDlgItem( IDC_PF_INVISIBLE );
    if( pb->GetCheck() ) m_dwFlags |= PF_Invisible;

    pb = (CButton*)GetDlgItem( IDC_PF_TRANSLUCENT );
    if( pb->GetCheck() ) m_dwFlags |= PF_Translucent;

    pb = (CButton*)GetDlgItem( IDC_PF_MASKED );
    if( pb->GetCheck() ) m_dwFlags |= PF_Masked;

    pb = (CButton*)GetDlgItem( IDC_PF_NOTSOLID );
    if( pb->GetCheck() ) m_dwFlags |= PF_NotSolid;

    pb = (CButton*)GetDlgItem( IDC_PF_ENVIRONMENT );
    if( pb->GetCheck() ) m_dwFlags |= PF_Environment;

    pb = (CButton*)GetDlgItem( IDC_PF_FORCEVIEWZONE );
    if( pb->GetCheck() ) m_dwFlags |= PF_ForceViewZone;

    pb = (CButton*)GetDlgItem( IDC_PF_SEMISOLID );
    if( pb->GetCheck() ) m_dwFlags |= PF_Semisolid;

    pb = (CButton*)GetDlgItem( IDC_PFMODULATED );
    if( pb->GetCheck() ) m_dwFlags |= PF_Modulated;

    pb = (CButton*)GetDlgItem( IDC_PFFAKEBACKDROP );
    if( pb->GetCheck() ) m_dwFlags |= PF_FakeBackdrop;

    pb = (CButton*)GetDlgItem( IDC_PFTWOSIDED );
    if( pb->GetCheck() ) m_dwFlags |= PF_TwoSided;

    pb = (CButton*)GetDlgItem( IDC_PFAUTOUPAN );
    if( pb->GetCheck() ) m_dwFlags |= PF_AutoUPan;

    pb = (CButton*)GetDlgItem( IDC_PFAUTOVPAN );
    if( pb->GetCheck() ) m_dwFlags |= PF_AutoVPan;

    pb = (CButton*)GetDlgItem( IDC_PFNOSMOOTH );
    if( pb->GetCheck() ) m_dwFlags |= PF_NoSmooth;

    pb = (CButton*)GetDlgItem( IDC_PFBIGWAVY );
    if( pb->GetCheck() ) m_dwFlags |= PF_BigWavy;

    pb = (CButton*)GetDlgItem( IDC_PFSPECIALPOLYGON );
    if( pb->GetCheck() ) m_dwFlags |= PF_SpecialPoly;

    pb = (CButton*)GetDlgItem( IDC_PFSMALLWAVY );
    if( pb->GetCheck() ) m_dwFlags |= PF_SmallWavy;

    pb = (CButton*)GetDlgItem( IDC_PFFLAT );
    if( pb->GetCheck() ) m_dwFlags |= PF_Flat;

    pb = (CButton*)GetDlgItem( IDC_PFLOWSHADOWDETAIL );
    if( pb->GetCheck() ) m_dwFlags |= PF_LowShadowDetail;

    pb = (CButton*)GetDlgItem( IDC_PFNOMERGE );
    if( pb->GetCheck() ) m_dwFlags |= PF_NoMerge;

    pb = (CButton*)GetDlgItem( IDC_PFCLOUDWAVY );
    if( pb->GetCheck() ) m_dwFlags |= PF_CloudWavy;

    pb = (CButton*)GetDlgItem( IDC_PFDIRTYSHADOWS );
    if( pb->GetCheck() ) m_dwFlags |= PF_DirtyShadows;

    pb = (CButton*)GetDlgItem( IDC_PFBRIGHTCORNERS );
    if( pb->GetCheck() ) m_dwFlags |= PF_BrightCorners;

    pb = (CButton*)GetDlgItem( IDC_PFSPECIALLIT );
    if( pb->GetCheck() ) m_dwFlags |= PF_SpecialLit;

    pb = (CButton*)GetDlgItem( IDC_PFGOURAUD );
    if( pb->GetCheck() ) m_dwFlags |= PF_Gouraud;

    pb = (CButton*)GetDlgItem( IDC_PF_NOBOUNDREJECTION );
    if( pb->GetCheck() ) m_dwFlags |= PF_NoBoundRejection;

    pb = (CButton*)GetDlgItem( IDC_PFUNLIT );
    if( pb->GetCheck() ) m_dwFlags |= PF_Unlit;

    pb = (CButton*)GetDlgItem( IDC_PFHIGHSHADOWDETAIL );
    if( pb->GetCheck() ) m_dwFlags |= PF_HighShadowDetail;

    pb = (CButton*)GetDlgItem( IDC_PFPORTAL );
    if( pb->GetCheck() ) m_dwFlags |= PF_Portal;

    pb = (CButton*)GetDlgItem( IDC_PFMIRRORED );
    if( pb->GetCheck() ) m_dwFlags |= PF_Mirrored;

    pb = (CButton*)GetDlgItem( IDC_PFNOOCCLUDE );
    if( pb->GetCheck() ) m_dwFlags |= PF_NoOcclude;

    pb = (CButton*)GetDlgItem( IDC_PFNOSHADOWS );
    if( pb->GetCheck() ) m_dwFlags |= PF_NoShadows;


    //
    // Record the reset / keep option
    //
    pb = (CButton*)GetDlgItem( IDC_RESETFILES );
    m_bReset = pb->GetCheck() ? true : false;

	CDialog::OnOK();
    }


/**
*   Return the current flags chosen / set by user.
*/
DWORD CAdvancedOptions::GetPolygonFlags() const
    {
    return m_dwFlags;
    }


/**
*   Load flags from file.
*/
bool CAdvancedOptions::LoadPolygonFlags()
    {
    CRegKey reg;
    DWORD flags  = POLYGONDEFAULTFLAGS;
    DWORD custom = CUSTOMDEFAULTVALUE;
    
    m_dwTextureOption = USE256;
    m_dwTextureHeight = 256;
    m_dwTextureWidth  = 256;
    
    long result = 0;

    //
    // Set user flags
    //
    if( ERROR_SUCCESS == reg.Open( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
        {
        result = reg.QueryValue( flags, POLYFLAGSREGVALUE );
        }
    else
        {
        if( ERROR_SUCCESS == reg.Create( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
            {
            result = reg.SetValue( flags, POLYFLAGSREGVALUE ); 
            }
        }

    m_dwFlags = flags;

    //
    // Set which flags to use
    //
    if( ERROR_SUCCESS == reg.Open( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
        {
        result = reg.QueryValue( custom, CUSTOMFLAGS );
        }
    else
        {
        if( ERROR_SUCCESS == reg.Create( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
            {
            result = reg.SetValue( custom, CUSTOMFLAGS ); 
            }
        }

    //
    // Set which texture option to use
    //
    if( ERROR_SUCCESS == reg.Open( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
        {
        result = reg.QueryValue( m_dwTextureOption, TEXTUREFLAGS );
        }
    else
        {
        if( ERROR_SUCCESS == reg.Create( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
            {
            result = reg.SetValue( m_dwTextureOption, CUSTOMFLAGS ); 
            }
        }

    //
    // Get / Set texture width
    //
    if( ERROR_SUCCESS == reg.Open( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
        {
        result = reg.QueryValue( m_dwTextureWidth, TEXTUREWIDTH );
        }
    else
        {
        if( ERROR_SUCCESS == reg.Create( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
            {
            result = reg.SetValue( m_dwTextureWidth, TEXTUREWIDTH ); 
            }
        }

    //
    // Get / Set texture height
    //
    if( ERROR_SUCCESS == reg.Open( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
        {
        result = reg.QueryValue( m_dwTextureHeight, TEXTUREHEIGHT );
        }
    else
        {
        if( ERROR_SUCCESS == reg.Create( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
            {
            result = reg.SetValue( m_dwTextureHeight, TEXTUREHEIGHT ); 
            }
        }

    //
    // Change the checkbox about whether to reset or not depending on the flags
    // in 'custom'.
    //
    m_bReset = custom  & CUSTOMRESET ? true : false;

    //
    // Record the polygon flags and whether to use them or not.
    //
    m_dwFlags = flags;
    m_bUseCustomFlags = (custom & CUSTOMUSER) ? true : false;

    return result == ERROR_SUCCESS;
    }


/** Save flags to file.
*/
void CAdvancedOptions::SavePolygonFlags()
    {
    CRegKey reg;
    long result = 0;
    DWORD custom = m_bUseCustomFlags ? CUSTOMUSER : CUSTOMDERIVE;
    
    if( m_bReset ) custom |= CUSTOMRESET;
    else custom |= CUSTOMKEEP;
    
    //
    // Save user flags
    //
    if( ERROR_SUCCESS == reg.Open( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
        {
        reg.SetValue( m_dwFlags, POLYFLAGSREGVALUE );
        }
    else
        {
        if( ERROR_SUCCESS == reg.Create( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
            {
            result = reg.SetValue( m_dwFlags, POLYFLAGSREGVALUE ); 
            }
        }

    //
    // Set which flags to use
    //
    if( ERROR_SUCCESS == reg.Open( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
        {
        reg.SetValue( custom, CUSTOMFLAGS );
        }
    else
        {
        if( ERROR_SUCCESS == reg.Create( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
            {
            result = reg.SetValue( custom, CUSTOMFLAGS ); 
            }
        }

    //
    // Set which texture option to use
    //
    if( ERROR_SUCCESS == reg.Open( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
        {
        reg.SetValue( m_dwTextureOption, TEXTUREFLAGS );
        }
    else
        {
        if( ERROR_SUCCESS == reg.Create( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
            {
            result = reg.SetValue( m_dwTextureOption, TEXTUREFLAGS ); 
            }
        }


    //
    // Set texture height
    //
    if( ERROR_SUCCESS == reg.Open( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
        {
        reg.SetValue( m_dwTextureHeight, TEXTUREHEIGHT ); 
        }
    else
        {
        if( ERROR_SUCCESS == reg.Create( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
            {
            result = reg.SetValue( m_dwTextureHeight, TEXTUREHEIGHT ); 
            }
        }

    //
    // Set texture width
    //
    if( ERROR_SUCCESS == reg.Open( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
        {
        reg.SetValue( m_dwTextureWidth, TEXTUREWIDTH ); 
        }
    else
        {
        if( ERROR_SUCCESS == reg.Create( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
            {
            result = reg.SetValue( m_dwTextureWidth, TEXTUREWIDTH ); 
            }
        }
    }


/**
*   Loads flags, sets correct checkboxes, then displays dialog window.
*   Saves flags upon closing window.
*/
int CAdvancedOptions::DoModal() 
{
    if( false == LoadPolygonFlags() )
        {
        m_dwFlags = POLYGONDEFAULTFLAGS;
        m_dwTextureHeight = 256;
        m_dwTextureWidth  = 256;
        m_dwTextureOption = USE256;
        }

    int iRet = CDialog::DoModal();
    SavePolygonFlags();
	return iRet;
}


/**
*   Set checkboxes to reflect flags.
*/
void CAdvancedOptions::SetPolygonFlagsCheckboxes()
{
    //
    // Set the Texture Options Box
    //
    CButton *pb = NULL;
    CWnd    *pw = NULL;
    char buf[20] = { '\0' };

    //
    // Set Custom Height / Width boxes text
    //
    CSpinButtonCtrl * cspin = (CSpinButtonCtrl *)GetDlgItem( IDC_WIDTHSPIN );
    cspin->SetRange( 32, 2048 );
    cspin->SetPos( m_dwTextureWidth );

    cspin = (CSpinButtonCtrl *)GetDlgItem( IDC_HEIGHTSPIN );
    cspin->SetRange( 32, 2048 );
    cspin->SetPos( m_dwTextureHeight );

/*    pw = (CWnd*)GetDlgItem( IDC_HEIGHT );
    ::ltoa( m_dwTextureHeight, buf, 10 );
    pw->SetWindowText( buf );

    pw = (CWnd*)GetDlgItem( IDC_WIDTH );
    ::ltoa( m_dwTextureWidth, buf, 10 );
    pw->SetWindowText( buf );*/


    switch( m_dwTextureOption )
        {
        case USE256:
            pb = (CButton*)GetDlgItem( IDC_USE256X256 );
            pb->SetCheck( 1 );

            // Edit box
            pw = (CWnd*)GetDlgItem( IDC_HEIGHT );
            pw->EnableWindow(FALSE);

            // Surrounding box
            pw = (CWnd*)GetDlgItem( IDC_CUSTOMSIZE );
            pw->EnableWindow(FALSE);

            // Edit box
            pw = (CWnd*)GetDlgItem( IDC_WIDTH );
            pw->EnableWindow(FALSE);

            // Width text
            pw = (CWnd*)GetDlgItem( IDC_TXTHEIGHT );
            pw->EnableWindow(FALSE);

            // Height text
            pw = (CWnd*)GetDlgItem( IDC_TXTWIDTH );
            pw->EnableWindow(FALSE);
            break;
        case PROMPT:
            pb = (CButton*)GetDlgItem( IDC_TEXTUREPROMPT );
            pb->SetCheck( 1 );

            // Edit box
            pw = (CWnd*)GetDlgItem( IDC_HEIGHT );
            pw->EnableWindow(FALSE);

            // Surrounding box
            pw = (CWnd*)GetDlgItem( IDC_CUSTOMSIZE );
            pw->EnableWindow(FALSE);

            // Edit box
            pw = (CWnd*)GetDlgItem( IDC_WIDTH );
            pw->EnableWindow(FALSE);

            // Width text
            pw = (CWnd*)GetDlgItem( IDC_TXTHEIGHT );
            pw->EnableWindow(FALSE);

            // Height text
            pw = (CWnd*)GetDlgItem( IDC_TXTWIDTH );
            pw->EnableWindow(FALSE);
            break;
        case USECUSTOM:
            pb = (CButton*)GetDlgItem( IDC_TEXTURECUSTOM );
            pb->SetCheck( 1 );

            // Height box
            pw = (CWnd*)GetDlgItem( IDC_HEIGHT );
            pw->EnableWindow(TRUE);

            // Width box
            pw = (CWnd*)GetDlgItem( IDC_WIDTH );
            pw->EnableWindow(TRUE);

            // Surrounding box
            pw = (CWnd*)GetDlgItem( IDC_CUSTOMSIZE );
            pw->EnableWindow(TRUE);

            // Width text
            pw = (CWnd*)GetDlgItem( IDC_TXTHEIGHT );
            pw->EnableWindow(TRUE);

            // Height text
            pw = (CWnd*)GetDlgItem( IDC_TXTWIDTH );
            pw->EnableWindow(TRUE);
            break;
        default:
            TRACE( "BUG IN SWITCH IN CAdvancedOptions::SetPolygonFlagsCheckboxes()" );
        }
    
    //
    // Set the checkboxees
    //
    pb = (CButton*)GetDlgItem( IDC_PF_INVISIBLE );    
    if( m_dwFlags & PF_Invisible ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PF_TRANSLUCENT );
    if( m_dwFlags & PF_Translucent ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PF_MASKED );
    if( m_dwFlags & PF_Masked ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PF_NOTSOLID );
    if( m_dwFlags & PF_NotSolid ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PF_ENVIRONMENT );
    if( m_dwFlags & PF_Environment ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PF_FORCEVIEWZONE );
    if( m_dwFlags & PF_ForceViewZone ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PF_SEMISOLID );
    if( m_dwFlags & PF_Semisolid ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFMODULATED );
    if( m_dwFlags & PF_Modulated ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFFAKEBACKDROP );
    if( m_dwFlags & PF_FakeBackdrop ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFTWOSIDED );
    if( m_dwFlags & PF_TwoSided ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFAUTOUPAN );
    if( m_dwFlags & PF_AutoUPan ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFAUTOVPAN );
    if( m_dwFlags & PF_AutoVPan ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFNOSMOOTH );
    if( m_dwFlags & PF_NoSmooth ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFBIGWAVY );
    if( m_dwFlags & PF_BigWavy ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFSPECIALPOLYGON );
    if( m_dwFlags & PF_SpecialPoly ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFSMALLWAVY );
    if( m_dwFlags & PF_SmallWavy ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFFLAT );
    if( m_dwFlags & PF_Flat ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFLOWSHADOWDETAIL );
    if( m_dwFlags & PF_LowShadowDetail ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFNOMERGE );
    if( m_dwFlags & PF_NoMerge ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFCLOUDWAVY );
    if( m_dwFlags & PF_CloudWavy ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFDIRTYSHADOWS );
    if( m_dwFlags & PF_DirtyShadows ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFBRIGHTCORNERS );
    if( m_dwFlags & PF_BrightCorners ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFSPECIALLIT );
    if( m_dwFlags & PF_SpecialLit ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFGOURAUD );
    if( m_dwFlags & PF_Gouraud ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PF_NOBOUNDREJECTION );
    if( m_dwFlags & PF_NoBoundRejection ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFUNLIT );
    if( m_dwFlags & PF_Unlit ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFHIGHSHADOWDETAIL );
    if( m_dwFlags & PF_HighShadowDetail ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFPORTAL );
    if( m_dwFlags & PF_Portal ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFMIRRORED );
    if( m_dwFlags & PF_Mirrored ) pb->SetCheck( 1 );
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    //
    // Combination flags are not single bits. They must be treated
    // specially. We need to check that every bit corresponding
    // has been set.
    //
    pb = (CButton*)GetDlgItem( IDC_PFNOOCCLUDE );
    if( PF_NoOcclude == (m_dwFlags & PF_NoOcclude) )
        {
        pb->SetCheck( 1 );
        }
    else pb->SetCheck( 0 );
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);

    pb = (CButton*)GetDlgItem( IDC_PFNOSHADOWS );
    if( PF_NoShadows == (m_dwFlags & PF_NoShadows) ) 
        {
        pb->SetCheck( 1 );
        }
    else 
        {
        pb->SetCheck( 0 );
        }
    if( m_bUseCustomFlags )pb->ModifyStyle( WS_DISABLED, 0, 0);
    else pb->ModifyStyle(0, WS_DISABLED, 0);


    //
    // The radio dialog boxes deciding which types of flags to use
    //
    if( false == m_bUseCustomFlags )
        {
        pb = (CButton*)GetDlgItem( IDC_ASEFLAGS );
        pb->SetCheck( 1 );
        pb = (CButton*)GetDlgItem( IDC_CUSTOMFLAGS );
        pb->SetCheck( 0 );
        }
    else 
        {
        pb = (CButton*)GetDlgItem( IDC_ASEFLAGS );
        pb->SetCheck( 0 );
        pb = (CButton*)GetDlgItem( IDC_CUSTOMFLAGS );
        pb->SetCheck( 1 );
        }

    //
    // The radio dialog boxes for choosing whether to reset or keep
    //
    if( m_bReset )
        {
        pb = (CButton*)GetDlgItem( IDC_RESETFILES );
        pb->SetCheck( 1 );
        pb = (CButton*)GetDlgItem( IDC_REUSEFILE );
        pb->SetCheck( 0 );
        }
    else
        {
        pb = (CButton*)GetDlgItem( IDC_REUSEFILE );
        pb->SetCheck( 1 );
        pb = (CButton*)GetDlgItem( IDC_RESETFILES );
        pb->SetCheck( 0 );
        }

    this->Invalidate();
}


BOOL CAdvancedOptions::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
    SetPolygonFlagsCheckboxes();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

/**
*   If the PF_NoOcclude flag is checked set its combination of flags
*/
void CAdvancedOptions::OnPfnoocclude() 
    {
	CButton *pbutton = (CButton*)GetDlgItem( IDC_PFNOOCCLUDE );

    //
    // Check related buttons
    //
    if( pbutton->GetCheck() ) // Button is checked
        {
        CButton *pb = (CButton*)GetDlgItem( IDC_PF_MASKED );
        pb->SetCheck( 1 );
        pb = (CButton*)GetDlgItem( IDC_PF_TRANSLUCENT );
        pb->SetCheck( 1 );
        pb = (CButton*)GetDlgItem( IDC_PF_INVISIBLE );
        pb->SetCheck( 1 );
        pb = (CButton*)GetDlgItem( IDC_PFMODULATED );
        pb->SetCheck( 1 );
        }
    }


/**
*   If the PF_NoShadows flag is checked set its combination of flags
*/
void CAdvancedOptions::OnPfnoshadows() 
    {
    CButton *pbutton = (CButton*)GetDlgItem( IDC_PFNOSHADOWS );

    //
    // Check related buttons
    //
    if( pbutton->GetCheck() ) // Button is checked
        {
        CButton *pb = (CButton*)GetDlgItem( IDC_PFUNLIT );
        pb->SetCheck( 1 );
        pb = (CButton*)GetDlgItem( IDC_PF_ENVIRONMENT );
        pb->SetCheck( 1 );
        pb = (CButton*)GetDlgItem( IDC_PF_INVISIBLE );
        pb->SetCheck( 1 );
        pb = (CButton*)GetDlgItem( IDC_PFFAKEBACKDROP );
        pb->SetCheck( 1 );
        }	
}

/**
*   If the PFMasked button is unchecked then the PFNoOcclude 
*   combination flag is no longer valid.
*/
void CAdvancedOptions::OnPfMasked() 
    {
    CButton *pbutton = (CButton*)GetDlgItem( IDC_PF_MASKED );

    //
    // Uncheck combination flag buttons
    //
    if( 0 == pbutton->GetCheck() ) // Button is not checked
        {
        CButton *pb = (CButton*)GetDlgItem( IDC_PFNOOCCLUDE );
        pb->SetCheck( 0 );
        }	
    }


/**
*   If the PFTranslucent button is unchecked then the PFNoOcclude 
*   combination flag is no longer valid.
*/
void CAdvancedOptions::OnPfTranslucent() 
    {
    CButton *pbutton = (CButton*)GetDlgItem( IDC_PF_TRANSLUCENT );

    //
    // Uncheck combination flag buttons
    //
    if( 0 == pbutton->GetCheck() ) // Button is not checked
        {
        CButton *pb = (CButton*)GetDlgItem( IDC_PFNOOCCLUDE );
        pb->SetCheck( 0 );
        }	
    }


/**
*   If the PFInvisible button is unchecked then the PFNoOcclude 
*   combination flag is no longer valid.
*/
void CAdvancedOptions::OnPfInvisible() 
    {
    CButton *pbutton = (CButton*)GetDlgItem( IDC_PF_INVISIBLE );

    //
    // Uncheck combination flag buttons
    //
    if( 0 == pbutton->GetCheck() ) // Button is not checked
        {
        CButton *pb = (CButton*)GetDlgItem( IDC_PFNOOCCLUDE );
        pb->SetCheck( 0 );

        pb = (CButton*)GetDlgItem( IDC_PFNOSHADOWS );
        pb->SetCheck( 0 );
        }	
    }


/**
*   If the PFModulated button is unchecked then the PFNoOcclude 
*   combination flag is no longer valid.
*/
void CAdvancedOptions::OnPfmodulated() 
    {
    CButton *pbutton = (CButton*)GetDlgItem( IDC_PFMODULATED );

    //
    // Uncheck combination flag buttons
    //
    if( 0 == pbutton->GetCheck() ) // Button is not checked
        {
        CButton *pb = (CButton*)GetDlgItem( IDC_PFNOOCCLUDE );
        pb->SetCheck( 0 );
        }	
    }


/**
*   If the PFUnlit button is unchecked then the PFNoShadows 
*   combination flag is no longer valid.
*/
void CAdvancedOptions::OnPfunlit() 
    {
    CButton *pbutton = (CButton*)GetDlgItem( IDC_PFUNLIT );

    //
    // Uncheck combination flag buttons
    //
    if( 0 == pbutton->GetCheck() ) // Button is not checked
        {
        CButton *pb = (CButton*)GetDlgItem( IDC_PFNOSHADOWS );
        pb->SetCheck( 0 );
        }	
    }


/**
*   If the PFEnvironment button is unchecked then the PFNoShadows 
*   combination flag is no longer valid.
*/
void CAdvancedOptions::OnPfEnvironment() 
    {
    CButton *pbutton = (CButton*)GetDlgItem( IDC_PF_ENVIRONMENT );

    //
    // Uncheck combination flag buttons
    //
    if( 0 == pbutton->GetCheck() ) // Button is not checked
        {
        CButton *pb = (CButton*)GetDlgItem( IDC_PFNOSHADOWS );
        pb->SetCheck( 0 );
        }	
    }

/**
*   If the PFFakeBackDrop button is unchecked then the PFNoShadows 
*   combination flag is no longer valid.
*/
void CAdvancedOptions::OnPffakebackdrop() 
    {
    CButton *pbutton = (CButton*)GetDlgItem( IDC_PFFAKEBACKDROP );

    //
    // Uncheck combination flag buttons
    //
    if( 0 == pbutton->GetCheck() ) // Button is not checked
        {
        CButton *pb = (CButton*)GetDlgItem( IDC_PFNOSHADOWS );
        pb->SetCheck( 0 );
        }	
    }

/**
*   Returns true if the user has selceted to use his own and not
*   derive from the ASE file.
*/
bool CAdvancedOptions::UseCustomFlags() const
    {
    return m_bUseCustomFlags;
    }


void CAdvancedOptions::OnAseflags() 
    {
    CButton *pb = (CButton*)GetDlgItem( IDC_ASEFLAGS );
    m_bUseCustomFlags = pb->GetCheck() ? false : true;
    SetPolygonFlagsCheckboxes();
    }


void CAdvancedOptions::OnCustomflags() 
    {
    CButton *pb = (CButton*)GetDlgItem( IDC_CUSTOMFLAGS );
    m_bUseCustomFlags = pb->GetCheck() ? true : false;
    SetPolygonFlagsCheckboxes();
    }


/**
*   If the user clicks on 256 x 256 disable the edit boxes.
*/
void CAdvancedOptions::OnUse256x256() 
    {   
    //
    // Disable height & width boxes.
    //
	CWnd *pw = (CWnd*)GetDlgItem( IDC_HEIGHT );
    pw->EnableWindow(FALSE);

    pw = (CWnd*)GetDlgItem( IDC_WIDTH );
    pw->EnableWindow(FALSE);

    // Surrounding box
    pw = (CWnd*)GetDlgItem( IDC_CUSTOMSIZE );
    pw->EnableWindow(FALSE);

    // Width text
    pw = (CWnd*)GetDlgItem( IDC_TXTHEIGHT );
    pw->EnableWindow(FALSE);

    // Height text
    pw = (CWnd*)GetDlgItem( IDC_TXTWIDTH );
    pw->EnableWindow(FALSE);

    m_dwTextureOption = 1;

    this->Invalidate();
    }


/**
*   If the user clicks on 'Texture Prompt' disable the edit boxes.
*/
void CAdvancedOptions::OnTextureprompt() 
    { 
    //
    // Disable height & width boxes.
    //
	CWnd *pw = (CWnd*)GetDlgItem( IDC_HEIGHT );
    pw->EnableWindow(FALSE);

    pw = (CWnd*)GetDlgItem( IDC_WIDTH );
    pw->EnableWindow(FALSE);

    // Surrounding box
    pw = (CWnd*)GetDlgItem( IDC_CUSTOMSIZE );
    pw->EnableWindow(FALSE);

    // Width text
    pw = (CWnd*)GetDlgItem( IDC_TXTHEIGHT );
    pw->EnableWindow(FALSE);

    // Height text
    pw = (CWnd*)GetDlgItem( IDC_TXTWIDTH );
    pw->EnableWindow(FALSE);

    m_dwTextureOption = 2;

    this->Invalidate();	
    }


/**
*   If the user clicks on 'Custom Texture' enable the edit boxes.
*/
void CAdvancedOptions::OnTexturecustom() 
    {   
    //
    // Enable height & width boxes.
    //
	CWnd *pw = (CWnd*)GetDlgItem( IDC_HEIGHT );
    pw->EnableWindow(TRUE);

    pw = (CWnd*)GetDlgItem( IDC_WIDTH );
    pw->EnableWindow(TRUE);

    // Surrounding box
    pw = (CWnd*)GetDlgItem( IDC_CUSTOMSIZE );
    pw->EnableWindow(TRUE);

    // Width text
    pw = (CWnd*)GetDlgItem( IDC_TXTHEIGHT );
    pw->EnableWindow(TRUE);

    // Height text
    pw = (CWnd*)GetDlgItem( IDC_TXTWIDTH );
    pw->EnableWindow(TRUE);

    m_dwTextureOption = 3;

    this->Invalidate();	
    }

/**
*   Returns true if the user should be prompted for each texture
*   size.
*/
bool CAdvancedOptions::PromptForTextures()
    {
    return m_dwTextureOption == PROMPT;
    }


/*
*   Returns the width size of texture to use. This should in theory never be called when 
*   in fact the user should be prompted for the texture sizes.
*/
DWORD CAdvancedOptions::GetTextureWidth()
    {
    switch( m_dwTextureOption )
        {
        case USE256:
            return 256;
        case PROMPT:
            assert( !"Attempting to read texture size in prompt mode." );
            return 256;
        };
    return m_dwTextureWidth;
    }


/*
*   Returns the height size of texture to use. This should in theory never be called when 
*   in fact the user should be prompted for the texture sizes.
*/
DWORD CAdvancedOptions::GetTextureHeight()
    {
    switch( m_dwTextureOption )
        {
        case USE256:
            return 256;
        case PROMPT:
            assert( !"Attempting to read texture size in prompt mode." );
            return 256;
        };
    return m_dwTextureHeight;
    }


/**
*   Remove all registry entries
*/
void CAdvancedOptions::RemoveRegistryEntries()
{
    CRegKey reg;

    //
    // Remove all registry entries
    //
    if( ERROR_SUCCESS == reg.Open( HKEY_LOCAL_MACHINE, SOLO_REGISTRY_KEY ) )
        {
        reg.DeleteValue( POLYFLAGSREGVALUE );
        reg.DeleteSubKey( POLYFLAGSREGVALUE );

        reg.DeleteValue( CUSTOMFLAGS );
        reg.DeleteSubKey( CUSTOMFLAGS );

        reg.DeleteValue( TEXTUREFLAGS );
        reg.DeleteSubKey( TEXTUREFLAGS );

        reg.DeleteValue( TEXTUREHEIGHT );
        reg.DeleteSubKey( TEXTUREHEIGHT );

        reg.DeleteValue( TEXTUREWIDTH );
        reg.DeleteSubKey( TEXTUREWIDTH );
        }
    if( ERROR_SUCCESS == reg.Open( HKEY_LOCAL_MACHINE, SOLO_REG_BASE_KEY ) )
        {
        reg.DeleteSubKey( SOLO_ASET3D_KEY );
        }

}

bool CAdvancedOptions::WantReset()
{
return m_bReset;
}
