#include <afxwin.h>         // MFC core and standard components
#include <afxext.h>         // MFC extensions
#include <afxdtctl.h>
#include <afxcmn.h>	
#include "ase2t3d_winapp.h"
#include "ase2t3d_dlg.h"
#include "t3d.h"
#include "ase2t3d_texturesize.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CASEDialog dialog

CASEDialog::CASEDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CASEDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CASEDialog)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CASEDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CASEDialog)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CASEDialog, CDialog)
	//{{AFX_MSG_MAP(CASEDialog)
    ON_NOTIFY_EX( TTN_NEEDTEXT, 0, OnToolTip )
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
//	ON_BN_CLICKED(IDEXIT, OnExit)
	ON_BN_CLICKED(IDC_FINDFILE, OnFindfile)
	ON_BN_CLICKED(IDC_PLACEFILE, OnPlacefile)
	ON_BN_CLICKED(IDCONVERT, OnConvert)
	ON_BN_CLICKED(IDC_ADVANCED, OnAdvanced)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()



/////////////////////////////////////////////////////////////////////////////
BOOL CASEDialog::OnToolTip( UINT id, NMHDR * pTTTStruct, LRESULT * pResult )
    {
    TOOLTIPTEXT *pTTT = (TOOLTIPTEXT *)pTTTStruct;
    UINT nID =pTTTStruct->idFrom;
    
    //
    // Get ID of control wanting Tip
    //
    nID = ::GetDlgCtrlID((HWND)nID);

    switch( nID )
        {
        case IDC_ASE:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_ASEEDITTIP);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_T3D:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_T3DEDITTIP);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_FINDFILE:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_ASEBUTTONTIP);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_PLACEFILE:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_T3DBUTTONTIP);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDCONVERT:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_CONVERTTIP);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDC_ADVANCED:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_ADVANCEDTIP);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        case IDCANCEL:
            pTTT->lpszText = MAKEINTRESOURCE(IDS_EXITTIP);
            pTTT->hinst = AfxGetResourceHandle();
            break;
        }
    
    return TRUE;
    }



/////////////////////////////////////////////////////////////////////////////
// CASEDialog message handlers

BOOL CASEDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// 
    // Show edit boxes as empty
    //
    CWnd *pwnd = GetDlgItem( IDC_T3D );
    pwnd->SetWindowText( "empty" );
    pwnd = GetDlgItem( IDC_ASE );
    pwnd->SetWindowText( "empty" );

    CButton *pbutton = (CButton*)GetDlgItem( IDC_FINDFILE );
    pbutton->SetFocus();

/*#ifndef _FINISHED
    CTime t = CTime::GetCurrentTime();

    if( t.GetYear() < 2002 )
        {
        ::MessageBox( NULL, "This is an alpha version of this application.\n"
                            "It is intended for evaluation by Daniel Patton.\n"
                            "This application will cease to function after 2001.\n"
                            "Alpha Version 1.08\n",
                            "Evaluation Notice", MB_OK );
        }
    else
        {
        ::MessageBox( NULL, "This was an an alpha version. Please visit www.solosnake.com\n"
                            "to get a free updated copy.",
                            "Evaluation Expired",
                            MB_OK );
        exit(-1);
        }
#endif*/

    //
    // Make sure data is current
    //
    m_OptionsWnd.LoadPolygonFlags();

    m_bPromptForTextures = m_OptionsWnd.PromptForTextures();

    if( false == m_bPromptForTextures )
        {
        m_dwTextureWidth     = m_OptionsWnd.GetTextureWidth();
        m_dwTextureHeight    = m_OptionsWnd.GetTextureHeight();
        }
    else
        {
        m_dwTextureWidth     = 256;
        m_dwTextureHeight    = 256;
        }


    //
    // Enable tool tips
    //
    this->EnableToolTips(true);
	
	return FALSE;  // return TRUE  unless you set the focus to a control
}


void CASEDialog::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}


/**
*   If you add a minimize button to your dialog, you will need the code below
*   to draw the icon.  For MFC applications using the document/view model,
*   this is automatically done for you by the framework.
*/
void CASEDialog::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}


/**
*    The system calls this to obtain the cursor to display while the user drags
*    the minimized window.
*/
HCURSOR CASEDialog::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


/** 
*   User has pressed the find ASE file button.
*/
void CASEDialog::OnFindfile() 
{
    const char BASED_CODE szFilter[] = "3ds ASE Files (*.ase)|*.ase|All Files (*.*)|*.*||";
 
	CFileDialog findfile( true,  // Want an 'open' type
                          "ase", // Default extension.
                          NULL,  // Initial file name
                          OFN_FILEMUSTEXIST,
                          szFilter,
                          NULL );

    //
    // If the user has chosen ASE file
    //
    if( IDOK == findfile.DoModal() )
        {
        //
        // Save file settings
        //
        m_szFiletoOpenTitle = findfile.GetFileTitle();                     
        m_szFiletoOpenExt   = findfile.GetFileExt();
        m_szFiletoOpenPath  = findfile.GetPathName();
        m_szFiletoConvert   = findfile.GetFileName();

        //
        // Display filename in edit box.
        //
        CWnd *pedit = GetDlgItem( IDC_ASE );
        pedit->SetWindowText( m_szFiletoConvert.c_str() );

        //
        // Enable the 'save' edit box and button
        //
        CButton *pbutton = (CButton*)GetDlgItem( IDC_PLACEFILE );
        pbutton->ModifyStyle(WS_DISABLED, 0, 0);
        pbutton->SetFocus();

        this->Invalidate();
        }	
}


/**
*   User has pressed the find / choose neame of T3D file to create.
*/
void CASEDialog::OnPlacefile() 
    {
    const char BASED_CODE szFilter[] = "Unreal T3D Files (*.t3d)|*.t3d|All Files (*.*)|*.*||";
 
	CFileDialog findfile( false,  // Want an 'open' type
                          "t3d", // Default extension.
                          NULL,  // Initial file name
                          OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
                          szFilter,
                          NULL );

    //
    // If the user has chosen T3D file name
    //
    if( IDOK == findfile.DoModal() )
        {
        //
        // Save the settings.
        //
        m_szFiletoSaveTitle = findfile.GetFileTitle();                     
        m_szFiletoSaveExt   = findfile.GetFileExt();
        m_szFiletoSavePath  = findfile.GetPathName();
        m_szFiletoSave      = findfile.GetFileName();

        //
        // Write filename in edit box.
        //
        CWnd *pedit = GetDlgItem( IDC_T3D );
        pedit->SetWindowText( m_szFiletoSave.c_str() );

        //
        // Enable the convert button
        //
        CButton *pbutton = (CButton*)GetDlgItem( IDCONVERT );
        pbutton->ModifyStyle(WS_DISABLED, 0, 0);
        pbutton->SetFocus();

        this->Invalidate();
        }
    }


/**
*   Point of entry into conversion routine.
*/
void CASEDialog::OnConvert() 
    {

    //
    // Change the cursor
    //
    ::SetCursor(LoadCursor(NULL, IDC_WAIT));

	//
    // Read in the ASE file
    //
    ASE::ASEFile ase;

    int ret = ase.read( m_szFiletoOpenPath.c_str() );
    if( ret )
        {
        switch( ret )
            {
            case ASE::NOTEXTUREVERTICES:
                ::MessageBox( NULL, "The ASE file contains at least one object that does not have\n"
                                    "texture vertices. Aborting conversion.",
                                    "Invalid ASE file", MB_OK|MB_ICONEXCLAMATION );
                break;
            case ASE::NOTEXTUREFACES:
                ::MessageBox( NULL, "The ASE file contains at least one object that does not have\n"
                                    "texture faces. Aborting conversion.",
                                    "Invalid ASE file", MB_OK|MB_ICONEXCLAMATION );
                break;
            case ASE::NOMESHNORMALS:
                ::MessageBox( NULL, "The ASE file contains at least one object that does not have\n"
                                    "mesh normals. Aborting conversion.",
                                    "Invalid ASE file", MB_OK|MB_ICONEXCLAMATION );
                break;
            case ASE::INVALIDMESHNORMALS:
                ::MessageBox( NULL, "The ASE file contains at least one object that does not have\n"
                                    "valid mesh normals. Aborting conversion.",
                                    "Invalid ASE file", MB_OK|MB_ICONEXCLAMATION );
                break;
            case ASE::INVALIDMATERIAL:
                ::MessageBox( NULL, "The ASE file contains at least one material that is not in the\n"
                                    "correct format for conversion. Pease ensure all materials have\n"
                                    "texture images associated with them. Aborting conversion.",
                                    "Invalid ASE file", MB_OK|MB_ICONEXCLAMATION    );
                break;
            case ASE::INVALIDASEFILE:
                ::MessageBox( NULL, "The file does not appear to be a valid ASE file.\nAborting conversion.",
                                    "Invalid ASE file", MB_OK|MB_ICONEXCLAMATION    );
                break;
            default:
                ::MessageBox( NULL, "Anonynous error.", "ASE Read Error", MB_OK|MB_ICONEXCLAMATION );
                break;
            };
        Reset();
        ::SetCursor(LoadCursor(NULL, IDC_ARROW));
        return;
        }

    //
    // Get texture dimensions to initialise the array with
    //
    int txwidth  = 256;
    int txheight = 256;
    if( false == m_OptionsWnd.PromptForTextures() )
        {
        txwidth  = m_OptionsWnd.GetTextureWidth();
        txheight = m_OptionsWnd.GetTextureHeight();
        }

    ASE::UVPoint uvp;
    uvp.SetU( txwidth );
    uvp.SetV( txheight );
    ASE::vTexSize vtxsize( ase.GetMaterialCount(), uvp );

    //
    // If the user wants us to prompt for texture sizes, do so for each *unique* bitmap
    // name.
    //
    if( m_OptionsWnd.PromptForTextures() )
        {
        for(int i=0; i< ase.GetMaterialCount(); ++i )
            {
            bool unique = true;
            int oldbitmap = -1;

            if(    ! ( MMAPDIFFUSE & ase.materials[i].GetFlags() ) 
                || ! ( MMAPBITMAP  & ase.materials[i].GetFlags() ) )
                {
                vtxsize[i].SetU( 256 );
                vtxsize[i].SetV( 256 );
                continue;
                }


            //
            // Go through all previous materials and check to see if this material
            // is already covered.
            //
            for(int j=i-1; j>=0; --j)
                {
                if( ase.materials[i].bitmap == ase.materials[j].bitmap  )
                    {
                    unique = false;
                    oldbitmap = j;
                    break;
                    }
                }

            if( unique && (ase.materials[i].bitmap != "NO_BITMAP") )
                {
                //
                // Prompt user for texture size. Set teh window title to the texture name.
                //
                std::string s = StripSuffix( ase.materials.at(i).bitmap );
                s += ".pcx";

                m_TexSizeWnd.SetTitle( s.c_str() );

                m_TexSizeWnd.DoModal();

                this->Invalidate(); // Repaint window.

                vtxsize[i].SetU( m_TexSizeWnd.GetTextureWidth() );
                vtxsize[i].SetV( m_TexSizeWnd.GetTextureHeight() );
                }
            else
                {
                vtxsize[i] = vtxsize[oldbitmap];
                }
            }
        }


    //
    // Perform conversion and write out new T3D file.
    //
    if( 0 == ASE::WriteT3D( ase, 
                            m_szFiletoSavePath.c_str(), 
                            vtxsize,
                            m_OptionsWnd.GetPolygonFlags(), 
                            !m_OptionsWnd.UseCustomFlags() ) )
        {
        //
        // Display summary
        //
        m_ResultsWnd.m_szBrushName      = StripSuffix( ase.scenename ).c_str();
        m_ResultsWnd.m_szFileName       = m_szFiletoSave.c_str();
        m_ResultsWnd.m_dwPolygonCount   = ase.GetVertexCount();
        m_ResultsWnd.m_dwTextureCount   = ase.GetMaterialCount();
        m_ResultsWnd.m_dwWarnings       = ase.GetWarnings();
        m_ResultsWnd.DoModal();
        }
    else
        {
        //
        // An error occurred
        MessageBox("Unable to perform conversion. The ASE file may not contain the required data.",
                    "Conversion Error", MB_OK||MB_ICONEXCLAMATION );
        }
    

    //
    // Only reset the windows if the user wants
    //
    if( m_OptionsWnd.WantReset() )Reset();

    ::SetCursor(LoadCursor(NULL, IDC_ARROW));
    }


/**
*   Resets all the Dialog box.
*/
void CASEDialog::Reset()
    {
    //
    // Reset all the edit box text to nothing.
    //
    CWnd *pwnd = GetDlgItem( IDC_T3D );
    pwnd->SetWindowText( "empty" );
    pwnd = GetDlgItem( IDC_ASE );
    pwnd->SetWindowText( "empty" );

    //
    // Make the save edit box read only
    //
    CEdit* pedit = (CEdit*)GetDlgItem( IDC_T3D );
    pedit->SetReadOnly( true );

    //
    // Disable 'convert' and 'save' buttons.
    //
    CButton *pbutton = (CButton*)GetDlgItem( IDCONVERT );
    pbutton->ModifyStyle(0, WS_DISABLED, 0);

    pbutton = (CButton*)GetDlgItem( IDC_PLACEFILE );
    pbutton->ModifyStyle(0, WS_DISABLED, 0);

    pbutton = (CButton*)GetDlgItem( IDC_FINDFILE );
    pbutton->SetFocus();

    this->Invalidate();
    }


void CASEDialog::OnAdvanced() 
    {
    //
    // Show advanced options window.
    //
    m_OptionsWnd.DoModal();
    }


int CASEDialog::DoModal() 
    {   
	return CDialog::DoModal();
    }


void CASEDialog::OnCancel() 
    {
	CDialog::OnCancel();
    }


/**
*   Removes all registry entries
*/
void CASEDialog::Uninstall()
    {
    m_OptionsWnd.RemoveRegistryEntries();
    }
