// CopnvertT3D_Proto.cpp : Defines the class behaviors for the application.
//

#include <afxwin.h>         // MFC core and standard components
#include <afxext.h>         // MFC extensions
#include <afxdtctl.h>
#include <afxcmn.h>	
#include "ase2t3d_winapp.h"
#include "ase2t3d_dlg.h"
#include "T3D.h"

#pragma warning( disable : 4996 ) // CWinApp::Enable3dControlsStatic' was declared deprecated
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CASEWinApp

BEGIN_MESSAGE_MAP(CASEWinApp, CWinApp)
	//{{AFX_MSG_MAP(CASEWinApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CASEWinApp construction

CASEWinApp::CASEWinApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CASEWinApp object

CASEWinApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CASEWinApp initialization

BOOL CASEWinApp::InitInstance()
{
	//  Standard initialization
	//  If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif


    //
    // Process command line input.
    //
    MyCmdLineInfo cmdlineinfo;
    this->ParseCommandLine( cmdlineinfo );

    if( cmdlineinfo.HasCommandLine() )
        {
        if( cmdlineinfo.HasValidCommandLine() )
            {
            if( cmdlineinfo.Uninstall() )
                {
                CASEDialog dlg;
                dlg.Uninstall();
                MessageBox(NULL,"All registry entries for this application have \n"
                                "been removed. Running this application\n"
                                "again will restore them.", "ASE to T3D Uninstalled", MB_OK);
                return FALSE;
                }
                
            try {
                DWORD flags    = cmdlineinfo.GetPolygonFlags();
                bool  useflags = ! cmdlineinfo.HasPolygonFlags();

                //
                // Read ASE file
                //
                ASE::ASEFile ase;
                if( ase.read( cmdlineinfo.FileToOpen() ) )
                    {
                    throw(int(-1));
                    }

                //
                // Initialise all sizes to 256 x 256.
                //
                ASE::vTexSize vtxsize;
                vtxsize.resize( ase.GetMaterialCount() );

                //
                // Write new T3D file
                //
                if( ASE::WriteT3D( ase, cmdlineinfo.FileToCreate(), vtxsize, flags, useflags ) )
                    {
                    throw(int(-2));
                    }
                }
            catch(...){
                return FALSE;
                }
            }
        else
            {
            return FALSE;
            }
        }
    else
        {
	    CASEDialog dlg;
	    m_pMainWnd = &dlg;
	    dlg.DoModal();
        }

	return FALSE;
}


/**
*   Returns true if the app was passed command line information.
*/
bool MyCmdLineInfo::HasCommandLine()
{
return (0 != m_dwCounter);
}


/**
*   Returns true if the command line is considered valid.
*/
bool MyCmdLineInfo::HasValidCommandLine()
{
return (m_dwCounter < 4);
}



/**
*   Returns the specified polygon flags requested.
*/
DWORD MyCmdLineInfo::GetPolygonFlags()
{
return m_dwFlags;
}


/**
*   Returns true if the app has polygon flags.
*/
bool MyCmdLineInfo::HasPolygonFlags()
{
return (m_dwCounter == 3);
}


/**
*   Returns name of ASE file to convert to a T3D.
*/
const char* MyCmdLineInfo::FileToOpen()
{
return m_szFileToConvert.c_str();
}


/**
*   Returns name of T3D file to create.
*/
const char* MyCmdLineInfo::FileToCreate()
{
if( m_dwCounter == 1 )
    {
    m_szFileToCreate = StripSuffix( m_szFileToConvert );
    m_szFileToCreate += ".t3d";
    }
return m_szFileToCreate.c_str();
}

bool MyCmdLineInfo::Uninstall()
{
return m_bUninstall;
}
