//-----------------------------------------------------------------------------
//!
//! @file       t3d.h
//! @author     Dire Stockdale 
//! @author     <a href=http://www.solosnake.com>www.solosnake.com</a>
//! @date       11-Nov-01 10:39:07
//! @version    1.00
//! @brief      Header file for routines to convert an ASEFile object
//!             to a T3D file output.
//!         
//!
//-----------------------------------------------------------------------------
#ifndef T3D_H
#define T3D_H
#include <afxwin.h>
#include "t3d_polyflags.h"
#include "t3d_words.h"  
#include "ase.h"
#include <fstream>
#include <exception>
#include <float.h>


std::string StripSuffix(const std::string& s);

namespace ASE {

    struct UVPoint {
        public:
            UVPoint():u(256),v(256){};
            inline int GetU(void)const throw(){return u;};
            inline int GetV(void)const throw(){return v;};
            inline void SetU(const int s)throw(){u=s;};
            inline void SetV(const int t)throw(){v=t;};
        private:
            int u,v;
        };

    typedef std::vector< UVPoint > vTexSize;

    int WriteT3D(const ASEFile& ase, 
                 const char* szFileName,
                 const ASE::vTexSize& v,
                 const unsigned int flags, 
                 const bool makeflags);

    }; // End ASE namespace


#endif // T3D_H
//-----------------------------------------------------------------------------
