//done
class HAnKARifle extends FFWeapon;

#exec MESH IMPORT MESH=SteinFruchtAnimated ANIVFILE=MODELS\SteinFruchtAnimated_a.3d DATAFILE=MODELS\SteinFruchtAnimated_d.3d UnMirror=1
#exec MESH ORIGIN MESH=SteinFruchtAnimated X=-100 Y=-100 Z=0 YAW=-3 PITCH=0 ROLL=0

#exec MESH SEQUENCE MESH=SteinFruchtAnimated SEQ=All    STARTFRAME=1   NUMFRAMES=105
#exec MESH SEQUENCE MESH=SteinFruchtAnimated SEQ=Select STARTFRAME=96  NUMFRAMES=8   GROUP=Select
#exec MESH SEQUENCE MESH=SteinFruchtAnimated SEQ=Still  STARTFRAME=104 NUMFRAMES=1
#exec MESH SEQUENCE MESH=SteinFruchtAnimated SEQ=Shoot  STARTFRAME=1   NUMFRAMES=28
#exec MESH SEQUENCE MESH=SteinFruchtAnimated SEQ=Stab   STARTFRAME=106 NUMFRAMES=20
#exec MESH SEQUENCE MESH=SteinFruchtAnimated SEQ=Reload STARTFRAME=41  NUMFRAMES=48
#exec MESH SEQUENCE MESH=SteinFruchtAnimated SEQ=Down   STARTFRAME=90  NUMFRAMES=5

#exec TEXTURE IMPORT NAME=Steinfrucht FILE=Textures/Steinfrucht.pcx GROUP="Skins" LODSET=2
#exec TEXTURE IMPORT NAME=HandGlove FILE=Textures/SimpleGloveHandTexture.pcx GROUP="Skins" LODSET=2

#exec MESHMAP NEW MESHMAP=SteinFruchtAnimated MESH=SteinFruchtAnimated
#exec MESHMAP SCALE MESHMAP=SteinFruchtAnimated X=0.01 Y=0.01 Z=0.02

#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimated NUM=1 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimated NUM=2 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimated NUM=3 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimated NUM=4 TEXTURE=HandGlove
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimated NUM=5 TEXTURE=HandGlove

#exec MESH IMPORT MESH=SteinFruchtAnimatedL ANIVFILE=MODELS\SteinFruchtAnimated_a.3d DATAFILE=MODELS\SteinFruchtAnimated_d.3d
#exec MESH ORIGIN MESH=SteinFruchtAnimatedL X=0 Y=0 Z=0 YAW=128 PITCH=0 ROLL=0

#exec MESH SEQUENCE MESH=SteinFruchtAnimatedL SEQ=All    STARTFRAME=1   NUMFRAMES=105
#exec MESH SEQUENCE MESH=SteinFruchtAnimatedL SEQ=Select STARTFRAME=96  NUMFRAMES=8   GROUP=Select
#exec MESH SEQUENCE MESH=SteinFruchtAnimatedL SEQ=Still  STARTFRAME=104 NUMFRAMES=1
#exec MESH SEQUENCE MESH=SteinFruchtAnimatedL SEQ=Shoot  STARTFRAME=1   NUMFRAMES=28
#exec MESH SEQUENCE MESH=SteinFruchtAnimatedL SEQ=Stab   STARTFRAME=106 NUMFRAMES=20
#exec MESH SEQUENCE MESH=SteinFruchtAnimatedL SEQ=Reload STARTFRAME=41  NUMFRAMES=48
#exec MESH SEQUENCE MESH=SteinFruchtAnimatedL SEQ=Down   STARTFRAME=90  NUMFRAMES=5

#exec MESHMAP NEW MESHMAP=SteinFruchtAnimatedL MESH=SteinFruchtAnimatedL
#exec MESHMAP SCALE MESHMAP=SteinFruchtAnimatedL X=0.01 Y=0.01 Z=0.02

#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimatedL NUM=1 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimatedL NUM=2 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimatedL NUM=3 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimatedL NUM=4 TEXTURE=HandGlove
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtAnimatedL NUM=5 TEXTURE=HandGlove

#exec MESH IMPORT MESH=SteinFruchtPickup ANIVFILE=MODELS\SteinFruchtPickup_a.3d DATAFILE=MODELS\SteinFruchtPickup_d.3d X=0 Y=0 Z=0 LODSTYLE=12 UnMirror=1
#exec MESH ORIGIN MESH=SteinFruchtPickup X=0 Y=0 Z=0 
#exec MESH SEQUENCE MESH=SteinFruchtPickup SEQ=All    STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=SteinFruchtPickup SEQ=Still  STARTFRAME=0  NUMFRAMES=1

#exec MESHMAP SCALE MESHMAP=SteinFruchtPickup X=0.1 Y=0.1 Z=0.2
#exec MESH LODPARAMS MESH=SteinFruchtPickup STRENGTH=0
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtPickup NUM=1 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtPickup NUM=2 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtPickup NUM=3 TEXTURE=Steinfrucht

#exec MESH IMPORT MESH=SteinFruchtHand ANIVFILE=MODELS\SteinFruchtPickup_a.3d DATAFILE=MODELS\SteinFruchtPickup_d.3d X=0 Y=0 Z=0 LODSTYLE=12
#exec MESH ORIGIN MESH=SteinFruchtHand X=0 Y=256 Z=0 YAW=62 ROLL=0
#exec MESH SEQUENCE MESH=SteinFruchtHand SEQ=All    STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=SteinFruchtHand SEQ=Still  STARTFRAME=0  NUMFRAMES=1

#exec MESHMAP SCALE MESHMAP=SteinFruchtHand X=0.05 Y=0.05 Z=0.1
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtHand NUM=1 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtHand NUM=2 TEXTURE=Steinfrucht
#exec MESHMAP SETTEXTURE MESHMAP=SteinFruchtHand NUM=3 TEXTURE=Steinfrucht

//#exec TEXTURE IMPORT NAME=MuzzleFlash2 FILE=TEXTURES\NewMuz2.PCX GROUP="Rifle" MIPS=OFF LODSET=2
//#exec TEXTURE IMPORT NAME=IconRifle FILE=TEXTURES\HUD\WpnRifle.PCX GROUP="Icons" MIPS=OFF
//#exec TEXTURE IMPORT NAME=UseRifle FILE=TEXTURES\HUD\UseRifle.PCX GROUP="Icons" MIPS=OFF
//#exec TEXTURE IMPORT NAME=RReticle FILE=TEXTURES\rifleret.PCX GROUP="Icons" MIPS=OFF FLAGS=2 LODSET=2

#exec AUDIO IMPORT FILE="Sounds\HKStab.wav" NAME="HKStab" GROUP="HKRifle"
#exec AUDIO IMPORT FILE="Sounds\HAKAReload.wav" NAME="HAKAReload" GROUP="HKRifle"
#exec AUDIO IMPORT FILE="Sounds\HAKAFire.wav" NAME="HAKAFire" GROUP="HKRifle"
#exec AUDIO IMPORT FILE="Sounds\HKPickup.wav" NAME="HKPickup" GROUP="HKRifle"

//Icon
#exec TEXTURE IMPORT NAME=HAKAIcon FILE=Textures/HAKAIcon.BMP GROUP="Icons" MIPS=OFF

var vector OwnerLocation;
var float StillTime, StillStart, TimesShot;
var class<Scorch> splat;

function float RateSelf( out int bUseAltMode )
{
	local float dist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	bUseAltMode = 0;
	if ( (Bot(Owner) != None) && Bot(Owner).bSniping )
		return AIRating + 1.15;

	if (  Pawn(Owner).Enemy != None )
	{
		dist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
		if ( dist > 1200 )
		{
			if ( dist > 2000 )
				return (AIRating + 0.75);
			return (AIRating + FMin(0.0001 * dist, 0.45)); 
		}
	}
	return AIRating;
}

function setHand(float Hand)
{
	Super.SetHand(Hand);
	if ( Hand == 1 )
		Mesh = mesh'SteinFruchtAnimatedL';
	else
		Mesh = mesh'SteinFruchtAnimated';
}

simulated function PlayIdleAnim()
{
	if ( Mesh != PickupViewMesh )
		PlayAnim('Still',1.0, 0.05);
}

function Fire(float Value)
{
   if ( AmmoType == None )
      GiveAmmo(Pawn(Owner));

   if ( AmmoType.UseAmmo(1) )
   {
      Gotostate('NormalFire');
      bCanClientFire = true;
      ClientFire(Value);
      TraceFire(0.0);
   }
}

simulated function PlayFiring()
{
	TimesShot = TimesShot - 1;
	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
	PlayAnim('Shoot',0.5 + 0.5 * FireAdjust, 0.05);
	if ( (PlayerPawn(Owner) != None) && (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
		bMuzzleFlash++;
	If (TimesShot <= 0)
	{
		TimesShot = 8;
		PlayReloading();
	}
}

simulated function PlayAltFiring()
{
	if (Owner != None)
	{
		if ( Affector != None )
			Affector.FireEffect();
		PlayOwnedSound(AltFireSound, SLOT_Misc, 1.7*Pawn(Owner).SoundDampening,,,);
		PlayAnim('Stab',1.0, 0.05);
	}
}

function AltFire( float Value )
{
	Gotostate('AltFiring');
	bCanClientFire = true;
	bPointing=True;
	Pawn(Owner).PlayRecoil(FiringSpeed);
	TraceAltFire();
	ClientAltFire(Value);
}

function TraceAltFire()
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local actor Other;
	local Projectile P;
	local float speed;

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation, X, Y, Z);
	StartTrace = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z; 
	AdjustedAim = pawn(owner).AdjustAim(1000000, StartTrace, AimError, False, False);	
	EndTrace = StartTrace + 100 * vector(AdjustedAim);
	Other = Pawn(Owner).TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);
	ProcessAltTraceHit(Other, HitLocation, HitNormal, vector(AdjustedAim), Y, Z);
}

function ProcessAltTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local vector realLoc;
	local float scale;

	if ( (Other == None) || (Other == Owner) || (Other == self) || (Owner == None) )
		return;

	realLoc = Owner.Location + CalcDrawOffset();
	scale = (180 - VSize(realLoc - HitLocation))/180;
	if (Other == Level)
	{
		Spawn(class'HAKAHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	}
	else
	{
		Other.TakeDamage(220 * scale, Pawn(Owner), HitLocation, 30000.0 * X * scale, MyDamageType);
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);
	}
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z;
	local actor Other;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + PawnOwner.Eyeheight * Z; 
	AdjustedAim = PawnOwner.AdjustAim(1000000, StartTrace, 2*AimError, False, False);
	X = vector(AdjustedAim);
	EndTrace = StartTrace + 10000 * X; 
	Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	if ( (Other != self) && (Other != Owner) && (Other != None) )
	{
		if (Other == Level)
   		Spawn(class'PlumWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(100, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(65,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
		{
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);
		}
	}
}

simulated function PlayReloading()
{
	PlayOwnedSound(Sound'HAKAReload', SLOT_None,2.0*Pawn(Owner).SoundDampening);
	PlayAnim('Reload',0.5,0.05);
	Gotostate('Reloading');
}

state NormalFire
{ 
	ignores Fire, AltFire;
	
	function AnimEnd()
    {
      if (Pawn(Owner) != None && Pawn(Owner).bFire != 0)
         TweenAnim('Still', 0.1);
      else
         Super.AnimEnd();
    }

	function EndState()
	{
		Super.EndState();
		OldFlashCount = FlashCount;
	}
		
Begin:
	FlashCount++;
	FinishAnim();
	if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0))
	{
		Gotostate('Idle');
	}
	Finish();
}

state ClientFiring
{
    simulated function AnimEnd()
    {
      if (Pawn(Owner) != None && Pawn(Owner).bFire != 0)
         TweenAnim('Still', 0.1);
      else
         Super.AnimEnd();
    }
}

state AltFiring
{ 
	ignores Fire, AltFire;
	
	function AnimEnd()
   {
      if (Pawn(Owner) != None && Pawn(Owner).bAltFire != 0)
         TweenAnim('Still', 0.1);
      else
         Super.AnimEnd();
   }
}

state ClientAltFiring
{
	simulated function AnimEnd()
   {
   	if (Pawn(Owner) != None && Pawn(Owner).bAltFire != 0)
         TweenAnim('Still', 0.1);
      else
         Super.AnimEnd();
   }
}

state Idle
{
	function bool PutDown()
	{
		GotoState('DownWeapon');
		return True;
	}
	
Begin:
	if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0)) 
	{
		Pawn(Owner).SwitchToBestWeapon();
	}
	if ( Pawn(Owner).bFire!=0 ) Global.Fire(0.0);
	if ( Pawn(Owner).bAltFire!=0 ) Global.AltFire(0.0);
}

simulated function PostRender(canvas C)
{
	local PlayerPawn P;
   local float Scale;
   local font CanvasFont;

   Super.PostRender(C);
   P = PlayerPawn(Owner);
   if ( (P != None) )
   {
		Scale = C.ClipX/640;
      C.SetPos(C.ClipX - 32 * Scale, C.ClipY - 192 * Scale);
      C.Style = ERenderStyle.STY_Translucent;
		C.DrawIcon(Texture'FFAmmoClip', Scale/2);
      C.Font = C.LargeFont;
		C.SetPos(C.ClipX - 22 * Scale, C.ClipY - 180 * Scale);
		C.DrawText(int(TimesShot), false);
	}
}

defaultproperties
{
   WeaponDescription="Classification: Long Range Ballistic\n\nRegular Fire: Fires a high powered plum. Can kill instantly when applied to the cranium of opposing forces. \n\nSecondary Fire: Meeles the fork in to someone. Causes huge damage!!"
   AmmoName=Class'FoodFightWeapons.PlumCan'
   PickupAmmoCount=10
   bInstantHit=True
   bAltInstantHit=True
   FiringSpeed=1.800000
   FireOffset=(Y=-5.000000,Z=-2.000000)
   MyDamageType=shot
   AltDamageType=Decapitated
   shakemag=400.000000
   shaketime=0.150000
   shakevert=8.000000
   AIRating=0.540000
   RefireRate=0.600000
   AltRefireRate=1.000000
   FireSound=Sound'HAKAFire'
   AltFireSound=Sound'HKStab'
   SelectSound=Sound'UnrealI.Rifle.RiflePickup'
   DeathMessage="%o shouldn't have messed with the HA&KA ranger %k...."
   NameColor=(R=0,G=0)
   bDrawMuzzleFlash=True
   MuzzleScale=1.000000
   FlashY=0.110000
   FlashO=0.014000
   FlashC=0.031000
   FlashLength=0.013000
   FlashS=256
   MFTexture=Texture'Botpack.Rifle.MuzzleFlash2'
   AutoSwitchPriority=5
   InventoryGroup=9
   PickupMessage="You got a HA&KA Steinfrucht."
   ItemName="HA&KA Steinfrucht"
   PlayerViewOffset=(X=5.000000,Y=-1.600000,Z=-1.700000)
   PlayerViewMesh=SteinFruchtAnimated
   PlayerViewScale=2.000000
   BobDamping=0.975000
   PickupViewMesh=SteinFruchtPickup
   ThirdPersonMesh=SteinFruchtHand
   StatusIcon=Texture'HAKAIcon'
   bMuzzleFlashParticles=True
   MuzzleFlashStyle=STY_Translucent
   MuzzleFlashMesh=LodMesh'Botpack.muzzsr3'
   MuzzleFlashScale=0.100000
   MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy3'
   PickupSound=Sound'HKPickup'
   Icon=Texture'Botpack.Icons.UseRifle'
   Mesh=LodMesh'FoodFightWeapons.SteinFruchtPickup'
   bNoSmooth=False
   CollisionRadius=32.000000
   CollisionHeight=8.000000
   TimesShot=8
   splat=class'PlumSplat'
}
