
class Toastanator extends FFWeapon;

#exec MESH IMPORT MESH=ToastenatorFix ANIVFILE=MODELS\ToastenatorFix_a.3D DATAFILE=MODELS\ToastenatorFix_d.3D X=0 Y=0 Z=0 UnMirror=1
#exec MESH ORIGIN MESH=ToastenatorFix X=-25 Y=-180 Z=-25 YAW=-11 ROLL=0 PITCH=0

#exec MESH SEQUENCE MESH=ToastenatorFix SEQ=All        STARTFRAME=0 NUMFRAMES=268

#exec MESH SEQUENCE MESH=ToastenatorFix SEQ=Still      STARTFRAME=0     NUMFRAMES=1
#exec MESH SEQUENCE MESH=ToastenatorFix SEQ=FireB      STARTFRAME=1     NUMFRAMES=17
#exec MESH SEQUENCE MESH=ToastenatorFix SEQ=Fire       STARTFRAME=18    NUMFRAMES=18

#exec MESH SEQUENCE MESH=ToastenatorFix SEQ=FullReload STARTFRAME=36    NUMFRAMES=212
#exec MESH SEQUENCE MESH=ToastenatorFix SEQ=ReloadA    STARTFRAME=36    NUMFRAMES=11
#exec MESH SEQUENCE MESH=ToastenatorFix SEQ=ToastA     STARTFRAME=47    NUMFRAMES=41
#exec MESH SEQUENCE MESH=ToastenatorFix SEQ=ToastB     STARTFRAME=88    NUMFRAMES=41
#exec MESH SEQUENCE MESH=ToastenatorFix SEQ=ToastC     STARTFRAME=129   NUMFRAMES=41
#exec MESH SEQUENCE MESH=ToastenatorFix SEQ=ToastD     STARTFRAME=170   NUMFRAMES=41
#exec MESH SEQUENCE MESH=ToastenatorFix SEQ=PullLever  STARTFRAME=211   NUMFRAMES=38
#exec MESH SEQUENCE MESH=ToastenatorFix SEQ=DeSelect   STARTFRAME=249   NUMFRAMES=6
#exec MESH SEQUENCE MESH=ToastenatorFix SEQ=Down       STARTFRAME=249   NUMFRAMES=6
#exec MESH SEQUENCE MESH=ToastenatorFix SEQ=Select     STARTFRAME=255   NUMFRAMES=12


#exec TEXTURE IMPORT NAME=ToastenatorUVmap FILE=Textures/ToastenatorUVmap.pcx GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=SimpleGloveHandTexture FILE=Textures/SimpleGloveHandTexture.pcx GROUP=Skins LODSET=2

//#exec MESHMAP SCALE    MESHMAP=ToastenatorFix  X=0.008 Y=0.008 Z=0.016
#exec MESHMAP SCALE      MESHMAP=ToastenatorFix  X=0.006 Y=0.006 Z=0.012
#exec MESHMAP SETTEXTURE MESHMAP=ToastenatorFix  NUM=0 TEXTURE=ToastenatorUVmap
#exec MESHMAP SETTEXTURE MESHMAP=ToastenatorFix  NUM=1 TEXTURE=SimpleGloveHandTexture
#exec MESHMAP SETTEXTURE MESHMAP=ToastenatorFix  NUM=2 TEXTURE=SimpleGloveHandTexture
#exec MESHMAP SETTEXTURE MESHMAP=ToastenatorFix  NUM=3 TEXTURE=ToastenatorUVmap
#exec MESHMAP SETTEXTURE MESHMAP=ToastenatorFix  NUM=4 TEXTURE=ToastProjUVmap

#exec MESH IMPORT MESH=ToastenatorPickup ANIVFILE=MODELS\ToastenatorPickup_a.3D DATAFILE=MODELS\ToastenatorPickup_d.3D X=0 Y=0 Z=0 LODSTYLE=12 UnMirror=1
#exec MESH ORIGIN MESH=ToastenatorPickup X=20 Y=0 Z=30 YAW=0
#exec MESH LODPARAMS MESH=ToastenatorPickup  STRENGTH=0
#exec MESH SEQUENCE MESH=ToastenatorPickup SEQ=All   STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=ToastenatorPickup SEQ=Still STARTFRAME=0  NUMFRAMES=1
#exec MESHMAP SCALE MESHMAP=ToastenatorPickup X=0.15 Y=0.15 Z=0.3
#exec MESHMAP SETTEXTURE MESHMAP=ToastenatorPickup NUM=1 TEXTURE=ToastenatorUVmap

//Third Person
#exec MESH IMPORT MESH=ToastenatorHand ANIVFILE=MODELS\ToastenatorPickup_a.3D DATAFILE=MODELS\ToastenatorPickup_d.3D X=0 Y=0 Z=0 LODSTYLE=12 UnMirror=1
#exec MESH ORIGIN MESH=ToastenatorHand X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESH SEQUENCE MESH=ToastenatorHand SEQ=All   STARTFRAME=0  NUMFRAMES=1
#exec MESH SEQUENCE MESH=ToastenatorHand SEQ=Still STARTFRAME=0  NUMFRAMES=1
//#exec MESHMAP SCALE MESHMAP=ToastenatorHand X=0.075 Y=0.075 Z=0.15
#exec MESHMAP SCALE MESHMAP=ToastenatorHand X=0.1125 Y=0.1125 Z=0.225
#exec MESHMAP SETTEXTURE MESHMAP=ToastenatorHand NUM=1 TEXTURE=ToastenatorUVmap

#exec AUDIO IMPORT FILE="Sounds\ToasterFire.WAV" NAME=Springy GROUP=Toastanator
#exec AUDIO IMPORT FILE="Sounds\ToasterReload.WAV" NAME=ToasterReload GROUP=Toastanator

var float totalTime;
var float TimesShot, WhichRocket;

function float RateSelf( out int bUseAltMode )
{
	local float EnemyDist;
	local bool bRetreating;
	local vector EnemyDir;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;
	bUseAltMode = 0;
	if ( Pawn(Owner).Enemy == None )
		return AIRating;

	EnemyDir = Pawn(Owner).Enemy.Location - Owner.Location;
	EnemyDist = VSize(EnemyDir);
	if ( EnemyDist > 1400 )
		return 0;

	bRetreating = ( ((EnemyDir/EnemyDist) Dot Owner.Velocity) < -0.6 );
	if ( (EnemyDist > 600) && (EnemyDir.Z > -0.4 * EnemyDist) )
	{
		if ( !bRetreating )
			return 0;

		return AIRating;
	}

	bUseAltMode = int( FRand() < 0.3 );

	if ( bRetreating || (EnemyDir.Z < -0.7 * EnemyDist) )
		return (AIRating + 0.18);
	return AIRating;
}

function float SuggestAttackStyle()
{
	return -0.3;
}

function float SuggestDefenseStyle()
{
	return -0.4;
}

function Fire(float Value) 
{
	local Pawn P;

	if ( AmmoType == None )
	{
		GiveAmmo(Pawn(Owner));
	}
	if ( AmmoType.UseAmmo(1) )
	{
		bCanClientFire = true;
      bPointing=True;
      P = Pawn(Owner);
      P.PlayRecoil(FiringSpeed);
		ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
		ClientFire(Value);
		Gotostate('NormalFire');
	}
}

function AltFire( float Value )
{
	local Pawn P;
	local int i;

	if ( AmmoType == None )
	{
		GiveAmmo(Pawn(Owner));
	}
	for (i=0; i<5; i++)
	{
 		if ( AmmoType.UseAmmo(1) )
		{
      	bPointing=True;
      	P = Pawn(Owner);
      	P.PlayRecoil(FiringSpeed);
			FireRockets(AltProjectileClass, ProjectileSpeed, bWarnTarget);
			ClientAltFire(Value);
			Gotostate('AltFiring');
		}
	}
}

function Projectile FireRockets( class<projectile> ProjClass, float ProjSpeed, bool bWarn )
{
	local Vector StartLoc, FireLocation, X,Y,Z;
	local rotator FireRot;
	local float Angle, RocketRad;
	local int RocketsLoaded;

	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartLoc = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z;
	AdjustedAim = pawn(owner).AdjustAim(ProjSpeed, StartLoc, AimError, True, bWarn);	

	RocketsLoaded = 4;
	//WhichRocket = 4;
   While ( RocketsLoaded > 0)
   {
		RocketRad = 1;
		Angle = 0;
		FireRot = AdjustedAim;
		FireLocation = StartLoc - (Sin(Angle)*RocketRad - 7.5)*Y + (Cos(Angle)*RocketRad - 7)*Z - X * 4 * FRand();
		FireRot.Pitch = AdjustedAim.Pitch - Angle * 600;
		// Top One
		if (WhichRocket <= 3)
			Spawn(ProjClass,,, FireLocation , FireRot);
		RocketsLoaded--;

		Angle += 1.1;
		FireLocation = StartLoc - (Sin(Angle)*RocketRad - 7.5)*Y + (Cos(Angle)*RocketRad - 7)*Z - X * 4 * FRand();
		FireRot.Pitch = AdjustedAim.Pitch + 2 * (Angle * 600);
		// Bottom One
		if (WhichRocket <= 2)
		Spawn(ProjClass,,, FireLocation , FireRot);
		RocketsLoaded--;

		FireRot.Yaw = AdjustedAim.Yaw - Angle * 600;
		FireLocation = StartLoc - (Sin(Angle)*RocketRad - 7.5)*Y + (Cos(Angle)*RocketRad - 7)*Z - X * 4 * FRand();
		FireRot.Pitch = AdjustedAim.Pitch + Angle * 600;
		//Left One
		if (WhichRocket <= 1)
      Spawn(ProjClass,,, FireLocation , FireRot);
		RocketsLoaded--;

		Angle = -Angle;
		FireLocation = StartLoc - (Sin(Angle)*RocketRad - 7.5)*Y + (Cos(Angle)*RocketRad - 7)*Z - X * 4 * FRand();
		FireRot.Yaw = AdjustedAim.Yaw - Angle * 600;
		//Right One
		Spawn(ProjClass,,, FireLocation , FireRot);
		RocketsLoaded--;
  		Angle = -Angle;
	}
}

simulated function PlayFiring()
{
   TimesShot = TimesShot - 1;
   PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
   PlayAnim( 'FireB', 2.5, 0.05);
}

simulated function PlayAltFiring()
{
	TimesShot = TimesShot - 1;
	WhichRocket = WhichRocket - 1;
   PlayOwnedSound(AltFireSound, SLOT_None, Pawn(Owner).SoundDampening*3.0);
   PlayAnim( 'FireB', 2.5, 0.05);
}

state NormalFire
{
	ignores Fire;

   function AnimEnd()
   {
      if (AnimSequence == 'FireB' && TimesShot <= 0)
      {
         TimesShot = 4;
         PlayReloading();
      }
      else if (Pawn(Owner) != None && Pawn(Owner).bFire != 0)
         TweenAnim('Still', 0.1);
      else
         Super.AnimEnd();
   }

Begin:
	FinishAnim();
	ProjectileFire(ProjectileClass, AltProjectileSpeed, bAltWarnTarget);

	if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0))
	{
		Gotostate('Idle');
	}
	Finish();
}

state ClientFiring
{
   simulated function AnimEnd()
   {
      if (AnimSequence == 'FireB' && TimesShot <= 0)
      {
         TimesShot = 4;
         PlayReloading();
      }
      else if (Pawn(Owner) != None && Pawn(Owner).bFire != 0)
         TweenAnim('Still', 0.1);
      else
         Super.AnimEnd();
   }
}

state ClientAltFiring
{
   simulated function AnimEnd()
   {
      if (AnimSequence == 'FireB' && TimesShot <= 0)
      {
         TimesShot = 4;
         PlayReloading();
      }
      else if (Pawn(Owner) != None && Pawn(Owner).bFire != 0)
         TweenAnim('Still', 0.1);
      else
         Super.AnimEnd();
   }
}

state AltFiring
{
	ignores AltFire;

   function AnimEnd()
   {
      if (AnimSequence == 'FireB' && TimesShot <= 0)
      {
         TimesShot = 4;
         PlayReloading();
      }
      else if (Pawn(Owner) != None && Pawn(Owner).bFire != 0)
         TweenAnim('Still', 0.1);
      else
         Super.AnimEnd();
   }

Begin:
   FinishAnim();

   if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0))
   {
      Gotostate('Idle');
   }
   Finish();
}

simulated function PlayReloading()
{
   PlayOwnedSound(Sound'ToasterReload', SLOT_None, Pawn(Owner).SoundDampening*3.0);
   PlayAnim('FullReload',2.0,0.05);
}

defaultproperties
{
   WeaponDescription="Classification: Used to make toasts at home\n\nPrimary Fire: Loads up a single toast and fires it when real hot.\n\nSecondary Fire: Can launch four hot and sweet looking toasts to take out the whole team at once.."
   AmmoName=Class'FoodFightWeapons.BreadPack'
   PickupAmmoCount=8
   bAltWarnTarget=True
   bRapidFire=False
   FiringSpeed=1.000000
   FireOffset=(X=12.000000,Y=-11.000000,Z=-6.000000)
   ProjectileClass=Class'FoodFightWeapons.BreadSlice'
   AltProjectileClass=Class'FoodFightWeapons.BreadSlice'
   AIRating=0.600000
   RefireRate=1.00000
   AltRefireRate=1.00000
   FireSound=Sound'Springy'
   AltFireSound=Sound'Springy'
   CockingSound=Sound'UnrealI.BioRifle.GelLoad'
   SelectSound=Sound'UnrealI.BioRifle.GelSelect'
   DeathMessage="%o was toasted.. %k makes really tasty stuff at home."
   AutoSwitchPriority=3
   InventoryGroup=4
   PickupMessage="You got the Toastanator."
   ItemName="Toastanator"
   PlayerViewOffset=(X=1.700000,Y=-0.850000,Z=-0.950000)
   PlayerViewMesh=ToastenatorFix
   BobDamping=0.972000
   PickupViewMesh=ToastenatorPickup
   ThirdPersonMesh=ToastenatorHand
   StatusIcon=Texture'Botpack.Icons.UseBio'
   PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
   Icon=Texture'Botpack.Icons.UseBio'
   Mesh=ToastenatorPickup
   bNoSmooth=False
   CollisionHeight=19.000000
   TimesShot=4
   WhichRocket=4
}
