
class AlienQueenV4 extends ScriptedPawn;

#exec MESH IMPORT MESH=ACQueen ANIVFILE=MODELS\aqueen_a.3D DATAFILE=MODELS\aqueen_d.3d X=0 Y=0 Z=0 LODSTYLE=12
#exec MESH ORIGIN MESH=ACQueen X=0 Y=0 Z=-25 YAW=64 ROLL=-255

#exec MESH SEQUENCE MESH=ACQueen SEQ=All			STARTFRAME=1		NUMFRAMES=227
#exec MESH SEQUENCE MESH=ACQueen SEQ=ThreeHit	STARTFRAME=66 		NUMFRAMES=10	RATE=15  Group=Attack
#exec MESH SEQUENCE MESH=ACQueen SEQ=Claw			STARTFRAME=66 		NUMFRAMES=10 	RATE=17  Group=Attack
#exec MESH SEQUENCE MESH=ACQueen SEQ=Gouge		STARTFRAME=76 		NUMFRAMES=10 	RATE=17  Group=Attack
#exec MESH SEQUENCE MESH=ACQueen SEQ=Jump			STARTFRAME=96  	NUMFRAMES=1
#exec MESH SEQUENCE MESH=ACQueen SEQ=Land			STARTFRAME=97  	NUMFRAMES=1
#exec MESH SEQUENCE MESH=ACQueen SEQ=Meditate	STARTFRAME=36 		NUMFRAMES=20 	RATE=12
#exec MESH SEQUENCE MESH=ACQueen SEQ=OutCold		STARTFRAME=192 	NUMFRAMES=20 	RATE=15
#exec MESH SEQUENCE MESH=ACQueen SEQ=TakeHit		STARTFRAME=30  	NUMFRAMES=1
#exec MESH SEQUENCE MESH=ACQueen SEQ=Run			STARTFRAME=1 		NUMFRAMES=10 	RATE=17
#exec MESH SEQUENCE MESH=ACQueen SEQ=Scream		STARTFRAME=152 	NUMFRAMES=10 	RATE=10
#exec MESH SEQUENCE MESH=ACQueen SEQ=Fighter		STARTFRAME=1  		NUMFRAMES=1
#exec MESH SEQUENCE MESH=ACQueen SEQ=Shoot1		STARTFRAME=20 		NUMFRAMES=10 	RATE=15  Group=Attack
#exec MESH SEQUENCE MESH=ACQueen SEQ=Stab			STARTFRAME=122   	NUMFRAMES=10 	RATE=8  	Group=Attack
#exec MESH SEQUENCE MESH=ACQueen SEQ=Walk			STARTFRAME=1 		NUMFRAMES=10 	RATE=10
#exec MESH SEQUENCE MESH=ACQueen SEQ=Shield		STARTFRAME=132 	NUMFRAMES=10 	RATE=8


#exec TEXTURE IMPORT NAME=aque1 FILE=Textures\aque1.bmp GROUP=Skins
#exec TEXTURE IMPORT NAME=aque2 FILE=Textures\aque2.bmp GROUP=Skins
#exec TEXTURE IMPORT NAME=aque3 FILE=Textures\aque3.bmp GROUP=Skins

#exec MESHMAP SCALE MESHMAP=ACQueen X=0.4 Y=0.4 Z=0.6
#exec MESHMAP SETTEXTURE MESHMAP=ACQueen NUM=0 TEXTURE=aque1
#exec MESHMAP SETTEXTURE MESHMAP=ACQueen NUM=1 TEXTURE=aque1
#exec MESHMAP SETTEXTURE MESHMAP=ACQueen NUM=2 TEXTURE=aque2
#exec MESHMAP SETTEXTURE MESHMAP=ACQueen NUM=3 TEXTURE=aque2
#exec MESHMAP SETTEXTURE MESHMAP=ACQueen NUM=4 TEXTURE=aque3
#exec MESHMAP SETTEXTURE MESHMAP=ACQueen NUM=5 TEXTURE=aque3

#exec MESH NOTIFY MESH=ACQueen SEQ=Shoot1 	TIME=0.167 	FUNCTION=SpawnShot
#exec MESH NOTIFY MESH=ACQueen SEQ=Shoot1 	TIME=0.255 	FUNCTION=SpawnShot
#exec MESH NOTIFY MESH=ACQueen SEQ=Shoot1 	TIME=0.344 	FUNCTION=SpawnShot
#exec MESH NOTIFY MESH=ACQueen SEQ=Shoot1 	TIME=0.433 	FUNCTION=SpawnShot
#exec MESH NOTIFY MESH=ACQueen SEQ=OutCold 	TIME=0.60 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=ACQueen SEQ=Claw   	TIME=0.5   	FUNCTION=ClawDamageTarget
#exec MESH NOTIFY MESH=ACQueen SEQ=Gouge  	TIME=0.4   	FUNCTION=ClawDamageTarget
#exec MESH NOTIFY MESH=ACQueen SEQ=Stab   	TIME=0.33  	FUNCTION=StabDamageTarget
#exec MESH NOTIFY MESH=ACQueen SEQ=Walk   	TIME=0.26  	FUNCTION=FootStep
#exec MESH NOTIFY MESH=ACQueen SEQ=Walk   	TIME=0.76  	FUNCTION=FootStep
#exec MESH NOTIFY MESH=ACQueen SEQ=Run    	TIME=0.25  	FUNCTION=FootStep
#exec MESH NOTIFY MESH=ACQueen SEQ=Run    	TIME=0.75  	FUNCTION=FootStep
#exec MESH NOTIFY MESH=ACQueen SEQ=Shield 	TIME=0.75  	FUNCTION=SpawnShield

#exec AUDIO IMPORT FILE="Sounds\claw1Q.WAV" 		NAME="claw1Q" 		GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\shoot1Q.WAV" 	NAME="shoot1Q" 	GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\yell1Q.WAV" 		NAME="yell1Q" 		GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\yell2Q.WAV" 		NAME="yell2Q" 		GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\yell3Q.WAV" 		NAME="yell3Q" 		GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\stab1Q.WAV" 		NAME="stab1Q" 		GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\outcoldQ.WAV" 	NAME="outcoldQ" 	GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\nearby2Q.WAV" 	NAME="nearby2Q" 	GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\amb1Q.WAV" 		NAME="amb1Q" 		GROUP="Queen"
#exec AUDIO IMPORT FILE="Sounds\step1t.WAV" 		NAME="step1t" 		GROUP="Titan"
#exec AUDIO IMPORT FILE="Sounds\teleport1.WAV" 	NAME="Teleport1" 	GROUP="Generic"

//Queen variables;
var() int ClawDamage, StabDamage;
var() name ScreamEvent;

var byte row;
var(Sounds) sound footstepSound;
var(Sounds) sound ScreamSound;
var(Sounds) sound stab;
var(Sounds) sound shoot;
var(Sounds) sound claw;

var bool	bJustScreamed;
var bool	bEndFootStep;
var QueenShield Shield;
var vector TelepDest;

//adds
var float AimErr;

function PostBeginPlay()
{
	Super.PostBeginPlay();
	ProjectileSpeed = 1200 + 100 * Skill;
	GroundSpeed = GroundSpeed * (1 + 0.1 * Skill);
}

event bool EncroachingOn( actor Other )
{
	if ( (Other.Brush != None) || (Brush(Other) != None) )
		return true;
		
	return false;
}

function TryToDuck(vector duckDir, bool bReversed)
{
	if ( (Shield != None) || (AnimSequence == 'Shield') )
		return;

	PlayAnim('Shield', 1.0, 0.1);
	bCrouching = true;
	GotoState('RangedAttack', 'Challenge');
}

function SpawnShield()
{
	Shield = Spawn(class'QueenShield',,,Location + 150 * Vector(Rotation)); 
	Shield.SetBase(self);
}

function eAttitude AttitudeToCreature(Pawn Other)
{
	if ( Other.IsA('Skaarj') )
	{
		if ( Other.IsA('SkaarjBerserker') )
			return ATTITUDE_Hate;
		else
			return ATTITUDE_Friendly;
	}
	else if ( Other.IsA('Pupae') )
		return ATTITUDE_Friendly;
	else if ( Other.IsA('Nali') )
		return ATTITUDE_Hate;
	else
		return ATTITUDE_Ignore;
}

function ThrowOther(Pawn Other)
{
	local float dist, shake;
	local PlayerPawn aPlayer;
	local vector Momentum;

	if ( Other.mass > 500 )
		return;

	aPlayer = PlayerPawn(Other);				
	if (aPlayer == None)
	{	
		if (Other.Physics != PHYS_Walking)
			return;
		dist = VSize(Location - Other.Location);
		if (dist > 500)
			return;
	}
	else
	{
		dist = VSize(Location - Other.Location);
		shake = FMax(500, 1500 - dist);
		if ( dist > 1500 )
			return;
		aPlayer.ShakeView( FMax(0, 0.35 - dist/20000), shake, 0.015 * shake);
		if ( (Other.Physics != PHYS_Walking) || (dist > 1500) )
			return;
	}
	
	Momentum = -0.5 * Other.Velocity + 100 * Normal(Other.Location - Location);
	Momentum.Z =  7000000.0/((0.5 * dist + 500) * Other.Mass);
	Other.AddVelocity(Momentum);
}

function FootStep()
{
	bEndFootstep = false;
	PlaySound(FootstepSound, SLOT_Interact, 8);
}

function Scream()
{
	local actor A;
	local pawn Thrown;

	if (ScreamEvent != '')
		foreach AllActors( class 'Actor', A, ScreamEvent )
			A.Trigger( Self, Instigator );

	PlaySound(ScreamSound, SLOT_Talk, 2 * TransientSoundVolume);
	PlaySound(ScreamSound, SLOT_None, 2 * TransientSoundVolume);
	PlaySound(ScreamSound, SLOT_None, 2 * TransientSoundVolume);
	PlaySound(ScreamSound, SLOT_None, 2 * TransientSoundVolume);
	PlayAnim('Scream');
	bJustScreamed = true;
}

function PlayWaiting()
{
	local float decision;
	local float animspeed;
	
	if (bEndFootStep)
		FootStep();
	decision = FRand();
	animspeed = 0.2 + 0.5 * FRand();
	LoopAnim('Meditate', animspeed);
}

function PlayChallenge()
{
	if (bEndFootStep)
		FootStep();
	if ( IsAnimating() && (AnimSequence == 'Shield') )
		return;
	Scream();
}

function TweenToFighter(float tweentime)
{
	bEndFootStep = ( ((AnimSequence == 'Walk') || (AnimSequence == 'Run')) && (AnimFrame > 0.1) );   
	TweenAnim('Fighter', tweentime);
}

function TweenToRunning(float tweentime)
{
	if ( (AnimSequence != 'Run') || !bAnimLoop )
		TweenAnim('Run', tweentime);
}

function TweenToWalking(float tweentime)
{
	TweenAnim('Walk', tweentime);
}

function TweenToWaiting(float tweentime)
{
	TweenAnim('Meditate', tweentime);
}

function TweenToPatrolStop(float tweentime)
{
	TweenAnim('Meditate', tweentime);
}

function PlayRunning()
{
	LoopAnim('Run', -1.0/GroundSpeed,, 0.8);
}

function PlayWalking()
{
	LoopAnim('Walk', -1.0/GroundSpeed,, 0.8);
}

function PlayThreatening()
{
	DesiredSpeed = 0.0;

	if ( FRand() < 0.75)
		PlayAnim('Meditate', 0.4 + 0.6 * FRand(), 0.3);
	else 
	{
		TweenAnim('Fighter', 0.3);
		PlayThreateningSound();
	}
}

function PlayTurning()
{
	if (bEndFootStep)
		FootStep();
	DesiredSpeed = 0.0;
	TweenAnim('Run', 0.4);
}

function PlayDying(name DamageType, vector HitLocation)
{
	local int i;
	local vector v;
	local BloodDrop b;

	PlayAnim('OutCold', 0.7, 0.1);
	PlaySound(Die, SLOT_Talk);
	
	Spawn(class'UT_BigBloodHit',,, Location);
  	for (i=0; i<(3); i++)
	{
		v = Location;
		v.X += 10 * FRand();
		Spawn(class'UT_BloodHit',,, v);
		v.X -= 15 * FRand();
		Spawn(class'UT_BloodHit',,, v);
		v.Y += 10 * FRand();
		Spawn(class'UT_BloodHit',,, v);
		v.Y -= 15 * FRand();
		Spawn(class'UT_BloodHit',,, v);
		v.Z += 10 * FRand();
		Spawn(class'UT_BloodHit',,, v);
		v.Z -= 15 * FRand();
		Spawn(class'UT_BloodHit',,, v);
   }
	for (i=0; i<(3); i++)
   {
		v = Location;
		v.X += 5 * FRand();
		Spawn(class'BloodBurst',,, v);
		v.X -= 7 * FRand();
		Spawn(class'BloodBurst',,, v);
		v.Y += 5 * FRand();
		Spawn(class'BloodBurst',,, v);
		v.Y -= 7 * FRand();
		Spawn(class'BloodBurst',,, v);
		v.Z += 5 * FRand();
		Spawn(class'BloodBurst',,, v);
		v.Z -= 7 * FRand();
		Spawn(class'BloodBurst',,, v);

		v = Location;
		v.X += 7 * FRand();
		Spawn(class'BloodBurst',,, v);
		v.X -= 10 * FRand();
		Spawn(class'BloodBurst',,, v);
		v.Y += 7 * FRand();
		Spawn(class'BloodBurst',,, v);
		v.Y -= 10 * FRand();
		Spawn(class'BloodBurst',,, v);
		v.Z += 7 * FRand();
		Spawn(class'BloodBurst',,, v);
		v.Z -= 10 * FRand();
		Spawn(class'BloodBurst',,, v);
   }
 	for (i=0; i<(80); i++)
   {
		b = Spawn(class'BloodDrop',,, Location);
		b.Velocity = vector( RotRand() ) * ( FRand() * 200 );
		b.DrawScale *= 2 * Frand();
	}
	for (i=0; i<80; i++)
   {
		b = Spawn(class'BloodDrop',,, Location);
		b.Velocity.Z = i * 5;
		b.Velocity.X += (i / 7) * FRand();
		b.Velocity.X -= (i * 1.5 / 7) * FRand();
		b.Velocity.Y += (i / 7) * FRand();
		b.Velocity.Y -= (i * 1.5 / 7) * FRand();
		b.DrawScale += i * 0.00375 * FRand();
		b.bDecal = False;
	}
	for (i=0; i<3; i++)
		SpawnMyGibbedCarcass();
//	Destroy();
}

function SpawnMyGibbedCarcass()
{
	local carcass carc;
	local int i;
	local vector v;

	for (i=0; i<(2); i++)
	{
		v = Location;
		v.X += 100 * FRand();
		Spawn(class'AlienGel',,, v);
		v.X -= 150 * FRand();
		Spawn(class'AlienGel',,, v);
		v.Y += 100 * FRand();
		Spawn(class'AlienGel',,, v);
		v.Y -= 150 * FRand();
		Spawn(class'AlienGel',,, v);
		v.Z += 100 * FRand();
		Spawn(class'AlienGel',,, v);
		v.Z -= 150 * FRand();
		Spawn(class'AlienGel',,, v);
	}
	
	carc = Spawn(class'AlienQueenCarcassV4');
	if ( carc != None )
	{
		carc.Initfor(self);
		carc.ChunkUp(-1 * Health);
	}
}

function PlayTakeHit(float tweentime, vector HitLoc, int Damage)
{
	TweenAnim('TakeHit', tweentime);
}

function SpawnShot()
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X, Y, Z;
	local rotator AdjustedAim;
	local PlayerPawn PP;
	local bool bAltFire, bComboShot;
	local actor Other;
	
	if (row == 0)
		MakeNoise(1.0);
	if (row >= 5) row = 0;

	GetAxes(Rotation, X, Y, Z);
	StartTrace = Location + 1 * CollisionRadius * X + ( 0.7 - 0.2 * row) * CollisionHeight * Z + 0.2 * CollisionRadius * Y;
	EndTrace = StartTrace + 1.0 * (FRand() - 0.5) * Y * 1000	+ 1.0 * (FRand() - 0.5) * Z * 1000;

	AdjustedAim = AdjustAim(1000000, StartTrace, AimErr, bLeadTarget, bWarnTarget);
	EndTrace += (10000 * vector(AdjustedAim));
	Other = TraceShot(HitLocation, HitNormal, EndTrace, StartTrace);
	SpawnEffect(HitLocation, StartTrace);
	Spawn(class'UT_SuperRing2',,, HitLocation+HitNormal*8,rotator(HitNormal));
	if ((Other != self) && (Other != None))
		Other.TakeDamage(2000, self, HitLocation, 60000.0 * X, 'jolted');
	row++;
}

function SpawnEffect(vector HitLocation, vector SmokeLocation) {
	
	local SuperShockBeam Smoke,shock;
	local Vector DVector;
	local int NumPoints;
	local rotator SmokeRotation;
	
	DVector = HitLocation - SmokeLocation;
	NumPoints = VSize(DVector)/135.0;
	if (NumPoints < 1)
		return;
	SmokeRotation = rotator(DVector);
	SmokeRotation.roll = Rand(65535);
	
	Smoke = Spawn(class'SuperShockBeam',,,SmokeLocation,SmokeRotation);
	Smoke.MoveAmount = DVector/NumPoints;
	Smoke.NumPuffs = NumPoints - 1;	
}


function PlayVictoryDance()
{
	if (bEndFootStep)
		FootStep();
	DesiredSpeed = 0.0;
	PlayAnim('ThreeHit', 0.7, 0.15); //gib the enemy here!
	PlaySound(Threaten, SLOT_Talk);		
}

function ClawDamageTarget()
{
	if ( MeleeDamageTarget(ClawDamage, (50000.0 * (Normal(Target.Location - Location)))) )
		PlaySound(Claw, SLOT_Interact);
}

function StabDamageTarget()
{
	local vector X,Y,Z;
	GetAxes(Rotation,X,Y,Z);
	
	if ( MeleeDamageTarget(StabDamage, (15000.0 * ( Y + vect(0,0,1)))) )
		PlaySound(Stab, SLOT_Interact);
}

function PlayMeleeAttack()
{
	local float decision;

	if (bEndFootStep)
		FootStep();
	decision = FRand();
	if (decision < 0.4)
	{
		PlaySound(Stab, SLOT_Interact);
 		PlayAnim('Stab');
 	}
	else if (decision < 0.7)
	{
		PlaySound(Claw, SLOT_Interact);
		PlayAnim('Claw');
	} 
	else 
	{
		PlaySound(Claw, SLOT_Interact);
		PlayAnim('Gouge');
	}
}

function TweenToFalling()
{
	TweenAnim('Jump', 0.2);
}

function PlayInAir()
{
	TweenAnim('Jump', 0.5);
}

function PlayLanded(float impactVel)
{
	local Pawn Thrown;

	TweenAnim('Land', 0.1);

	//throw all nearby creatures, and play sound
	Thrown = Level.PawnList;
	While ( Thrown != None )
	{
		ThrowOther(Thrown);
		Thrown = Thrown.nextPawn;
	}
}

function PlayRangedAttack()
{
	if (bEndFootStep)
		FootStep();

	if ( !bJustScreamed && (FRand() < 0.15) )
		Scream();
	else if ( (Shield != None) && (FRand() < 0.5)
		&& (((Enemy.Location - Location) Dot (Shield.Location - Location)) > 0) )
		Scream();
	else
	{
		if ( Shield != None )
			Shield.Destroy();
		row = 0;
		bJustScreamed = false;
		PlayAnim('Shoot1'); 
		PlaySound(Shoot, SLOT_Interact);			
	}
}

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function PickDestination(bool bNoCharge)
	{
		if ( FRand() < 0.26 )
			GotoState('Teleporting');
		else
			Super.PickDestination(bNoCharge);
	}
}		
		
state Hunting
{
ignores EnemyNotVisible; 

	function PickDestination()
	{
		GotoState('Teleporting');
	}
}

State Teleporting
{
ignores TakeDamage, SeePlayer, EnemyNotVisible, HearNoise, KilledBy, Bump, HitWall, HeadZoneChange, FootZoneChange, ZoneChange, Falling, WarnTarget, Died;

	function Tick(float DeltaTime)
	{
		local int NewFatness; 
		local rotator EnemyRot;

		if ( Style == STY_Translucent )
		{
			ScaleGlow -= 3 * DeltaTime;
			if ( ScaleGlow < 0.3 )
			{
				Spawn(class'QueenTeleportEffect',,, TelepDest);
				Spawn(class'QueenTeleportLight',,, TelepDest);
				EnemyRot = rotator(Enemy.Location - Location);
				EnemyRot.Pitch = 0;
				SetLocation(TelepDest);
				setRotation(EnemyRot);
				PlaySound(sound'Teleport1', SLOT_Interface);
				GotoState('Attacking');
			}
			return;
		}
		else
		{
			NewFatness = fatness - 100 * DeltaTime;
			if ( NewFatness < 80 )
			{
				bUnlit = true;
				ScaleGlow = 2.0;
				Style = STY_Translucent;
			}
		}

		fatness = Clamp(NewFatness, 0, 255);
	}

	function ChooseDestination()
	{
		local NavigationPoint N;
		local vector ViewPoint, HitLocation, HitNormal, Best;
		local actor HitActor;
		local float rating, newrating;

		N = Level.NavigationPointList;
		Best = Location;
		rating = 0;

		while ( N != None )
		{
			if ( N.IsA('QueenDest') ) // rate it
			{
				newrating = 0;
				if ( Best == Location )
					Best = N.Location;
				ViewPoint = N.Location + EyeHeight * vect(0,0,1);
				HitActor = Trace(HitLocation, HitNormal, Enemy.Location, ViewPoint, false);
				if ( HitActor == None )
					newrating = 20000;

				newrating = newrating - VSize(N.Location - Enemy.Location) + 1000 * FRand()
							+ 4 * VSize(N.Location - Location);
				if ( N.Location.Z > Enemy.Location.Z )
					newrating += 1000;
				
				if ( newrating > rating )
				{
					rating = newrating;
					Best = N.Location;
				}
			}

			N = N.nextNavigationPoint;
		}

		TelepDest = Best;
	}

	function BeginState()
	{
		Acceleration = Vect(0,0,0);
		ChooseDestination();
	}

	function EndState()
	{
		bUnlit = false;
		Style = STY_Normal;
		ScaleGlow = 1.0;
		fatness = Default.fatness;
	}
}

defaultproperties
{
	bGreenBlood=True
   ClawDamage=50
   StabDamage=80
   FootstepSound=Sound'step1t'
   ScreamSound=Sound'yell3Q'
   Stab=Sound'stab1Q'
   Shoot=Sound'shoot1Q'
   claw=Sound'claw1Q'
   Aggressiveness=5.00
   RefireRate=0.40
   bHasRangedAttack=True
   bCanDuck=True
   bIsBoss=True
   RangedProjectile=Class'UnrealI.QueenProjectile'
   Acquire=Sound'yell1Q'
   Fear=Sound'yell2Q'
   Roam=Sound'nearby2Q'
   Threaten=Sound'yell2Q'
   MeleeRange=100.00
   GroundSpeed=400.00
   AccelRate=1500.00
   JumpZ=800.00
   Visibility=250
   SightRadius=3000.00
   Health=50000
   ReducedDamageType='
   ReducedDamagePct=0.50
   Intelligence=BRAINS_HUMAN
   HitSound1=Sound'yell2Q'
   HitSound2=Sound'yell2Q'
   Die=Sound'outcoldQ'
   CombatStyle=0.95
   NameArticle=" the "
   AmbientSound=Sound'amb1Q'
   DrawType=DT_Mesh
   Mesh=LodMesh'ACQueen'
   SoundRadius=32
   TransientSoundVolume=16.00
   CollisionRadius=90.20
   CollisionHeight=106.70
   Mass=1000.00
   RotationRate=(Pitch=6000,Yaw=50000,Roll=3072),
}
