
class XMasLights extends Mutator
	config(ChristmasLights);
	
#exec TEXTURE IMPORT NAME=Cyan FILE=TEXTURES\Cyan.BMP
#exec TEXTURE IMPORT NAME=Magenta FILE=TEXTURES\Magenta.BMP
#exec TEXTURE IMPORT NAME=Orange FILE=TEXTURES\Orange.BMP
#exec TEXTURE IMPORT NAME=Purple FILE=TEXTURES\Purple.BMP

var config bool bSpawnAtInventory;
var config float lightSize;
var config int hitOffset, maxCeilingDistance;

// Singleton design pattern
// static keyword isn't available in uscript
var private XMasLights instance;

function PreBeginPlay()
{
	local int navPointCounter, numColour;
	local NavigationPoint NP;
	local TranslocGlow TG;


	local Actor hitActor;
	local vector hitLocation, hitNormal, startVector, endVector;

	// Singleton design pattern
	if( instance == none )
	        instance = self;
	else
	{
		log("Mutator is already loaded.",'XMasLights');
		return;
	}

	// Send PreBeginPlay to parent
	Super.PreBeginPlay();

	log("Mutator active.",'XMasLights');

	// Force creation of ini file
//	SaveConfig();

	for( NP=Level.NavigationPointList; NP!=None; NP=NP.NextNavigationPoint )
	{
		// Skip everything but inventory

		if( bSpawnAtInventory )
		{
 			if ( !NP.IsA('InventorySpot') )
				continue; // Go to next loop
		}

		// Generate random number to decide what colour to spawn
		numColour = rand( 8 ) + 1;

		// Do a trace to find the hit location of the ceiling
		endVector = NP.Location + maxCeilingDistance * vect(0,0,1);
		hitActor = Trace( hitLocation, hitNormal, endVector , NP.Location, false );

		if( !hitActor.isA('LevelInfo') )
			hitLocation = NP.Location;
		else
			hitLocation -= hitOffset * vect(0,0,1);

		// Actually spawn the lights
		switch ( numColour )
		{
  			case 1:
				TG = Spawn(class'TranslocGlow',,,hitLocation,);
				break;

			case 2:
				TG = Spawn(class'TranslocGreen',,,hitLocation,);
				break;

			case 3:
				TG = Spawn(class'TranslocBlue',,,hitLocation,);
				break;

			case 4:
				TG = Spawn(class'TranslocGold',,,hitLocation,);
				break;
				
			case 5:
				TG = Spawn(class'TranslocCyan',,,hitLocation,);
				break;
				
			case 6:
				TG = Spawn(class'TranslocMagenta',,,hitLocation,);
				break;
				
			case 7:
				TG = Spawn(class'TranslocOrange',,,hitLocation,);
				break;

			case 8:
				TG = Spawn(class'TranslocPurple',,,hitLocation,);
				break;

			default:
				log("Invalid value for numColour: " @ numColour,'XMasLights');
		}

		// Check if spawn was succesful to avoid accessed nones
		if( TG == none )
			log("Unable to spawn glowing light!",'XMasLights');
		else
		{
			TG.DrawScale = lightSize; // resize the light

			// Add some lighting effects
			TG.LightEffect = LE_SlowWave;
			TG.LightRadius = 10;
			TG.LightType = LT_Steady;
			TG.LightSaturation = 0;
			TG.LightBrightness = 255;

			// Set the light colours
			if( TG.IsA('TranslocGreen') )
				TG.LightHue=80;
			else if( TG.IsA('TranslocBlue') )
				TG.LightHue=170;
			else if( TG.IsA('TranslocGold') )
				TG.LightHue=32;
			else if( TG.IsA('TranslocCyan') )
				TG.LightHue=127;
			else if( TG.IsA('TranslocMagenta') )
				TG.LightHue=229;
			else if( TG.IsA('TranslocOrange') )
				TG.LightHue=20;
			else if( TG.IsA('TranslocPurple') )
				TG.LightHue=190;
			else
				TG.LightHue=0;
		}
	}
}

defaultproperties
{
   bSpawnAtInventory=True
   lightSize=0.20
   hitOffset=5
   maxCeilingDistance=5000
}
