
class BigRockXmas extends Projectile;

var float SmokeRate;
var bool bRing,bHitWater,bWaterStart;

var vector SpawnPoint;
var float decision;


function PostBeginPlay()
{
    Super.PostBeginPlay();
    Velocity = Vector(Rotation) * (0.8 + (0.3 * FRand())) * speed;
    DesiredRotation.Pitch = Rotation.Pitch + Rand(2000) - 1000;
    DesiredRotation.Roll = Rotation.Roll + Rand(2000) - 1000;
    DesiredRotation.Yaw = Rotation.Yaw + Rand(2000) - 1000; 

    if (FRand() < 0.5)
        RotationRate.Pitch = Rand(180000);
    if ( (RotationRate.Pitch == 0) || (FRand() < 0.8) )
        RotationRate.Roll = Max(0, 50000 + Rand(200000) - RotationRate.Pitch);
}

auto state Flying
{

    simulated function ZoneChange( Zoneinfo NewZone )
    {
        local waterring w;
        
        if (!NewZone.bWaterZone || bHitWater) Return;

        bHitWater = True;
        if ( Level.NetMode != NM_DedicatedServer )
        {
            w = Spawn(class'WaterRing',,,,rot(16384,0,0));
            w.DrawScale = 0.2;
            w.RemoteRole = ROLE_None;
            PlayAnim( 'Dummy', 3.0 );
        }       
        Velocity=0.6*Velocity;
    }

    simulated function ProcessTouch (Actor Other, Vector HitLocation)
    {
        if ( (Other != instigator) && !Other.IsA('Projectile') ) 
            Explode(HitLocation,Normal(HitLocation-Other.Location));
    }

    function BlowUp(vector HitLocation)
    {
    	local int i;

        HurtRadius(Damage,220.0, MyDamageType, MomentumTransfer, HitLocation );
        MakeNoise(1.0);
        SpawnPoint = Location + 5 * HitLocation;
        for (i=0; i<6; i++)
			SpawnMyGibbedCarcass();
    }

    simulated function Explode(vector HitLocation, vector HitNormal)
    {
        local UT_SpriteBallExplosion s;

        s = spawn(class'UT_SpriteBallExplosion',,,HitLocation + HitNormal*16);  
        s.RemoteRole = ROLE_None;

        BlowUp(HitLocation);

        Destroy();
    }

    function BeginState()
    {
        local vector Dir;

        Dir = vector(Rotation);
        Velocity = speed * Dir;
        Acceleration = Dir * 50;
        PlayAnim( 'Dummy', 0.2 );
        if (Region.Zone.bWaterZone)
        {
            bHitWater = True;
            Velocity=0.6*Velocity;
        }
    }
}

function SpawnMyGibbedCarcass()
{
//	local int i;
	local vector v;
	local vector Start;

   decision = FRand();

	Start = Location + 4 * VRand();
	
   if (decision<0.12)
   {
   	Spawn(class'CBall',,,Start,Rotator(Start - Location));
   	return;
   }
   else if (decision<0.24)
   {
   	Spawn(class'RedBall',,,Start,Rotator(Start - Location));
   	return;
   }
   else if (decision<0.36)
   {
   	Spawn(class'GreenBall',,,Start,Rotator(Start - Location));
   	return;
   }
   else if (decision<0.48)
   {
   	Spawn(class'BlueBall',,,Start,Rotator(Start - Location));
   	return;
   }
   else if (decision<0.60)
   {
   	Spawn(class'YellowBall',,,Start,Rotator(Start - Location));
   	return;
   }
   else if (decision<0.72)
   {
   	Spawn(class'BlueCBall',,,Start,Rotator(Start - Location));
   	return;
   }
   else if (decision<0.84)
   {
   	Spawn(class'RedCBall',,,Start,Rotator(Start - Location));
   	return;
   }
   else
   {
   	Spawn(class'PurpleCBall',,,Start,Rotator(Start - Location));
   	return;
   }
}

defaultproperties
{
     speed=900.000000
     MaxSpeed=1000.000000
     Damage=40.000000
     ImpactSound=Sound'UnrealI.Titan.Rockhit'
     bNetTemporary=False
//     Physics=PHYS_Falling
     RemoteRole=ROLE_SimulatedProxy
     LifeSpan=20.000000
     AnimSequence=Dummy
     Mesh=LodMesh'BlueMedBox'
     DrawScale=1.000000
     CollisionRadius=30.000000
     CollisionHeight=30.000000
     bBounce=True
     bFixedRotationDir=True
   MultiSkins(0)=Texture'Gold'
     MultiSkins(1)=Texture'Blue'
}

