
class CuteRabbit extends Pupae;

#exec AUDIO IMPORT FILE="Sounds\behold.WAV" 		NAME="behold"
#exec AUDIO IMPORT FILE="Sounds\covered.WAV" 	NAME="covered"
#exec AUDIO IMPORT FILE="Sounds\frontal.WAV" 	NAME="frontal"
#exec AUDIO IMPORT FILE="Sounds\israbbit.WAV" 	NAME="israbbit"
#exec AUDIO IMPORT FILE="Sounds\jc.WAV" 			NAME="jc"
#exec AUDIO IMPORT FILE="Sounds\lookbone.WAV" 	NAME="lookbone"
#exec AUDIO IMPORT FILE="Sounds\rabbit.WAV" 		NAME="rabbit"
#exec AUDIO IMPORT FILE="Sounds\runaway.WAV" 	NAME="runaway"
#exec AUDIO IMPORT FILE="Sounds\shutup.WAV" 		NAME="shutup"
#exec AUDIO IMPORT FILE="Sounds\warned.WAV" 		NAME="warned"
#exec AUDIO IMPORT FILE="Sounds\youtit.WAV" 		NAME="youtit"

#exec AUDIO IMPORT FILE="Sounds\breath1WL.WAV" NAME="breath1WL"
#exec AUDIO IMPORT FILE="Sounds\Growl.WAV" NAME="Growl"
#exec AUDIO IMPORT FILE="Sounds\roam1WL.WAV" NAME="roam1WL"
#exec AUDIO IMPORT FILE="Sounds\roam11s.WAV" NAME="roam11s"
#exec AUDIO IMPORT FILE="Sounds\walkC.WAV" NAME="walkC"
//#exec AUDIO IMPORT FILE="Sounds\.WAV" NAME=""
//#exec AUDIO IMPORT FILE="Sounds\.WAV" NAME=""
//#exec AUDIO IMPORT FILE="Sounds\.WAV" NAME=""

#exec TEXTURE IMPORT NAME=CuteRabbit FILE=Textures\CuteRabbit.bmp


var byte BiteDamage;      // Basic damage done by bite.
var byte LungeDamage;     // Basic damage done by bite.
var(Sounds) sound bite;
var(Sounds) sound stab;
var(Sounds) sound lunge;
var(Sounds) sound chew;
var(Sounds) sound tear;

function PostBeginPlay()
{
    Super.PostBeginPlay();
    MaxDesiredSpeed = 0.7 + 0.1 * skill;
}

function JumpOffPawn()
{
   Super.JumpOffPawn();
   PlayAnim('Jump', 1.0, 0.2);
}

function SetMovementPhysics()
{
   SetPhysics(PHYS_Falling);
}

function eAttitude AttitudeToCreature(Pawn Other)
{
   if ( Other.IsA('ScriptedPawn') )
   	return ATTITUDE_Hate;
}

function PlayWaiting()
{
   local float decision;
   local float animspeed;
    
	animspeed = 0.4 + 0.6 * FRand();
   decision = FRand();
   if ( !bool(NextAnim) || (decision < 0.4) ) //pick first waiting animation
   {
   	if (!bQuiet)
         PlaySound(Chew, SLOT_Talk, 0.7,,800);
      NextAnim = 'Eat';
   }
   else if (decision < 0.55)
      NextAnim = 'Call';
   else if (decision < 0.7)
   {
      if (!bQuiet)
         PlaySound(Stab, SLOT_Talk, 0.7,,800);
      NextAnim = 'Looking';
   }
   else if (decision < 0.7)
      NextAnim = 'Eat';
   else
      NextAnim = 'Call';
        
   LoopAnim(NextAnim, animspeed);
}

function PlayPatrolStop()
{
   PlayWaiting();
}

function PlayWaitingAmbush()
{
   PlayWaiting();
}

function PlayChallenge()
{
   if ( FRand() < 0.3 )
      PlayWaiting();
   else
      PlayAnim('Looking');
}

function TweenToFighter(float tweentime)
{
   TweenAnim('Looking', tweentime);
}

function TweenToRunning(float tweentime)
{
   if (AnimSequence != 'Jump' || !bAnimLoop)
      TweenAnim('Jump', tweentime);
}

function TweenToWalking(float tweentime)
{
   TweenAnim('Jump', tweentime);
}

function TweenToWaiting(float tweentime)
{
   TweenAnim('Eat', tweentime);
}

function TweenToPatrolStop(float tweentime)
{
   TweenAnim('Eat', tweentime);
}

function PlayRunning()
{
   PlaySound(sound'walkC', SLOT_Interact);
   LoopAnim('Jump', -4.0/GroundSpeed,,0.4);
}

function PlayWalking()
{
   PlaySound(sound'walkC', SLOT_Interact);
   LoopAnim('Jump', -4.0/GroundSpeed,,0.4);
}

function PlayThreatening()
{
   PlayWaiting();
}

function PlayTurning()
{
   TweenAnim('Jump', 0.3);
}

function PlayDying(name DamageType, vector HitLocation)
{
   local carcass carc;

   PlaySound(Die, SLOT_Talk, 3.5 * TransientSoundVolume);
   if (FRand() < 0.35)
      PlayAnim('Land', 0.7, 0.1);
   else if ( FRand() < 0.5 )
   {
      carc = Spawn(class 'CreatureChunks',,, Location + CollisionHeight * vect(0,0,0.8), Rotation + rot(3000,0,16384) );
      if (carc != None)
      {
         carc.Mesh = mesh'CowBody1';
         carc.Initfor(self);
         carc.Velocity = Velocity + VSize(Velocity) * VRand();
         carc.Velocity.Z = FMax(carc.Velocity.Z, Velocity.Z);
      }
      PlayAnim('Land', 0.7, 0.1);
   }
   else
   {
      carc = Spawn(class 'CreatureChunks',,, Location + CollisionHeight * vect(0,0,0.8), Rotation + rot(3000,0,16384) );
      if (carc != None)
      {
         carc.Mesh = mesh'CowBody1';
         carc.Initfor(self);
         carc.Velocity = Velocity + VSize(Velocity) * VRand();
         carc.Velocity.Z = FMax(carc.Velocity.Z, Velocity.Z);
      }
      PlayAnim('Land', 0.7, 0.1);
   }
}

function PlayTakeHit(float tweentime, vector HitLoc, int damage)
{
   PlayAnim('Land');
}

function PlayVictoryDance()
{
   PlayAnim('Looking', 1.0, 0.1);
}

function PlayMeleeAttack()
{
   local float dist, decision;

   decision = FRand();
   dist = VSize(Target.Location - Location);
   if (dist > CollisionRadius + Target.CollisionRadius + 45)
      decision = 0.0;

   if (Physics == PHYS_Falling)
      decision = 1.0;
   if (Target == None)
      decision = 1.0;

   if (decision < 0.15)
   {
      PlaySound(Lunge, SLOT_Interact);
      Enable('Bump');
      PlayAnim('Jump');
      Velocity = 450 * Normal(Target.Location + Target.CollisionHeight * vect(0,0,0.75) - Location);
      if (dist > CollisionRadius + Target.CollisionRadius + 35)
         Velocity.Z += 0.7 * dist;
      SetPhysics(PHYS_Falling);
   }
   else
   {
      PlaySound(Stab, SLOT_Interact);
      PlayAnim('Call');
      MeleeRange = 50;
      MeleeDamageTarget(BiteDamage, vect(0,0,0));
      MeleeRange = Default.MeleeRange;
   }
}

state MeleeAttack
{
	ignores SeePlayer, HearNoise;

   singular function Bump(actor Other)
   {
      Disable('Bump');
      if ((Other == Target) && (AnimSequence == 'Jump'))
         if (MeleeDamageTarget(LungeDamage, vect(0,0,0)))
         {
            if (FRand() < 0.5)
               PlaySound(Tear, SLOT_Interact);
            else
               PlaySound(Bite, SLOT_Interact);
         }
   }
}       

auto state StartUp
{
   function SetMovementPhysics()
   {
      SetPhysics(PHYS_None); // don't fall at start
   }
}

state Waiting
{
TurnFromWall:
   if ( NearWall(70) )
   {
      PlayTurning();
      TurnTo(Focus);
   }
Begin:
   TweenToWaiting(0.4);
   bReadyToAttack = false;
   if (Physics != PHYS_Falling)
      SetPhysics(PHYS_None);
KeepWaiting:
   NextAnim = '';
}

defaultproperties
{
   BiteDamage=1000
   LungeDamage=1000
   Bite=Sound'breath1WL'
   Stab=Sound'roam11s'
   lunge=Sound'roam1WL'
   Chew=Sound'roam11s'
   Tear=Sound'roam1WL'
   CarcassType=Class'RabbitCarcass'
   Aggressiveness=10.000000
   Acquire=Sound'Growl'
   Fear=Sound'breath1WL'
   Roam=Sound'breath1WL'
   Threaten=Sound'Growl'
   MultiSkins(1)=Texture'CuteRabbit'
   bCanStrafe=True
   MeleeRange=280.000000
   GroundSpeed=760.000000
   WaterSpeed=100.000000
   JumpZ=640.000000
   Visibility=100
   SightRadius=2000.000000
   PeripheralVision=-0.400000
   Health=65
   Intelligence=BRAINS_Human
   HitSound1=Sound'UnrealI.death1t'
   HitSound2=Sound'UnrealI.DeathCry1WL'
   Die=Sound'UnrealI.DeathCry1WL'
   CombatStyle=1.000000
   DrawType=DT_Mesh
   Mesh=LodMesh'UnrealShare.Rabbit'
   CollisionRadius=28.000000
   CollisionHeight=9.000000
   Mass=80.000000
   RotationRate=(Pitch=3072,Yaw=65000,Roll=0)
}