
class DestructibleStone extends Mover;

var() Texture ChunkTexture;
var() int ExplosionDimensions; //Chunks spawn this distance away from the destructible
var() float ChunkSize;   //Scales the size of the fragments
var() int ChunkNumber;  //Number of created chunks
var() sound  BreakingSound; //Made when breaking apart

function TakeDamage (int Damage, Pawn instigatedBy, Vector HitLocation, Vector Momentum, name DamageType)
{
   local WallFragments S;
   local int i;

   DamageThreshold -= Damage;
   if (DamageThreshold < 0)
   {
      self.Trigger(self,instigatedBy);  // Just in case
      self.destroy();

      PlaySound(BreakingSound, SLOT_None);

      for (i=0; i<ChunkNumber; i++)
      {
         S = Spawn(Class'WallFragments',,,HitLocation + ExplosionDimensions * VRand());
         if (S != None)
         {
            S.CalcVelocity(vect(0.00,0.00,0.00),128.0);
            S.DrawScale = ChunkSize;
            S.Skin = ChunkTexture;
         }
      }
   }
}

defaultproperties
{
   MoverGlideType=MV_MoveByTime
   MoveTime=0.00
   bTriggerOnceOnly=True
   bDamageTriggered=True
   InitialState=TriggerOpenTimed
   ExplosionDimensions=10.0
   ChunkSize=1.0
   ChunkNumber=2
   ChunkTexture=Texture'city.Sidewalk2'
}
