
class ED209 extends Brute;

#exec MESH IMPORT MESH=e209 ANIVFILE=MODELS\e209_a.3d DATAFILE=MODELS\e209_d.3d LODSTYLE=8
#exec MESH LODPARAMS MESH=e209 STRENGTH=0.2
//#exec MESH ORIGIN MESH=e209 X=0 Y=0 Z=-90 YAW=64 ROLL=0 PITCH=0  //default
#exec MESH ORIGIN MESH=e209 X=0 Y=0 Z=-20 YAW=64 ROLL=0 PITCH=0

#exec MESH SEQUENCE MESH=e209 SEQ=All STARTFRAME=0 NUMFRAMES=205

#exec MESH SEQUENCE MESH=e209 SEQ=Breath1   STARTFRAME=0    NUMFRAMES=20  RATE=10	Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=Breath2   STARTFRAME=0    NUMFRAMES=20  RATE=10	Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=Breath1L  STARTFRAME=0    NUMFRAMES=20  RATE=10	Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=Breath2L  STARTFRAME=0    NUMFRAMES=20  RATE=10	Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=LookL     STARTFRAME=0    NUMFRAMES=20  RATE=10	Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=Chat1     STARTFRAME=0    NUMFRAMES=20  RATE=10	Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=Chat2     STARTFRAME=0    NUMFRAMES=20  RATE=10	Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=Look      STARTFRAME=0    NUMFRAMES=20  RATE=10	Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=CockGun   STARTFRAME=0    NUMFRAMES=20  RATE=10	Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=CockGunL  STARTFRAME=0    NUMFRAMES=20  RATE=10	Group=Waiting

#exec MESH SEQUENCE MESH=e209 SEQ=RunLg     STARTFRAME=20   NUMFRAMES=10 RATE=15
#exec MESH SEQUENCE MESH=e209 SEQ=RunLgFr   STARTFRAME=20   NUMFRAMES=10 RATE=15		Group=MovingFire
#exec MESH SEQUENCE MESH=e209 SEQ=RunSm     STARTFRAME=20   NUMFRAMES=10 RATE=15	
#exec MESH SEQUENCE MESH=e209 SEQ=RunSmFr   STARTFRAME=20   NUMFRAMES=10 RATE=15		Group=MovingFire
#exec MESH SEQUENCE MESH=e209 SEQ=StrafeL   STARTFRAME=20   NUMFRAMES=10 RATE=15		Group=MovingFire
#exec MESH SEQUENCE MESH=e209 SEQ=StrafeR   STARTFRAME=20   NUMFRAMES=10 RATE=15		Group=MovingFire
#exec MESH SEQUENCE MESH=e209 SEQ=SwimLg    STARTFRAME=20   NUMFRAMES=10 RATE=15	
#exec MESH SEQUENCE MESH=e209 SEQ=SwimSm    STARTFRAME=20   NUMFRAMES=10 RATE=15	
#exec MESH SEQUENCE MESH=e209 SEQ=TreadLg   STARTFRAME=20   NUMFRAMES=10 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=TreadSm   STARTFRAME=20   NUMFRAMES=10 RATE=15		Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=DodgeF    STARTFRAME=20   NUMFRAMES=1					Group=Jumping
#exec MESH SEQUENCE MESH=e209 SEQ=DodgeR    STARTFRAME=20   NUMFRAMES=1					Group=Jumping
#exec MESH SEQUENCE MESH=e209 SEQ=DodgeL    STARTFRAME=20   NUMFRAMES=1					Group=Jumping
#exec MESH SEQUENCE MESH=e209 SEQ=Flip      STARTFRAME=20   NUMFRAMES=1					Group=Jumping

#exec MESH SEQUENCE MESH=e209 SEQ=WalkLg    STARTFRAME=30   NUMFRAMES=10 RATE=12
#exec MESH SEQUENCE MESH=e209 SEQ=WalkLgFr  STARTFRAME=30   NUMFRAMES=10 RATE=12		Group=MovingFire
#exec MESH SEQUENCE MESH=e209 SEQ=WalkSm    STARTFRAME=30   NUMFRAMES=10 RATE=12	
#exec MESH SEQUENCE MESH=e209 SEQ=WalkSmFr  STARTFRAME=30   NUMFRAMES=10 RATE=12		Group=MovingFire
#exec MESH SEQUENCE MESH=e209 SEQ=Walk      STARTFRAME=30   NUMFRAMES=10 RATE=12	
#exec MESH SEQUENCE MESH=e209 SEQ=TurnLg    STARTFRAME=30   NUMFRAMES=10 RATE=12	//2 frames of walklgfr
#exec MESH SEQUENCE MESH=e209 SEQ=TurnSm    STARTFRAME=30   NUMFRAMES=10 RATE=12	//2 frames of walksmfr

#exec MESH SEQUENCE MESH=e209 SEQ=DuckWlkL  STARTFRAME=40 	NUMFRAMES=10 RATE=12		Group=Ducking
#exec MESH SEQUENCE MESH=e209 SEQ=DuckWlkS  STARTFRAME=40 	NUMFRAMES=10 RATE=12		Group=Ducking

#exec MESH SEQUENCE MESH=e209 SEQ=BackRun   STARTFRAME=50  	NUMFRAMES=10 RATE=17		Group=MovingFire
#exec MESH SEQUENCE MESH=e209 SEQ=DodgeB    STARTFRAME=50  	NUMFRAMES=1					Group=Jumping

#exec MESH SEQUENCE MESH=e209 SEQ=StillFrRp STARTFRAME=60  	NUMFRAMES=10  RATE=12	Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=StillLgFr STARTFRAME=60  	NUMFRAMES=10  RATE=12	Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=StillSmFr STARTFRAME=60  	NUMFRAMES=10  RATE=12	Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=Fighter   STARTFRAME=60  	NUMFRAMES=1

#exec MESH SEQUENCE MESH=e209 SEQ=AimUpLg   STARTFRAME=70   NUMFRAMES=1			Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=AimUpSm   STARTFRAME=70   NUMFRAMES=1			Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=AimDnLg   STARTFRAME=71   NUMFRAMES=1			Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=AimDnSm   STARTFRAME=71   NUMFRAMES=1			Group=Waiting
#exec MESH SEQUENCE MESH=e209 SEQ=HeadHit   STARTFRAME=72   NUMFRAMES=1			Group=TakeHit
#exec MESH SEQUENCE MESH=e209 SEQ=GutHit    STARTFRAME=72   NUMFRAMES=1			Group=TakeHit
#exec MESH SEQUENCE MESH=e209 SEQ=LeftHit   STARTFRAME=72   NUMFRAMES=1			Group=TakeHit
#exec MESH SEQUENCE MESH=e209 SEQ=RightHit  STARTFRAME=72   NUMFRAMES=1			Group=TakeHit
#exec MESH SEQUENCE MESH=e209 SEQ=JumpLgFr  STARTFRAME=73   NUMFRAMES=1			Group=Jumping
#exec MESH SEQUENCE MESH=e209 SEQ=JumpSmFr  STARTFRAME=73   NUMFRAMES=1			Group=Jumping
#exec MESH SEQUENCE MESH=e209 SEQ=LandLgFr  STARTFRAME=74   NUMFRAMES=1			Group=Landing
#exec MESH SEQUENCE MESH=e209 SEQ=LandSmFr  STARTFRAME=74   NUMFRAMES=1			Group=Landing

#exec MESH SEQUENCE MESH=e209 SEQ=Taunt1    STARTFRAME=75  	NUMFRAMES=20  RATE=20	Group=Gesture
#exec MESH SEQUENCE MESH=e209 SEQ=Wave      STARTFRAME=95  	NUMFRAMES=10  RATE=8		Group=Gesture
#exec MESH SEQUENCE MESH=e209 SEQ=WaveL     STARTFRAME=95  	NUMFRAMES=10  RATE=8		Group=Gesture
#exec MESH SEQUENCE MESH=e209 SEQ=Thrust    STARTFRAME=105  NUMFRAMES=20  RATE=15	Group=Gesture
#exec MESH SEQUENCE MESH=e209 SEQ=Victory1  STARTFRAME=125  NUMFRAMES=20  RATE=10	Group=Gesture

#exec MESH SEQUENCE MESH=e209 SEQ=Dead1     STARTFRAME=145 	NUMFRAMES=20 RATE=10		Group=TakeHit
#exec MESH SEQUENCE MESH=e209 SEQ=Dead2     STARTFRAME=185 	NUMFRAMES=20 RATE=10
#exec MESH SEQUENCE MESH=e209 SEQ=Dead3     STARTFRAME=165 	NUMFRAMES=20 RATE=10
#exec MESH SEQUENCE MESH=e209 SEQ=Dead4     STARTFRAME=145 	NUMFRAMES=20 RATE=10
#exec MESH SEQUENCE MESH=e209 SEQ=Dead7     STARTFRAME=185 	NUMFRAMES=20 RATE=10		Group=TakeHit
#exec MESH SEQUENCE MESH=e209 SEQ=Dead8     STARTFRAME=165 	NUMFRAMES=20 RATE=10		Group=TakeHit
#exec MESH SEQUENCE MESH=e209 SEQ=Dead9     STARTFRAME=185 	NUMFRAMES=10 RATE=15		Group=TakeHit
#exec MESH SEQUENCE MESH=e209 SEQ=Dead9B    STARTFRAME=195 	NUMFRAMES=10 RATE=10
#exec MESH SEQUENCE MESH=e209 SEQ=Dead11    STARTFRAME=145 	NUMFRAMES=20 RATE=10

#exec MESH SEQUENCE MESH=e209 SEQ=DeathEnd  STARTFRAME=164 	NUMFRAMES=1
#exec MESH SEQUENCE MESH=e209 SEQ=DeathEnd2 STARTFRAME=204 	NUMFRAMES=1
#exec MESH SEQUENCE MESH=e209 SEQ=DeathEnd3 STARTFRAME=184 	NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=e209 MESH=e209

#exec MESHMAP SCALE MESHMAP=e209 X=0.07 Y=0.07 Z=0.14

#exec AUDIO IMPORT FILE="Sounds\EdDeath1.wav" 	NAME="EdDeath1"
#exec AUDIO IMPORT FILE="Sounds\EdDeath2.wav" 	NAME="EdDeath2"
#exec AUDIO IMPORT FILE="Sounds\EdDeath3.wav" 	NAME="EdDeath3"
#exec AUDIO IMPORT FILE="Sounds\EdDeath4.wav" 	NAME="EdDeath4"
#exec AUDIO IMPORT FILE="Sounds\EdDrown.wav" 	NAME="EdDrown"
#exec AUDIO IMPORT FILE="Sounds\EdFall.wav" 		NAME="EdFall"
#exec AUDIO IMPORT FILE="Sounds\EdGasp.wav" 		NAME="EdGasp"
#exec AUDIO IMPORT FILE="Sounds\EdJump.wav" 		NAME="EdJump"
#exec AUDIO IMPORT FILE="Sounds\EdLand.wav" 		NAME="EdLand"
#exec AUDIO IMPORT FILE="Sounds\EdHit1.wav" 		NAME="EdHit1"
#exec AUDIO IMPORT FILE="Sounds\EdHit2.wav" 		NAME="EdHit2"
#exec AUDIO IMPORT FILE="Sounds\EdHit3.wav" 		NAME="EdHit3"
#exec AUDIO IMPORT FILE="Sounds\EdHit4.wav" 		NAME="EdHit4"
#exec AUDIO IMPORT FILE="Sounds\EdStep1.wav" 	NAME="EdStep1"
#exec AUDIO IMPORT FILE="Sounds\EdStep2.wav" 	NAME="EdStep2"
#exec AUDIO IMPORT FILE="Sounds\EdStep3.wav" 	NAME="EdStep3"
#exec AUDIO IMPORT FILE="Sounds\EdHum.wav" 		NAME="EdHum"
#exec AUDIO IMPORT FILE="Sounds\Nade.wav" 		NAME="Nade"


#exec MESH NOTIFY MESH=e209 SEQ=RunLG 		TIME=0.25 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=RunLG 		TIME=0.75 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=RunLGFR 	TIME=0.25 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=RunLGFR 	TIME=0.75 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=RunSM 		TIME=0.25 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=RunSM 		TIME=0.75 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=RunSMFR 	TIME=0.25 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=RunSMFR 	TIME=0.75 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=StrafeL 	TIME=0.25 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=StrafeL 	TIME=0.75 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=StrafeR 	TIME=0.25 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=StrafeR 	TIME=0.75 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=BackRun 	TIME=0.25 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=BackRun 	TIME=0.75 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=Dead1 		TIME=0.7 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=e209 SEQ=Dead2 		TIME=0.9 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=e209 SEQ=Dead3 		TIME=0.45 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=e209 SEQ=Dead4 		TIME=0.6 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=e209 SEQ=Dead7 		TIME=0.7 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=e209 SEQ=Dead8 		TIME=0.7 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=e209 SEQ=Dead9B 	TIME=0.8 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=e209 SEQ=Dead11 	TIME=0.57 	FUNCTION=LandThump

#exec TEXTURE IMPORT NAME=ED1 FILE=TEXTURES\ED1.BMP
#exec TEXTURE IMPORT NAME=ED2 FILE=TEXTURES\ED2.BMP
#exec TEXTURE IMPORT NAME=ED3 FILE=TEXTURES\ED3.BMP

#exec MESHMAP SETTEXTURE MESHMAP=e209 NUM=0 TEXTURE=ED2
#exec MESHMAP SETTEXTURE MESHMAP=e209 NUM=1 TEXTURE=ED3
//#exec MESHMAP SETTEXTURE MESHMAP=e209 NUM=0 TEXTURE=ED1A
#exec MESHMAP SETTEXTURE MESHMAP=e209 NUM=3 TEXTURE=ED2

// Needed specific anims
//#exec MESH SEQUENCE MESH=e209 SEQ=All 			STARTFRAME=0 NUMFRAMES=205
#exec MESH SEQUENCE MESH=e209 SEQ=GutHit    	STARTFRAME=72  NUMFRAMES=1
#exec MESH SEQUENCE MESH=e209 SEQ=Breath2  	STARTFRAME=0   NUMFRAMES=20 RATE=10
#exec MESH SEQUENCE MESH=e209 SEQ=Charge     STARTFRAME=20  NUMFRAMES=10 RATE=15
#exec MESH SEQUENCE MESH=e209 SEQ=CockGun   	STARTFRAME=0   NUMFRAMES=20 RATE=10
#exec MESH SEQUENCE MESH=e209 SEQ=Dead1     	STARTFRAME=165 NUMFRAMES=20 RATE=10
#exec MESH SEQUENCE MESH=e209 SEQ=Dead2     	STARTFRAME=165 NUMFRAMES=20 RATE=10
#exec MESH SEQUENCE MESH=e209 SEQ=Dead3    	STARTFRAME=145 NUMFRAMES=20 RATE=10
#exec MESH SEQUENCE MESH=e209 SEQ=Dead4    	STARTFRAME=145 NUMFRAMES=20 RATE=10
#exec MESH SEQUENCE MESH=e209 SEQ=Fighter   	STARTFRAME=60  NUMFRAMES=1
#exec MESH SEQUENCE MESH=e209 SEQ=Gutshot    STARTFRAME=72  NUMFRAMES=1				Group=Attack
#exec MESH SEQUENCE MESH=e209 SEQ=HeadHit   	STARTFRAME=72  NUMFRAMES=1
#exec MESH SEQUENCE MESH=e209 SEQ=Hit   		STARTFRAME=72  NUMFRAMES=1
#exec MESH SEQUENCE MESH=e209 SEQ=LeftHit   	STARTFRAME=72  NUMFRAMES=1
#exec MESH SEQUENCE MESH=e209 SEQ=StillLook  STARTFRAME=0   NUMFRAMES=20 RATE=10
#exec MESH SEQUENCE MESH=e209 SEQ=Precharg   STARTFRAME=0   NUMFRAMES=20 RATE=10
#exec MESH SEQUENCE MESH=e209 SEQ=PistolWhip STARTFRAME=60  NUMFRAMES=10 RATE=12 Group=Attack
#exec MESH SEQUENCE MESH=e209 SEQ=Punch 		STARTFRAME=60  NUMFRAMES=10 RATE=12 Group=Attack
#exec MESH SEQUENCE MESH=e209 SEQ=StillFire  STARTFRAME=75  NUMFRAMES=20 RATE=20 Group=Attack
// Changed to mimic T8, spray anim looks wrong with rockets
//#exec MESH SEQUENCE MESH=e209 SEQ=StillFire  STARTFRAME=60  NUMFRAMES=10  	RATE=12 Group=Attack
#exec MESH SEQUENCE MESH=e209 SEQ=RightHit   STARTFRAME=72  NUMFRAMES=1
#exec MESH SEQUENCE MESH=e209 SEQ=Sleep      STARTFRAME=0   NUMFRAMES=20  	RATE=10
#exec MESH SEQUENCE MESH=e209 SEQ=T8 			STARTFRAME=60  NUMFRAMES=10  	RATE=12
#exec MESH SEQUENCE MESH=e209 SEQ=Walk      	STARTFRAME=30  NUMFRAMES=10 	RATE=12
#exec MESH SEQUENCE MESH=e209 SEQ=WalkFire   STARTFRAME=30  NUMFRAMES=10 	RATE=12 Group=MovingAttack


#exec MESH NOTIFY MESH=e209 SEQ=WalkFire 		TIME=0.18 	FUNCTION=SpawnRightShot
#exec MESH NOTIFY MESH=e209 SEQ=WalkFire 		TIME=0.68 	FUNCTION=SpawnLeftShot
#exec MESH NOTIFY MESH=e209 SEQ=StillFire 	TIME=0.5 	FUNCTION=SpawnLeftShot
#exec MESH NOTIFY MESH=e209 SEQ=PistolWhip 	TIME=0.5 	FUNCTION=WhipDamageTarget
#exec MESH NOTIFY MESH=e209 SEQ=Punch 			TIME=0.55 	FUNCTION=WhipDamageTarget
#exec MESH NOTIFY MESH=e209 SEQ=GutShot 		TIME=0.3 	FUNCTION=GutShotTarget
#exec MESH NOTIFY MESH=e209 SEQ=GutShot 		TIME=0.6 	FUNCTION=GutShotTarget
#exec MESH NOTIFY MESH=e209 SEQ=Walk 			TIME=0.31 	FUNCTION=Step
#exec MESH NOTIFY MESH=e209 SEQ=Walk 			TIME=0.8 	FUNCTION=Step
#exec MESH NOTIFY MESH=e209 SEQ=Dead1 			TIME=0.56 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=e209 SEQ=Dead2 			TIME=0.5 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=e209 SEQ=Dead3 			TIME=0.52 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=e209 SEQ=Dead4 			TIME=0.71 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=e209 SEQ=Charge 		TIME=0.25 	FUNCTION=Step
#exec MESH NOTIFY MESH=e209 SEQ=Charge 		TIME=0.75 	FUNCTION=Step


#exec MESH NOTIFY MESH=e209 SEQ=Charge 	TIME=0.25 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=Charge 	TIME=0.75 	FUNCTION=PlayFootStep
#exec MESH NOTIFY MESH=e209 SEQ=Dead1 		TIME=0.45 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=e209 SEQ=Dead2 		TIME=0.45 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=e209 SEQ=Dead3 		TIME=0.57 	FUNCTION=LandThump
#exec MESH NOTIFY MESH=e209 SEQ=Dead4 		TIME=0.57 	FUNCTION=LandThump

function eAttitude AttitudeToCreature(Pawn Other)
{
   if (Other.IsA('ED209'))
      return ATTITUDE_Friendly;
   else
      return ATTITUDE_Ignore;
}

function PlayHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
    local float rnd;
    local Bubble1 bub;
    local bool bOptionalTakeHit;
    local vector BloodOffset;
 //   local blood2 b;
    local Spark33A K;

    if (Damage > 1) //spawn some blood
    {
        if (damageType == 'Drowned')
        {
            bub = spawn(class 'Bubble1',,, Location 
                + 0.7 * CollisionRadius * vector(ViewRotation) + 0.3 * EyeHeight * vect(0,0,1));
            if (bub != None)
                bub.DrawScale = FRand()*0.06+0.04; 
        }
        else if ( damageType != 'Corroded' )
        {
            BloodOffset = 0.2 * CollisionRadius * Normal(HitLocation - Location);
            BloodOffset.Z = BloodOffset.Z * 0.5;
            K = Spawn(Class'Spark33A',,,HitLocation + BloodOffset,rotator(BloodOffset));
  				Spawn(Class'AltGreenParticleBurst',,,Location);
            if ( Level.bHighDetailMode )
            {
                if ( bGreenBlood )
                    spawn(class'GreenBloodPuff',,, hitLocation + BloodOffset);
                else
                    spawn(class'BloodPuff',,, hitLocation + BloodOffset);
            }
        }
    }   

    if ( (Weapon != None) && Weapon.bPointing && !bIsPlayer )
    {
        bFire = 0;
        bAltFire = 0;
    }
    
    bOptionalTakeHit = bIsWuss || ( (Level.TimeSeconds - LastPainTime > 0.3 + 0.25 * skill)
                        && (Damage * FRand() > 0.08 * Health) && (Skill < 3)
                        && (GetAnimGroup(AnimSequence) != 'MovingAttack') 
                        && (GetAnimGroup(AnimSequence) != 'Attack') ); 
    if ( (!bIsPlayer || (Weapon == None) || !Weapon.bPointing) 
        && (bOptionalTakeHit || (Momentum.Z > 140) || (bFirstShot && (Damage > 0.015 * (skill + 6) * Health)) 
             || (Damage * FRand() > (0.17 + 0.04 * skill) * Health)) ) 
    {
        PlayTakeHitSound(Damage, damageType, 3);
        PlayHitAnim(HitLocation, Damage);
    }
    else if (NextState == 'TakeHit')
    {
        PlayTakeHitSound(Damage, damageType, 2);
        NextState = '';
   }
}

function PlayWaiting()
{
   local float decision;
   local float animspeed;

   bReadyToAttack = true;
   animspeed = 0.3 + 0.5 * FRand(); //fixme - add to all creatures

   decision = FRand();
   if ( AnimSequence == 'Sleep' )
   {
      if ( decision < 0.07 )
      {
         SetAlertness(0.0);
         PlayAnim('Breath2',animspeed, 0.4);
         return;
      }
      else
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep', 0.3 + 0.3 * FRand());
         return;
      }
   }
   else if (AnimSequence == 'Breath2')
   {
      if (decision < 0.2)
      {
         SetAlertness(-0.3);
         PlayAnim('Sleep',animspeed,0.4);
         return;
      }
      else if (decision < 0.37)
         PlayAnim('StillLook', animspeed);
      else if (decision < 0.55)
         PlayAnim('CockGun', animspeed);
      else
         PlayAnim('Breath2', 0.3 + 0.3 * FRand(), 0.4);
   }
   else if (decision < 0.4)
	{
		if (decision < 0.1)
			PlayAnim('Wave', animspeed, 0.4);
		else
        	PlayAnim('Thrust', animspeed, 0.4);
   }
   else PlayAnim('Breath2', 0.3 + 0.3 * FRand(), 0.4);

   if ( AnimSequence == 'Thrust' )
   {
      SetAlertness(0.7);
      if (!bQuiet && (FRand() < 0.7))
         PlayRoamingSound();
   }
   else SetAlertness(0.0);
}

function PlayLeftDeath(name DamageType)
{
   PlayAnim('Dead7',0.7,0.1);
   PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

function PlayGutDeath(name DamageType)
{
   PlayAnim('Dead9B',0.7,0.1);
   PlaySound(Die,SLOT_Talk, 4 * TransientSoundVolume);
}

defaultproperties
{
	bLeadTarget=True
	footstep=Sound'EnforcementDroid209.EdStep1'
	Footstep2=Sound'EnforcementDroid209.EdStep2'
	PistolWhip=Sound'EnforcementDroid209.EdDeath4'
	PistolHit=Sound'EnforcementDroid209.Nade'
	Die2=Sound'EnforcementDroid209.EdDeath4'
	CarcassType=Class'ED209Carcass'
	RangedProjectile=Class'EnforcementDroid209.EDProjectile'
	Acquire=Sound'EnforcementDroid209.EdJump'
	Fear=Sound'EnforcementDroid209.EdDrown'
	Roam=Sound'EnforcementDroid209.EdGasp'
	Threaten=Sound'EnforcementDroid209.EdHit3'
   HitSound1=Sound'EnforcementDroid209.EdHit1'
   HitSound2=Sound'EnforcementDroid209.EdHit2'
	Land=Sound'EnforcementDroid209.EdLand'
	Die=Sound'EnforcementDroid209.EdDeath1'
	AmbientSound=Sound'EnforcementDroid209.EdHum'
CollisionRadius=42.000000
CollisionHeight=52.000000
    SelectionMesh="ED209.Selecte209"
    SpecialMesh="Botpack.TrophyMale2"
    MenuName="ED-209"
    Texture=Texture'ED1'
    Mesh=LodMesh'e209'
//    MultiSkins(0)=Texture'EnforcementDroid209.ED2'
//    MultiSkins(1)=Texture'EnforcementDroid209.ED3'
//    MultiSkins(3)=Texture'EnforcementDroid209.ED2'
	LightBrightness=102
	LightHue=0
	LightSaturation=192
	LightRadius=20
	LightType=LT_SubtlePulse
	bGreenBlood=True

}
