
class ED209Carcass extends CreatureCarcass;

//Scorched base texture
#exec TEXTURE IMPORT NAME=ED1A FILE=TEXTURES\ED1A.BMP

//Chunk1
#exec MESH IMPORT MESH=impbotchunk1 ANIVFILE=MODELS\impbotchunk1_a.3d DATAFILE=MODELS\impbotchunk1_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=impbotchunk1 X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=impbotchunk1 STRENGTH=0
#exec MESH SEQUENCE MESH=impbotchunk1 SEQ=All STARTFRAME=0 NUMFRAMES=30
#exec MESHMAP NEW MESHMAP=impbotchunk1 MESH=impbotchunk1
#exec MESHMAP SCALE MESHMAP=impbotchunk1 X=0.1 Y=0.1 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=impbotchunk1 NUM=0 TEXTURE=ED1A

//Chunk2
#exec MESH IMPORT MESH=impbotchunk2 ANIVFILE=MODELS\impbotchunk2_a.3d DATAFILE=MODELS\impbotchunk2_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=impbotchunk2 X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=impbotchunk2 STRENGTH=0
#exec MESH SEQUENCE MESH=impbotchunk2 SEQ=All STARTFRAME=0 NUMFRAMES=30
#exec MESHMAP NEW MESHMAP=impbotchunk2 MESH=impbotchunk2
#exec MESHMAP SCALE MESHMAP=impbotchunk2 X=0.1 Y=0.1 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=impbotchunk2 NUM=0 TEXTURE=ED1A

//Chunk4
#exec MESH IMPORT MESH=impbotchunk4 ANIVFILE=MODELS\impbotchunk4_a.3d DATAFILE=MODELS\impbotchunk4_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=impbotchunk4 X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=impbotchunk4 STRENGTH=0
#exec MESH SEQUENCE MESH=impbotchunk4 SEQ=All STARTFRAME=0 NUMFRAMES=59
#exec MESHMAP NEW MESHMAP=impbotchunk4 MESH=impbotchunk4
#exec MESHMAP SCALE MESHMAP=impbotchunk4 X=0.1 Y=0.1 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=impbotchunk4 NUM=0 TEXTURE=ED1A

//Chunk6
#exec MESH IMPORT MESH=impbotchunk6 ANIVFILE=MODELS\impbotchunk6_a.3d DATAFILE=MODELS\impbotchunk6_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=impbotchunk6 X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=impbotchunk6 STRENGTH=0
#exec MESH SEQUENCE MESH=impbotchunk6 SEQ=All STARTFRAME=0 NUMFRAMES=59
#exec MESHMAP NEW MESHMAP=impbotchunk6 MESH=impbotchunk6
#exec MESHMAP SCALE MESHMAP=impbotchunk6 X=0.1 Y=0.1 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=impbotchunk6 NUM=0 TEXTURE=ED1A

//Chunk7
#exec MESH IMPORT MESH=impbotchunk7 ANIVFILE=MODELS\impbotchunk7_a.3d DATAFILE=MODELS\impbotchunk7_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=impbotchunk7 X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=impbotchunk7 STRENGTH=0
#exec MESH SEQUENCE MESH=impbotchunk7 SEQ=All STARTFRAME=0 NUMFRAMES=59
#exec MESHMAP NEW MESHMAP=impbotchunk7 MESH=impbotchunk7
#exec MESHMAP SCALE MESHMAP=impbotchunk7 X=0.1 Y=0.1 Z=0.2
#exec TEXTURE IMPORT NAME=IMPJgibskin3 FILE=Textures\IMPJgibskin3.bmp GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=IMPJgibskin3 FILE=Textures\IMPJgibskin3.bmp GROUP=Skins PALETTE=IMPJgibskin3
#exec MESHMAP SETTEXTURE MESHMAP=impbotchunk7 NUM=0 TEXTURE=IMPJgibskin3

//Chunk10
#exec MESH IMPORT MESH=impbotchunk10 ANIVFILE=MODELS\impbotchunk10_a.3d DATAFILE=MODELS\impbotchunk10_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=impbotchunk10 X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=impbotchunk10 STRENGTH=0
#exec MESH SEQUENCE MESH=impbotchunk10 SEQ=All STARTFRAME=0 NUMFRAMES=30
#exec MESHMAP NEW MESHMAP=impbotchunk10 MESH=impbotchunk10
#exec MESHMAP SCALE MESHMAP=impbotchunk10 X=0.1 Y=0.1 Z=0.2
#exec TEXTURE IMPORT NAME=ibgibskin4 FILE=Textures\ibgibskin4.bmp  GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=ibgibskin4 FILE=Textures\ibgibskin4.bmp  GROUP=Skins PALETTE=ibgibskin4
#exec MESHMAP SETTEXTURE MESHMAP=impbotchunk10 NUM=0 TEXTURE=ibgibskin4

//Bolt
#exec MESH IMPORT MESH=boltajrm ANIVFILE=MODELS\boltajrm_a.3d DATAFILE=MODELS\boltajrm_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=boltajrm X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=boltajrm STRENGTH=0
#exec MESH SEQUENCE MESH=boltajrm SEQ=All STARTFRAME=0 NUMFRAMES=30
#exec MESHMAP NEW MESHMAP=boltajrm MESH=boltajrm
#exec MESHMAP SCALE MESHMAP=boltajrm X=0.1 Y=0.1 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=boltajrm NUM=0 TEXTURE=ED1A
#exec MESHMAP SETTEXTURE MESHMAP=boltajrm NUM=1 TEXTURE=ED1A
#exec MESHMAP SETTEXTURE MESHMAP=boltajrm NUM=2 TEXTURE=ED1A
#exec MESHMAP SETTEXTURE MESHMAP=boltajrm NUM=3 TEXTURE=ED1A


function ForceMeshToExist()
{
   //never called
   Spawn(class 'ED209');
}

//Added to remove flies. They are robots, there should be no flies.
state Dead
{
   function AddFliesAndRats()
   {
   }

   function CheckZoneCarcasses()
   {
      local CreatureCarcass C, Best;

      if ( !bDecorative && (DeathZone.NumCarcasses > DeathZone.MaxCarcasses) )
      {
         Best = self;
         ForEach AllActors(class'CreatureCarcass', C)
         	if ( (C != Self) && !C.bDecorative && (C.DeathZone == DeathZone) && !C.IsAnimating() )
            {
               if ( Best == self )
                  Best = C;
               else if ( !C.PlayerCanSeeMe() )
               {
                  Best = C;
                  break;
               }
            }
         Best.Destroy();
      }
   }

   function Timer()
   {
      if ( ExistTime <= 0 )
         Super.Timer();
      else
      {
         SetPhysics(Phys_Falling);
         ExistTime -= 3.0;
      }
   }

   singular event BaseChange()
   {
      if ( (Mover(Base) != None) && (ExistTime == 0) )
      {
         ExistTime = FClamp(30.0 - 2 * DeathZone.NumCarcasses, 5, 12);
         SetTimer(3.0, true);
      }
      Super.BaseChange();
   }

   function BeginState()
   {
      if ( bDecorative || bPermanent )
         lifespan = 0.0;
      else
      {
         if ( Mover(Base) != None )
         {
            ExistTime = FMax(12.0, 30.0 - 2 * DeathZone.NumCarcasses);
            SetTimer(3.0, true);
         }
         else SetTimer(FMax(12.0, 30.0 - 2 * DeathZone.NumCarcasses), false);
      }
   }
}

defaultproperties
{
	bodyparts(0)=LodMesh'EnforcementDroid209.impbotchunk1'
	bodyparts(1)=LodMesh'EnforcementDroid209.impbotchunk2'
	bodyparts(2)=LodMesh'EnforcementDroid209.impbotchunk4'
	bodyparts(3)=LodMesh'EnforcementDroid209.impbotchunk6'
	bodyparts(4)=LodMesh'EnforcementDroid209.impbotchunk7'
	bodyparts(5)=LodMesh'EnforcementDroid209.impbotchunk10'
	bodyparts(6)=LodMesh'EnforcementDroid209.boltajrm'
	bodyparts(7)=LodMesh'EnforcementDroid209.boltajrm'
	ZOffset(0)=0.600000
	ZOffset(1)=0.500000
	ZOffset(3)=0.200000
	ZOffset(4)=-0.200000
	ZOffset(5)=-0.500000
	AnimSequence=Dead1
	Mesh=LodMesh'e209'
	CollisionRadius=42.000000
	CollisionHeight=52.000000
	Mass=400.000000
	Buoyancy=390.000000
	MultiSkins(1)=Texture'EnforcementDroid209.ED3'
	bGreenBlood=True
}