class CoffeePickup extends TournamentPickUp;

#exec MESH IMPORT MESH=CoffeePickup ANIVFILE=MODELS\CoffeePickup_a.3d DATAFILE=MODELS\CoffeePickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=CoffeePickup X=0 Y=0 Z=245
#exec MESH SEQUENCE MESH=CoffeePickup SEQ=All STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=CoffeePickup MESH=CoffeePickup
#exec MESHMAP SCALE MESHMAP=CoffeePickup X=0.025 Y=0.025 Z=0.05
#exec MESH LODPARAMS MESH=CoffeePickup STRENGTH=0

#exec TEXTURE IMPORT NAME=CoffeeCupTex FILE=Textures\CoffeeCupTex.BMP GROUP=Skins
#exec MESHMAP SETTEXTURE MESHMAP=CoffeePickup NUM=1 TEXTURE=CoffeeCupTex
#exec MESHMAP SETTEXTURE MESHMAP=CoffeePickup NUM=2 TEXTURE=CoffeeCupTex
#exec MESHMAP SETTEXTURE MESHMAP=CoffeePickup NUM=3 TEXTURE=CoffeeCupTex

#exec AUDIO IMPORT FILE="Sounds\CoffeeSlurp.Wav" NAME=CoffeeSlurp

var Weapon CoffeeCupWeapon;
var sound ExtraFireSound;
var sound EndFireSound;
var int FinalCount;
var float CoffeeSmokeRate;

replication
{
    reliable if( bNetOwner && (Role==ROLE_Authority) )
        CoffeeSmokeRate;
}


auto state Pickup
{
 	simulated function Timer()
	{
   	local ut_SpriteSmokePuff b;

      if (!bHidden)
      {
   		CoffeeSmokeRate = 0.45;
   		b = Spawn(class'CoffeeSmokePuff');
   		b.RemoteRole = ROLE_None;
   		if (Level.Netmode != NM_DedicatedServer)
   			SetTimer(CoffeeSmokeRate, false);
   	}
	}
}

simulated function PostBeginPlay()
{
    CoffeeSmokeRate = 0.3;
    SetTimer(0.3,false); 
}

singular function UsedUp()
{
   if ( CoffeeCupWeapon != None )
   {
      CoffeeCupWeapon.SetDefaultDisplayProperties();
      if ( CoffeeCupWeapon.IsA('TournamentWeapon') )
         TournamentWeapon(CoffeeCupWeapon).Affector = None;
   }
   if ( Owner != None )
   {
      if ( Owner.bIsPawn )
      {
         if ( !Pawn(Owner).bIsPlayer || (Pawn(Owner).PlayerReplicationInfo.HasFlag == None) )
         {
            Owner.AmbientGlow = Owner.Default.AmbientGlow;
            Owner.LightType = LT_None;
         }
         Pawn(Owner).DamageScaling = 1.0;
      }
      bActive = false;
      if ( Owner.Inventory != None )
      {
         Owner.Inventory.SetOwnerDisplay();
         Owner.Inventory.ChangedWeapon();
      }
   }
   Destroy();
}

simulated function FireEffect()
{
   if ( (TimerRate - TimerCounter < 5) && (Level.NetMode != NM_Client) )
      Pawn(Owner).Weapon.PlayOwnedSound(EndFireSound, SLOT_Interact, 8);
   else
      Pawn(Owner).Weapon.PlayOwnedSound(ExtraFireSound, SLOT_Interact, 8);
}

function SetOwnerLighting()
{
   if ( Owner.bIsPawn && Pawn(Owner).bIsPlayer && (Pawn(Owner).PlayerReplicationInfo.HasFlag != None) )
      return;
   Owner.AmbientGlow = 254;
   Owner.LightEffect=LE_NonIncidence;
   Owner.LightBrightness=255;
   Owner.LightHue=210;
   Owner.LightRadius=10;
   Owner.LightSaturation=0;
   Owner.LightType=LT_Steady;
}

function SetCoffeeCupWeapon()
{
   if ( !bActive )
      return;

   SetOwnerLighting();

   if ( CoffeeCupWeapon != None )
   {
      CoffeeCupWeapon.SetDefaultDisplayProperties();
      if ( CoffeeCupWeapon.IsA('TournamentWeapon') )
         TournamentWeapon(CoffeeCupWeapon).Affector = None;
   }
        
   CoffeeCupWeapon = Pawn(Owner).Weapon;
   if ( CoffeeCupWeapon != None )
   {
      if ( CoffeeCupWeapon.IsA('TournamentWeapon') )
         TournamentWeapon(CoffeeCupWeapon).Affector = self;
      if ( Level.bHighDetailMode )
         CoffeeCupWeapon.SetDisplayProperties(ERenderStyle.STY_Translucent, FireTexture'UnrealShare.Belt_fx.PulseHit',true,true);
      else
         CoffeeCupWeapon.SetDisplayProperties(ERenderStyle.STY_Normal, FireTexture'UnrealShare.Belt_fx.PulseHit',true,true);
   }
}

state Activated
{
   function Timer()
   {
      if ( FinalCount > 0 )
      {
         SetTimer(1.0, true);
         Owner.PlaySound(DeActivateSound,, 8);
         FinalCount--;
         return;
      }
      UsedUp();
   }

   function SetOwnerDisplay()
   {
      if( Inventory != None )
         Inventory.SetOwnerDisplay();

      SetCoffeeCupWeapon();
   }

   function ChangedWeapon()
   {
      if( Inventory != None )
         Inventory.ChangedWeapon();

      SetCoffeeCupWeapon();
   }

   function EndState()
   {
   	local float SpeedScale;
    	
   	if ( Level.Game.IsA('DeathMatchPlus') && DeathMatchPlus(Level.Game).bMegaSpeed )
         SpeedScale = 1.3;
      else SpeedScale = 1.0;

      Pawn(Owner).AirControl = DeathMatchPlus(Level.Game).AirControl;
      Pawn(Owner).JumpZ = Pawn(Owner).Default.JumpZ * Level.Game.PlayerJumpZScaling();
      Pawn(Owner).GroundSpeed = Pawn(Owner).Default.GroundSpeed * SpeedScale;
      Pawn(Owner).WaterSpeed = Pawn(Owner).Default.WaterSpeed * SpeedScale;
      Pawn(Owner).AirSpeed = Pawn(Owner).Default.AirSpeed * SpeedScale;
      Pawn(Owner).Acceleration = Pawn(Owner).Default.Acceleration * SpeedScale;

      UsedUp();
	}

	function BeginState()
   {
      bActive = true;
      FinalCount = Min(FinalCount, 0.1 * Charge - 1);
      SetTimer(0.1 * Charge - FinalCount,false);
      Owner.PlaySound(ActivateSound);
      SetOwnerLighting();
      Pawn(Owner).DamageScaling = 3.0;
      SetCoffeeCupWeapon();
		Pawn(Owner).AirControl = 0.65;
      Pawn(Owner).JumpZ *= 1.1;
      Pawn(Owner).GroundSpeed *= 1.3;
      Pawn(Owner).WaterSpeed *= 1.3;
      Pawn(Owner).AirSpeed *= 1.3;
      Pawn(Owner).Acceleration *= 1.3;
   }
}

defaultproperties
{
	DrawType=DT_Mesh
	Mesh=CoffeePickup
   FinalCount=5
   EndFireSound=AmpFire2b
   ExtraFireSound=sound'Botpack.Pickups.AmpFire'
   ItemName="Coffee Cup"
   MaxDesireability=2.500000
   bAutoActivate=True
   bActivatable=True
   bDisplayableInv=True
   PickupMessage="You got the Cup of Coffee!"
   RespawnTime=120.000000
	PickupViewMesh=CoffeePickup
   PickupViewScale=1.000000
   Charge=300
	PickupSound=CoffeeSlurp
   DeActivateSound=Sound'Botpack.Pickups.AmpOut'
   Physics=PHYS_Rotating
   RemoteRole=ROLE_DumbProxy
   DrawScale=1.000000
}
