
class CucumberChunk extends Projectile;

#exec MESH IMPORT MESH=CucumberChunk ANIVFILE=MODELS\CucumberChunk_a.3d DATAFILE=MODELS\CucumberChunk_d.3d LODSTYLE=10
#exec MESH ORIGIN MESH=CucumberChunk X=0 Y=0 Z=0 YAW=0
#exec MESH SEQUENCE MESH=CucumberChunk SEQ=All    STARTFRAME=0  NUMFRAMES=1
#exec TEXTURE IMPORT NAME=SaladChunkT FILE=Textures/SaladChunksUVMap.pcx GROUP="Skins"  LODSET=2
#exec MESHMAP SCALE MESHMAP=CucumberChunk X=0.04 Y=0.04 Z=0.08
#exec MESHMAP SETTEXTURE MESHMAP=CucumberChunk NUM=1 TEXTURE=SaladChunkT

#exec AUDIO IMPORT FILE="Sounds\veghit1.WAV" NAME=veghit1 GROUP=Veggies
#exec AUDIO IMPORT FILE="Sounds\veghit2.WAV" NAME=veghit2 GROUP=Veggies
#exec AUDIO IMPORT FILE="Sounds\veghit3.WAV" NAME=veghit3 GROUP=Veggies

simulated function PostBeginPlay()
{
	local rotator RandRot;

	if ( Role == ROLE_Authority )
	{
		RandRot = Rotation;
		RandRot.Pitch += FRand() * 2000 - 1000;
		RandRot.Yaw += FRand() * 2000 - 1000;
		RandRot.Roll += FRand() * 2000 - 1000;
		Velocity = Vector(RandRot) * (Speed + (FRand() * 200 - 100));
		if (Region.zone.bWaterZone)
			Velocity *= 0.65;
	}
	Super.PostBeginPlay();
}

simulated function ProcessTouch (Actor Other, vector HitLocation)
{
	if ( (Chunk(Other) == None) && ((Physics == PHYS_Falling) || (Other != Instigator)) )
	{
		speed = VSize(Velocity);
		If ( speed > 200 )
		{
			if ( Role == ROLE_Authority )
				Other.TakeDamage(damage, instigator,HitLocation, (MomentumTransfer * Velocity/speed), MyDamageType );
			if ( FRand() < 0.5 )
				PlaySound(Sound 'ChunkHit',, 4.0,,200);
		}
		Destroy();
	}
}

simulated function Landed( Vector HitNormal )
{
	local rotator RandRot;

	SetPhysics(PHYS_None);
	RandRot = Rotation;
	RandRot.Pitch = 0;
	RandRot.Roll = 0;
	SetRotation(RandRot);
}

simulated function HitWall( vector HitNormal, actor Wall )
{
	local float Rand;
	local SmallSpark s;
	local rotator RandRot;

	if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
	{
		if ( Level.NetMode != NM_Client )
			Wall.TakeDamage( Damage, instigator, Location, MomentumTransfer * Normal(Velocity), MyDamageType);
		Destroy();
		return;
	}
	if ( Physics != PHYS_Falling )
	{
		SetPhysics(PHYS_Falling);
		if ( !Level.bDropDetail && (Level.Netmode != NM_DedicatedServer) && !Region.Zone.bWaterZone )
		{
			if ( FRand() < 0.5 )
			{
				s = Spawn(Class'SmallSpark',,,Location+HitNormal*5,rotator(HitNormal));
				s.RemoteRole = ROLE_None;
			}
			else
				Spawn(class'WallCrack',,,Location, rotator(HitNormal));
		}
	}
	Velocity = 0.8*(( Velocity dot HitNormal ) * HitNormal * (-1.8 + FRand()*0.8) + Velocity);   // Reflect off Wall w/damping
	//SetRotation(rotator(Velocity));
	SetRotation(RandRot);

	speed = VSize(Velocity);
	if ( speed > 100 )
	{
		MakeNoise(0.3);
		Rand = FRand();
		if (Rand < 0.33)	
			PlaySound(sound 'veghit1', SLOT_Misc,0.6,,1000);
		else if (Rand < 0.66)
			PlaySound(sound 'veghit2', SLOT_Misc,0.6,,1000);
		else
			PlaySound(sound 'veghit3', SLOT_Misc,0.6,,1000);
	}
}

simulated function zonechange(Zoneinfo NewZone)
{
	if (NewZone.bWaterZone)
	{
		SetTimer(0.0, false);
		Velocity *= 0.65;
	}
}

defaultproperties
{
   speed=2500.000000
   MaxSpeed=2700.000000
   Damage=16.000000
   MomentumTransfer=10000
   MyDamageType=shredded
   RemoteRole=ROLE_SimulatedProxy
   LifeSpan=6.00000
   Mesh=CucumberChunk
   bNoSmooth=True
   bBounce=True
   bFixedRotationDir=True
   RotationRate=(Pitch=10000,Yaw=15000,Roll=20000),
}
