
class FFHUD expands ChallengeHUD;

var PlayerPawn Player;
var GameReplicationInfo GRI;
var int RespawnTimer;
var PlayerReplicationInfo Ordered[32];

simulated function PostBeginPlay ()
{
   Super.PostBeginPlay();
   Level.bHighDetailMode = true;
   RespawnTimer=0;
   SetTimer(0.50,True);
}

function Timer ()
{
   local int i, j;

   if (PawnOwner.IsInState('Dying') && RespawnTimer==0) // delay the respawn so player can see SB
      RespawnTimer=10*2; // 10 sec
   else if (PawnOwner.IsInState('Dying') && RespawnTimer>0)
   {
      if (--RespawnTimer == 0)
         PlayerPawn(PawnOwner).ServerRestartPlayer();
   }
   if (!bDrawMessageArea)
   {
      if (MessageFadeCount > 0)
         MessageFadeCount--;
   }
   for (i=0; i<4; i++)
   {
      if ( (ShortMessageQueue[i].Message != None) && (Level.TimeSeconds >= ShortMessageQueue[i].EndOfLife) )
         ClearMessage(ShortMessageQueue[i]);
   }
   for (i=0; i<3; i++)
   {
      if ( ShortMessageQueue[i].Message == None )
      {
         for (j=i; j<4; j++)
         {
            if ( ShortMessageQueue[j].Message != None )
            {
               CopyMessage(ShortMessageQueue[i],ShortMessageQueue[j]);
               ClearMessage(ShortMessageQueue[j]);
               break;
            }
         }
      }
   }
   for (i=0; i<10; i++)
   {
      if ( (LocalMessages[i].Message != None) && (Level.TimeSeconds >= LocalMessages[i].EndOfLife) )
         ClearMessage(LocalMessages[i]);
   }
   for (i=0; i<9; i++)
   {
      if ( LocalMessages[i].Message == None )
      {
         CopyMessage(LocalMessages[i],LocalMessages[i+1]);
         ClearMessage(LocalMessages[i+1]);
      }
   }
   if ( (PlayerOwner == None) || (PawnOwner == None) || (PlayerOwner.GameReplicationInfo == None) || (PawnOwner.PlayerReplicationInfo == None) )
      return;
      
   UpdateRankAndSpread();
}

function UpdateRankAndSpread()
{
    local PlayerReplicationInfo PRI;
    local int HighScore;
    local int i, j;

    PlayerCount = 0;
    HighScore = -100;
    bTiedScore = False;
    Rank = 1;
    for (i=0; i<32; i++)
    {
        PRI = PlayerOwner.GameReplicationInfo.PRIArray[i];
        if ( (PRI != None) && (!PRI.bIsSpectator || PRI.bWaitingPlayer) )
        {
            PlayerCount++;
            if (PRI != PawnOwner.PlayerReplicationInfo)
            {
                if (PRI.Score > PawnOwner.PlayerReplicationInfo.Score)
                    Rank += 1;
                else if (PRI.Score == PawnOwner.PlayerReplicationInfo.Score)
                {
                    bTiedScore = True;
                    if (PRI.Deaths < PawnOwner.PlayerReplicationInfo.Deaths)
                        Rank += 1;
                    else if (PRI.Deaths == PawnOwner.PlayerReplicationInfo.Deaths)
                        if (PRI.PlayerID < PawnOwner.PlayerReplicationInfo.PlayerID)
                            Rank += 1;
                }
                if (PRI.Score > HighScore)
                    HighScore = PRI.Score;
            }
        }
    }
    Lead = int(PawnOwner.PlayerReplicationInfo.Score) - HighScore;
}

defaultproperties
{
   bAlwaysRelevant=True
   bNetTemporary=True
   ServerInfoClass=class'FFServerInfo'
}

