
class FFMod expands Mutator config(FoodFightWeapons);

var config string 	DMGameName, DMLeftMessage, DMEnteredMessage;
var bool bInitialized;

//Spawn protection
var() globalconfig bool bUseSpawnProt;
var() globalconfig int SpawnProtDuration;

//FoodFight Melee match
var config bool GiveAllWeapons;

//Player touching lag
var config bool stopPlayerCollision;

function PreBeginPlay ()
{
	Super.PreBeginPlay();
	SaveConfig();
	
	//Level.Game.BaseMutator.AddMutator(Level.Spawn(class'FF_SA'));    //Dummy class for protection

	Level.Game.ScoreBoardType = Class'FFScoreBoard';
	Level.Game.HUDType = Class'FFHUD';
	Level.Game.GameName = DMGameName;
	Level.Game.LeftMessage = DMLeftMessage;
	Level.Game.EnteredMessage = DMEnteredMessage;
	//AddMutator(Level.Spawn(class''));        Blank mutator class loading if needed
}

function PostBeginPlay()
{
   if (bInitialized)
		return;
	bInitialized = True;

   Level.Game.RegisterDamageMutator(Spawn(class'SpawnProt'));
   Level.Game.RegisterDamageMutator(Self);

   if ( NextMutator != None )
		NextMutator.PostBeginPlay();
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local int random, randomA;

   if(Other.IsA('Pickup'))
   {
      Pickup(Other).bAutoActivate=True;
   }
//Weapon replacements
	if(Other.Class==Class'Chainsaw')
   {
      ReplaceWith(Other,"FoodFightWeapons.CanOpener");
      return false;
   }
   if(Other.Class==Class'Enforcer')
   {
      ReplaceWith(Other,"FoodFightWeapons.CanOpener");
      return false;
   }
   if(Other.Class==Class'ImpactHammer')
   {
      //ReplaceWith(Other,"FoodFightWeapons.FryingPan");
      return false;
   }
   if(Other.Class==Class'Minigun2')
   {
      ReplaceWith(Other,"FoodFightWeapons.PeanutGun");
      return false;
   }
   if(Other.Class==Class'PulseGun')
   {
      ReplaceWith(Other,"FoodFightWeapons.SweetCherryCan");
      return false;
   }
//Replaceme
   if(Other.Class==Class'Ripper')
   {
      //ReplaceWith(Other,"FoodFightWeapons.Carroteer");
      ReplaceWith(Other,"FoodFightWeapons.CPanel3");
      return false;
   }
   if(Other.Class==Class'ShockRifle')
   {
      ReplaceWith(Other,"FoodFightWeapons.PapriCannonGun");
      return false;
   }
   if(Other.Class==Class'SniperRifle')
   {
      ReplaceWith(Other,"FoodFightWeapons.HAnKARifle");
      return false;
   }
//   if(Other.Class==Class'Translocator')
//   {
//      ReplaceWith(Other,);
//      return false;
//   }
//Replaceme
   if(Other.Class==Class'UT_BioRifle')
   {
      ReplaceWith(Other,"FoodFightWeapons.Saucier");
      return false;
   }
   if(Other.Class==Class'UT_Eightball')
   {
      ReplaceWith(Other,"FoodFightWeapons.Toastanator");
      return false;
   }
   if(Other.Class==Class'UT_FlakCannon')
   {
      ReplaceWith(Other,"FoodFightWeapons.SaladThrower");
      return false;
   }
   if(Other.Class==Class'WarHeadLauncher')
   {
      ReplaceWith(Other,"FoodFightWeapons.HalapenjoCan");
      return false;
   }
//Ammo pickups
	if(Other.Class==Class'BulletBox')
   {
		random = Rand(2);
		switch(random)
		{
			case 0:
				ReplaceWith(Other,"FoodFightWeapons.KidneyBeanCan");
			break;
			case 1:
				ReplaceWith(Other,"FoodFightWeapons.PlumCan");
			break;
		}
      return false;
   }
//   if(Other.Class==Class'BioAmmo')
//   {
      //ReplaceWith(Other,"FoodFightWeapons.");   //sauce class
//      return false;
//   }
   if(Other.Class==Class'BladeHopper')
   {
      //ReplaceWith(Other,"FoodFightWeapons.");   //Caroteer ammo
      return false;
   }
   if(Other.Class==Class'FlakAmmo')
   {
      ReplaceWith(Other,"FoodFightWeapons.SaladPack");
      return false;
   }
   if(Other.Class==Class'MiniAmmo')
   {
      ReplaceWith(Other,"FoodFightWeapons.PeanutCan");
      return false;
   }
   if(Other.Class==Class'PAmmo')
   {
      ReplaceWith(Other,"FoodFightWeapons.SweetCherryCan");
      return false;
   }
	if(Other.Class==Class'RocketPack')
   {
      ReplaceWith(Other,"FoodFightWeapons.BreadPack");
      return false;
   }
   if(Other.Class==Class'ShockCore')
   {
      ReplaceWith(Other,"FoodFightWeapons.PapriNadeCylinder");
      return false;
   }
	if(Other.Class==Class'WarheadAmmo')
   {
      ReplaceWith(Other,"FoodFightWeapons.HalapenjoCan");
      return false;
   }
//Health pickups
	if(Other.Class==Class'MedBox')
   {
      ReplaceWith(Other,"FoodFightWeapons.MilkCarton");
      return false;
   }
   if(Other.Class==Class'Armor2')
   {
      ReplaceWith(Other,"FoodFightWeapons.FFArmor");
      return false;
   }
   if(Other.Class==Class'Healthvial')
   {
   	randomA = Rand(5);
		switch(randomA)
		{
			case 0:
				ReplaceWith(Other,"FoodFightWeapons.JuiceBottleApple");
			break;
			case 1:
				ReplaceWith(Other,"FoodFightWeapons.JuiceBottleGrape");
			break;
			case 2:
				ReplaceWith(Other,"FoodFightWeapons.JuiceBottleOrange");
			break;
			case 3:
				ReplaceWith(Other,"FoodFightWeapons.JuiceBottleGrape");
			break;
			case 4:
				ReplaceWith(Other,"FoodFightWeapons.JuiceBottleOrange");
			break;
		}
      return false;
   }
//Assorted pickups
   if(Other.Class==Class'UDamage')
   {
      ReplaceWith(Other,"FoodFightWeapons.CoffeePickup");
      return false;
   }
   if(Other.Class==Class'UT_JumpBoots')
   {
      ReplaceWith(Other,"FoodFightWeapons.JellyJumper");
      return false;
   }
   bSuperRelevant = 0;
   return true;
}

function ModifyPlayer(Pawn Other)
{
   local inventory inv;

   if (stopPlayerCollision == true)
      Other.bBlockPlayers = false;
      
   GiveWeapon(Other,class'FoodFightWeapons.CanOpener');
   GiveWeapon(Other,class'FoodFightWeapons.FryingPan');

   if (bUseSpawnProt)
   {
      Inv = Other.FindInventoryType(class'SpawnProtEffect');
      if ( Inv != None )
         SpawnProtEffect(Inv).Duration = SpawnProtDuration;
      else
      {
         inv = Spawn(class'SpawnProtEffect');
         if( inv != None )
         {
            SpawnProtEffect(Inv).Duration = SpawnProtDuration;
            inv.GiveTo(Other);
            inv.Activate();
         }
      }
   }
   if(GiveAllWeapons)
   {
      GiveWeapon(Other,class'FoodFightWeapons.CanOpener');
      GiveWeapon(Other,class'FoodFightWeapons.FryingPan');
      GiveWeapon(Other,class'FoodFightWeapons.PeanutGun');
      GiveWeapon(Other,class'FoodFightWeapons.PapriCannonGun');
      GiveWeapon(Other,class'FoodFightWeapons.HAnKARifle');
      GiveWeapon(Other,class'FoodFightWeapons.Toastanator');
      GiveWeapon(Other,class'FoodFightWeapons.SaladThrower');
      //GiveWeapon(Other,class'');
   }

   if ( NextMutator != None )
      NextMutator.ModifyPlayer(Other);
}

//Handler for the weapon giving
function GiveWeapon(Pawn PlayerPawn, class<TournamentWeapon> WeaponClass )
{
   local Weapon NewWeapon;

   if( PlayerPawn.FindInventoryType(WeaponClass) != None )
      return;
   newWeapon = Spawn(WeaponClass);
   if( newWeapon != None )
   {
      newWeapon.RespawnTime = 0.0;
      newWeapon.GiveTo(PlayerPawn);
      newWeapon.bHeldItem = true;
      newWeapon.SetSwitchPriority(PlayerPawn);
      newWeapon.WeaponSet(PlayerPawn);
      newWeapon.AmbientGlow = 0;
      PlayerPawn.PendingWeapon = None;
      if ( !newWeapon.IsA('FryingPan'))
      {
	 		newWeapon.GiveAmmo(PlayerPawn);
	 		newWeapon.AmmoType.AmmoAmount = newWeapon.AmmoType.MaxAmmo;
      }
   }
}

/*
function bool AlwaysKeep(Actor Other)
{
	//holding class
	if (NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));

	return false;
}
*/

defaultproperties
{
   DMGameName="FoodFight!"
   DMLeftMessage=" has left the kitchen!!!"
   DMEnteredMessage=" has entered the kitchen!!!"
   bUseSpawnProt=True
   SpawnProtDuration=5
   GiveAllWeapons=False
   stopPlayerCollision=True
}
