//=============================================================================
// Wall hit effect class.
//=============================================================================
class FFWallHitEffect expands UT_WallHit;

simulated function SpawnEffects()
{
	local Actor A;
	local int j;
	local int NumSparks;

	SpawnSound();

	NumSparks = rand(MaxSparks);
	for ( j=0; j<MaxChips; j++ )
		if ( FRand() < ChipOdds ) 
		{
			NumSparks--;
			A = spawn(class'Chip');
			if ( A != None )
				A.RemoteRole = ROLE_None;
		}
	
	A = Spawn(class'UT_SpriteSmokePuff');
	A.RemoteRole = ROLE_None;
	if ( !Region.Zone.bWaterZone && (NumSparks > 0) ) 
		for (j=0; j<NumSparks; j++) 
			spawn(class'UT_Spark',,,Location + 8 * Vector(Rotation));
}

