//=============================================================================
// FFWeapon -> abstract
//=============================================================================
class FFWeapon extends TournamentWeapon
		abstract;

////////////////////////////////////////////////////
//////////////////Functions/////////////////////////
////////////////////////////////////////////////////  
function BringUp() {
	super.BringUp();
	AmmoType.Gotostate('Active');
}

function ProcessTraceHitEffect(Actor Other, ConsumableAmmo consumable, Vector HitLocation, Vector HitNormal) {

	if ( !Level.bHighDetailMode )
		return;

	if ( Level.bDropDetail )
		return;

	if (Other == Level) 
	{	
		if(consumable.spawnAtHitLoc != None) {
			Spawn(consumable.spawnAtHitLoc,,, HitLocation+HitNormal, Rotator(HitNormal)).SetVelocity(HitNormal*50);
		}
		Spawn(class'FFWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
		Spawn(consumable.splat,,, HitLocation+HitNormal, Rotator(HitNormal));
	}
}

simulated function PlayReloading()
{
	//Pawn(Owner).ClientMessage("Play reloading called");
	PlayAnim('Reload',0.5,0.05);
}

////////////////////////////////////////////////////
//////////////////States////////////////////////////
////////////////////////////////////////////////////
state DownWeapon {
	function BeginState() {
		AmmoType.Gotostate('Idle2');
		super.BeginState();
	}
}
// End Class
//=============================================================================
defaultproperties
{
}
