/*
To do:

Left hand model
Alt-fire
Knockback?
*/

class FryingPan extends TournamentWeapon;

#exec MESH IMPORT MESH=FryingPanAnimated ANIVFILE=MODELS\FryingPanAnimated_a.3d DATAFILE=MODELS\FryingPanAnimated_d.3d X=0 Y=0 Z=0 UNMIRROR=1
//#exec MESH ORIGIN MESH=FryingPanAnimated X=0 Y=0 Z=0 PITCH=-10 ROLL=10 YAW=-128    //Other hand (original)
#exec MESH ORIGIN MESH=FryingPanAnimated X=0 Y=0 Z=0 PITCH=-10 ROLL=10 YAW=0

#exec MESH SEQUENCE MESH=FryingPanAnimated SEQ=All STARTFRAME=0 NUMFRAMES=72
#exec MESH SEQUENCE MESH=FryingPanAnimated SEQ=Still STARTFRAME=1 NUMFRAMES=1
#exec MESH SEQUENCE MESH=FryingPanAnimated SEQ=PrimaryAttack STARTFRAME=2 NUMFRAMES=17
#exec MESH SEQUENCE MESH=FryingPanAnimated SEQ=SecondaryAttackStart STARTFRAME=19 NUMFRAMES=3
#exec MESH SEQUENCE MESH=FryingPanAnimated SEQ=SecondaryCharge STARTFRAME=22 NUMFRAMES=24
//#exec MESH SEQUENCE MESH=FryingPanAnimated SEQ=SecondaryRelease STARTFRAME=46 NUMFRAMES=26 //altered to look better
#exec MESH SEQUENCE MESH=FryingPanAnimated SEQ=SecondaryRelease STARTFRAME=46 NUMFRAMES=10
#exec MESH SEQUENCE MESH=FryingPanAnimated SEQ=Select STARTFRAME=61 NUMFRAMES=6
#exec MESH SEQUENCE MESH=FryingPanAnimated SEQ=Deselect STARTFRAME=67 NUMFRAMES=5

#exec MESHMAP NEW MESHMAP=FryingPanAnimated MESH=FryingPanAnimated
#exec MESHMAP SCALE MESHMAP=FryingPanAnimated X=0.1 Y=0.1 Z=0.2

#exec TEXTURE IMPORT NAME=SimpleGloveHandTexture FILE=SimpleGloveHandTexture.bmp GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=SimpleGloveHandTexture FILE=SimpleGloveHandTexture.bmp GROUP=Skins PALETTE=SimpleGloveHandTexture
#exec MESHMAP SETTEXTURE MESHMAP=FryingPanAnimated NUM=1 TEXTURE=SimpleGloveHandTexture

#exec TEXTURE IMPORT NAME=FPTexture FILE=FPTexture.bmp GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=FPTexture FILE=FPTexture.bmp GROUP=Skins PALETTE=FPTexture
#exec MESHMAP SETTEXTURE MESHMAP=FryingPanAnimated NUM=2 TEXTURE=FPTexture

// Pickup
#exec MESH IMPORT MESH=FryingPanPickup ANIVFILE=MODELS\FryingPanPickup_a.3d DATAFILE=MODELS\FryingPanPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=FryingPanPickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=FryingPanPickup SEQ=All STARTFRAME=0 NUMFRAMES=1
//#exec MESH SEQUENCE MESH=FryingPanPickup SEQ=??? STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=FryingPanPickup MESH=FryingPanPickup
#exec MESHMAP SCALE MESHMAP=FryingPanPickup X=0.05 Y=0.05 Z=0.1

#exec TEXTURE IMPORT NAME=FPTexture FILE=FPTexture.bmp GROUP=Skins FLAGS=2
#exec TEXTURE IMPORT NAME=FPTexture FILE=FPTexture.bmp GROUP=Skins PALETTE=FPTexture
#exec MESHMAP SETTEXTURE MESHMAP=FryingPanPickup NUM=1 TEXTURE=FPTexture
#exec MESHMAP SETTEXTURE MESHMAP=FryingPanPickup NUM=2 TEXTURE=FPTexture
#exec MESHMAP SETTEXTURE MESHMAP=FryingPanPickup NUM=3 TEXTURE=FPTexture
#exec MESHMAP SETTEXTURE MESHMAP=FryingPanPickup NUM=4 TEXTURE=FPTexture

//Sounds 
#exec AUDIO IMPORT FILE="Sounds\Bong1.Wav" NAME=Bong1 GROUP="Pan"
#exec AUDIO IMPORT FILE="Sounds\Gong1.Wav" NAME=Gong1 GROUP="Pan"
#exec AUDIO IMPORT FILE="Sounds\Swoosh.Wav" NAME=Swoosh GROUP="Pan"
#exec AUDIO IMPORT FILE="Sounds\Swoosh1.Wav" NAME=Swoosh1 GROUP="Pan"
#exec AUDIO IMPORT FILE="Sounds\PanSplat.Wav" NAME=PanSplat GROUP="Pan"


var int PanDamage;
var sound Swing, Swing1, Bong;
var bool bselected;
var pawn oldowner;
var PlayerPawn LastHit;


// No crosshairs
simulated function PostRender(canvas Canvas)
{
   Super.PostRender(Canvas);
   bOwnsCrossHair = bSelected;
   if (bOwnsCrossHair)
   {
      Canvas.SetPos(0.5 * Canvas.ClipX - 8, 0.5 * Canvas.ClipY - 8);
      Canvas.Style = 2;
      Canvas.Style = 1;
   }
}

function float RateSelf(out int bUseAltMode)
{
   local float EnemyDist;
   local bool bRetreating;
   local vector EnemyDir;

   bUseAltMode = 0;

   if ((Pawn(Owner) == None) || (Pawn(Owner).Enemy == None))
      return 0;

   EnemyDist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
   if (EnemyDist > 400)
      return -2;

   if (EnemyDist < 110)
      bUseAltMode = 0;

   return (FMin(1.0, 81/(EnemyDist + 1)));
}

// Deselect
function TweenDown() 
{
   local float SpeedScale;

   bSelected = false;

   PlayAnim('Deselect', 1.0, 0.05);
   //Owner.PlaySound(Misc1Sound, SLOT_None, Pawn(Owner).SoundDampening);

   if ( Level.Game.IsA('DeathMatchPlus') && DeathMatchPlus(Level.Game).bMegaSpeed )
      SpeedScale = 1.3;
   else SpeedScale = 1.0;
   Pawn(Owner).AirControl = DeathMatchPlus(Level.Game).AirControl;
   Pawn(Owner).JumpZ = Pawn(Owner).Default.JumpZ * Level.Game.PlayerJumpZScaling();
   Pawn(Owner).GroundSpeed = Pawn(Owner).Default.GroundSpeed * SpeedScale;
   Pawn(Owner).WaterSpeed = Pawn(Owner).Default.WaterSpeed * SpeedScale;
   Pawn(Owner).AirSpeed = Pawn(Owner).Default.AirSpeed * SpeedScale;
   Pawn(Owner).Acceleration = Pawn(Owner).Default.Acceleration * SpeedScale;
}

// Select
function PlaySelect()
{
	//Playsound(Selectsound);
	if (!IsAnimating() || (AnimSequence != 'Select'))
           PlayAnim('Select',1.0,0.0);

	oldowner = pawn(owner);
	bSelected = true;
	
	oldowner.AirControl = 0.65;
        oldowner.JumpZ *= 1.2;
        oldowner.GroundSpeed *= 1.5;
        oldowner.WaterSpeed *= 1.5;
        oldowner.AirSpeed *= 1.5;
        oldowner.Acceleration *= 1.5;
}


function Fire(float value) 
{
	GotoState('NormalFire');
}

function AltFire(float value) 
{
	GotoState('AltFiring');
}

state NormalFire
{
   function Beginstate()
   {
      local vector X,Y,Z, dir, HitLocation, backforce;
      local actor E;
      local float viewangle;

      viewangle=cos(PI*150/360);

      GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);

      foreach RadiusActors(class'Actor', E, 100, Owner.Location)
      {
         dir=E.Location-Owner.Location;

         if((normal(dir) DOT normal(X)) > viewangle)
         {
            if (E.IsA('PlayerPawn') || E.IsA('Bot'))
            {
               E.TakeDamage(60.0, Pawn(Owner), HitLocation, 6000.0 * X, 'cut');
	       PlaySound(sound'Gong1', SLOT_None, 150);
	       spawn(class'SpriteSmokePuff',,,HitLocation);
            }
            else if (E.IsA('Carcass'))
            {
               PlaySound(sound'PanSplat', SLOT_None, 150);
               E.TakeDamage(100, Pawn(Owner), HitLocation, 3000.0*X, 'gibbed');
            }
         }
      }
   }
Begin:
   PlayAnim('PrimaryAttack',1);
   Owner.PlaySound(Swing, SLOT_None,1.0*Pawn(Owner).SoundDampening);
   FinishAnim();
   GotoState('Idle');
}

state AltFiring 
{
   function BeginState()
   {
      local vector X,Y,Z, dir, HitLocation, backforce;
      local actor E;
      local float viewangle;

      viewangle=cos(PI*150/360); // Viewangle

      GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);

      // No bot usage
      if(pawn(owner).Isa('bot'))
	 return;

      //playanim('SecondaryAttackStart');
      playanim('SecondaryRelease',0.5);
      Owner.PlaySound(Swing1, SLOT_None,1.0*Pawn(Owner).SoundDampening);

      // Will all be redone
      foreach RadiusActors(class'Actor', E, 100, Owner.Location)
      {
         dir=E.Location-Owner.Location;

         if((normal(dir) DOT normal(X)) > viewangle)
         {
            if ( E.IsA('PlayerPawn') || E.IsA('Bot') )
            {
               E.TakeDamage(60.0, Pawn(Owner), HitLocation, 6000.0 * X, 'cut');
	       PlaySound(sound'Gong1', SLOT_None, 150);
	       spawn(class'SpriteSmokePuff',,,HitLocation);
            }
            else if ( E.IsA('Carcass') )
            {
               PlaySound(sound'PanSplat', SLOT_None, 150);
               E.TakeDamage(100, Pawn(Owner), HitLocation, 3000.0*X, 'gibbed');
            }
            else if ( E.IsA('Projectile') )
            {
               //Replace these with the excluded projectile classes (to be decided by papercoffee)
               if(E.IsA('Chunk') || E.IsA('Fragment') || E.IsA('ShellCase') || E.IsA('DispersionAmmo') || E.IsA('BioGel'))
	          return;
               // Knockback
	       E.Velocity-=(E.Velocity-vsize(E.velocity)*normal(dir));
               E.SetRotation(rotator(normal(E.velocity)));
	       Owner.PlaySound(Bong, SLOT_None,2.0*Pawn(Owner).SoundDampening);
	    }
         }
      }
   }
Begin:
   finishanim();
   GotoState('Idle');
}

state Idle
{
Begin:
   if (Pawn(Owner).bFire!=0)  Fire(0.0);
   if (Pawn(Owner).bAltFire!=0) AltFire(0.0);
   LoopAnim('Still');
   bPointing=False;
}


// Set your hand, left or right
// FIXME
function setHand(float Hand) 
{
   local rotator newRot;

   Super.SetHand(Hand);
   if ( Hand == 1 ) 
   {
      Mesh = mesh'FryingPanAnimated';
   } 
   else 
   {
      Mesh = mesh'FryingPanAnimated';
   }
}

defaultproperties
{
   PanDamage=50
   Swing=Sound'Swoosh'
   Swing1=Sound'Swoosh1'
   Bong=Sound'Bong1'
   bMeleeWeapon=True
   AIRating=0.50
   AltRefireRate=0.00
   
   //NEED    needs a pickup sound too
   //SelectSound=Sound'Need?'
   //Misc1Sound=Sound'Need?'

   PickupMessage="You found a Frying Pan!"
   ItemName="Frying Pan"
   ItemArticle="a"
   
   //SET?
   PlayerViewOffset=(X=10.00,Y=-2.00,Z=-4.00),
   PlayerViewMesh=LodMesh'FryingPanAnimated'
   PlayerViewScale=0.20

   PickupViewMesh=LodMesh'FryingPanPickup'
   ThirdPersonMesh=LodMesh'FryingPanPickup'
   ThirdPersonScale=0.50
   MaxDesireability=0.80
   Mesh=LodMesh'FryingPanAnimated'
   SoundVolume=96
   CollisionRadius=15.00
   CollisionHeight=15.00
}
